package org.j69.eewiki.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

import org.j69.eewiki.wiki.Wiki;


public class EditAction extends org.apache.struts.action.Action {

	private static final int RET_YES = 1;
	private static final int RET_NO = 0;
	 
    //------------------------------------------------------------ Local Forwards
	private static final String FORWARD_View = "View";

    //------------------------------------------------------------ Action Methods

    public ActionForward execute(ActionMapping mapping, ActionForm form,
         HttpServletRequest request, HttpServletResponse response)
        throws Exception {

		//メッセージリソース
		MessageResources msg = getResources(request);

        //ページIDパラメータの取得
        String pid = request.getParameter("pid");

        //表示するコンテンツのタイプを設定
        request.setAttribute("contentType", "edit");

        //コンテンツ格納
        Wiki wiki = new Wiki(pid, request, msg);
        request.setAttribute("content" , wiki);

        //TODO 編集可能のページか？パスワードがいるか？などのチェック
        if (wiki.isFrozen() == RET_YES) {
            request.setAttribute("contentType", "content");
            request.setAttribute("error_id" , msg.getMessage(request.getLocale(), "error.isfrozen", ""));
        }
        else if (wiki.isFixedPage() == RET_YES) {
            request.setAttribute("contentType", "content");
            request.setAttribute("error_id" , msg.getMessage(request.getLocale(), "error.isfixed", ""));
        }

        //Viewpageに遷移元を伝える
        request.setAttribute("from_id", "Editpage");

        return mapping.findForward(FORWARD_View);

    }

}