package org.j69.eewiki.action;

import java.util.Vector;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.j69.eewiki.util.CacheConfig;
import org.j69.eewiki.util.WebUtil;
import org.j69.eewiki.wiki.Wiki;
import org.j69.eewiki.wiki.WikiList;

/**
 * QueryAction.java created by EasyStruts - XsltGen.
 * http://easystruts.sf.net
 * created on 05-31-2003
 *
 * XDoclet definition:
 * @struts:action path="/Query" name="Form" input="/form/.jsp" validate="true"
 * @struts:action-forward name="/List.do" path="/List.do"
 */
public class QueryAction extends Action {

    //------------------------------------------------------------ Local Forwards
    static final private String FORWARD_View = "View";

    // コンフィグ
    private final static CacheConfig config_ = CacheConfig.getInstance( );

    /**
     * Method execute
     * @param ActionMapping mapping
     * @param ActionForm form
     * @param HttpServletRequest request
     * @param HttpServletResponse response
     * @return ActionForward
     * @throws Exception
     */
    public ActionForward execute(
        ActionMapping mapping,
        ActionForm form,
        HttpServletRequest request,
        HttpServletResponse response)
        throws Exception {

		//メッセージリソース
		MessageResources msg = getResources(request);

        String pid ="";
        String queryword = "";

        //遷移元によって検索文字列の取得方法を変更
        if (form == null) {
            //ナビゲータから
            queryword = request.getParameter("queryword");
        }
        else {
            //単語入力ホームから
            QueryForm queryform = (QueryForm) form;
            queryword = queryform.getQueryword();
        }


        //表示するコンテンツのタイプを設定
        request.setAttribute("contentType", "lists");

		//コンテンツ格納(Listページを設定)
		String linkName = WebUtil.getEncodeFileName(config_.getConfig("define.pagename.list"));
		Wiki wiki = new Wiki(linkName, request, msg);
		request.setAttribute("content" , wiki);

		//検索単語を遷移先を伝える
		if (!queryword.equals("")) {
	
	        //WikiListの作成
	        WikiList wikilist = new WikiList(wiki.getBasePath());
	        Vector datas = wikilist.getWikiFiles(queryword, "title", true);
	        request.setAttribute("lists", datas);
	
	        //検索結果なしの場合その旨を表示する
	        if (datas.isEmpty()) {
	            request.setAttribute("error_id" , msg.getMessage(request.getLocale(), "error.nofound", ""));
	        }
			request.setAttribute("qword", WebUtil.getEncodeFileName(queryword));
		}
		else {
			request.setAttribute("error_id" , msg.getMessage(request.getLocale(), "error.nofound", ""));
		}

        //Viewpageに遷移元を伝える
        request.setAttribute("from_id", "Querypage");

        return mapping.findForward(FORWARD_View);

    }
}
