package org.j69.eewiki.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.j69.eewiki.util.CacheConfig;
import org.j69.eewiki.wiki.Wiki;

/**
 * UplaodAction.java created by EasyStruts - XsltGen.
 * http://easystruts.sf.net
 * created on 06-07-2003
 *
 * XDoclet definition:
 * @struts:action path="/Upload" name="UploadForm" input="/form/.jsp" validate="true"
 */
public class UplaodAction extends Action {

    //------------------------------------------------------------ Local Forwards
    static final private String FORWARD_Upload = "Upload";

    // コンフィグ
    private final static CacheConfig config_ = CacheConfig.getInstance( );

    // --------------------------------------------------------- Methods

    /**
     * Method execute
     * @param ActionMapping mapping
     * @param ActionForm form
     * @param HttpServletRequest request
     * @param HttpServletResponse response
     * @return ActionForward
     * @throws Exception
     */
    public ActionForward execute(
        ActionMapping mapping,
        ActionForm form,
        HttpServletRequest request,
        HttpServletResponse response)
        throws Exception {

		//メッセージリソース
		MessageResources msg = getResources(request);

        //コンテンツ格納
        Wiki wiki = new Wiki(request.getParameter("pid"), request, msg);
        request.setAttribute("content" , wiki);

        //表示するコンテンツのタイプを設定
        request.setAttribute("contentType", "upload");

        //Viewpageに遷移元を伝える
        request.setAttribute("from_id", "Uploadpage");

        return mapping.findForward(FORWARD_Upload);

    }

}
