package org.j69.eewiki.wiki.transformer;

/**
 * 一行のデータに対応するクラスのインタフェース
 *
 * @see DataLineCreator
 */
public interface DataLine {

    /**
     * 初期化
     *
     * @param lineData データ行
     **/
    public void init(String lineData);

    /**
     * データの外側を挟む開始タグ取得
     * 必要ない場合は、長さ0の文字列「""」を返す
     *
     * @param oldLine 前の行データ
     * @return データの外側を挟む開始タグ
     **/
    public String openTag(DataLine oldLine);

    /**
     * データの外側を挟む終了タグ取得
     * 必要ない場合は、長さ0の文字列「""」を返す
     *
     * @param newLine 次の行データ
     * @return データの外側を挟む終了タグ
     **/
    public String closeTag(DataLine newLine);

    /**
     * 行データ
     * データを直接挟むタグ等は一緒に付加する
     *
     * @return 行データ
     **/
    public String get(int row);

    /**
     * 行データを特定のタグに
     * マッピングするための行頭のキーワード
     * 例：「----」「,」「*」
     *
     * @return キーワード
     **/
    public String getKeyword();
}