package generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;

import elazyrest.i18n.MessageResourceBundle;
import elazyrest.i18n.ResourceBundleEx;

import elazyrest.core.annotation.RestMethod;
import elazyrest.core.annotation.RestParam;
import elazyrest.core.annotation.SimpleXml;

public class DocGen {

	private String packageName = "elazyrest.service"; //rename
	private String docRoot = "gen/sample/";
	private String endPoint = "http://localhost:8080/elazyrest"; // rename
	private static String lineSep = System.getProperty("line.separator");
	private static MessageResourceBundle paramResource;
    static {
        try {
        	paramResource = new MessageResourceBundle(ResourceBundleEx.getBundle("resources/param_resource"));
        } catch (Exception x) {
        	paramResource = null;
        }
    }
	private StringBuffer indexHTML = null;

	public DocGen() {
		
	}

	public DocGen(String packageName, String docRoot, String endPoint) {
		this.packageName = packageName;
		if (docRoot != null && !docRoot.endsWith("/")) {
			docRoot += "/";
		}
		this.docRoot = docRoot;
		this.endPoint = endPoint;
	}
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		String packageName = null;
		String docRoot = null;
//		if (args.length > 0) {
//			packageName = args[0];
//		}
//		if (args.length > 1) {
//			docRoot = args[1];
//		}
		
//		HTMLFormGenerator self = new HTMLFormGenerator(packageName, docRoot);
		DocGen self = new DocGen();
		try {
			self.generate();
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public void generate() {
		
		indexHTML = new StringBuffer("<html>"+lineSep+"<body>" +lineSep);
		indexHTML.append("<h1>API hLg</h1>" +lineSep);
		indexHTML.append("<h2>T[rXꗗ</h2>" +lineSep);
		try {
			File root = new File(docRoot);
			if (!root.exists()) {
				root.mkdir();
			}
			File formRoot = new File(docRoot +"form");
			if (!formRoot.exists()) {
				formRoot.mkdir();
			}
			File phpRoot = new File(docRoot +"php");
			if (!phpRoot.exists()) {
				phpRoot.mkdir();
			}
			File smartyRoot = new File(docRoot +"smarty");
			if (!smartyRoot.exists()) {
				smartyRoot.mkdir();
			}
			
			URL serviceRoot = this.getClass().getClassLoader().getResource(packageName.replace('.', '/'));
			if (serviceRoot != null) {
				File dir = new File(serviceRoot.getPath());
				generate(dir, packageName);
			}
		}
		finally {
			try {
				indexHTML.append("</body>" +lineSep +"</html>");
				
				String formFileName = docRoot +"index.html";
				PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(formFileName)));
				pw.write(indexHTML.toString());
				pw.flush();
				pw.close();

			}
			catch (Exception e) {
				//
			}
			
		}
				
	}

	private void generate(File file, String parentPackage) {
		String filename = file.getName();
		if (file.isDirectory()) {
			File[] flist = file.listFiles();
			String packname = null; 
			if (file.getName().equals("classes") ||
				(parentPackage != null && parentPackage.endsWith(file.getName()))) {
				packname = parentPackage;
			}
			else {
				packname = parentPackage.length() > 0? parentPackage +"." +file.getName(): file.getName();
			}
			if (flist != null && flist.length > 0) {
				for (File childFile : flist) { 
					generate(childFile, packname);
				}
			}
		}
		if (!file.getName().endsWith(".class")) {
			return;
		}
		String clname = null;
		
		if (parentPackage != null && parentPackage.length() > 0) {
			clname = parentPackage +"." +filename.substring(0, filename.lastIndexOf('.'));
		}
		else {
			clname = filename.substring(0, filename.lastIndexOf('.'));
		}
		this.genClDoc(clname.replace('/', '.'));
	}

	private void genClDoc(String clName) {
		try {
			
			Class cl = Class.forName(clName);
			
			String clFileName = cl.getName().substring(cl.getName().lastIndexOf('.') + 1);
			// Is SimpleXml?
			if (!cl.isAnnotationPresent(SimpleXml.class)) {
				return ;
			}
			indexHTML.append("<a href=\"" +clFileName +".html\">" +clFileName +"</a><br>" +lineSep);

			StringBuffer classDoc = new StringBuffer("<html>"+lineSep+"<body>" +lineSep);

			classDoc.append("<h1>" +clFileName +"</h1>" +lineSep);

			Method[] methods = cl.getMethods();
			for(Method targetMethod : methods) {

				// Is RestMethod?
				if (!targetMethod.isAnnotationPresent(RestMethod.class)) {
					//log.debug(methodName +" is not RestMethod.");
					continue;
				}
				genMethDoc(clFileName, targetMethod);
				genMethForm(clFileName, targetMethod);
				genPHP(clFileName, targetMethod);
				genSmarty(clFileName, targetMethod);
				classDoc.append("<a href=\""+clFileName +"." +targetMethod.getName() +".html\">" +clFileName +"." +targetMethod.getName() +"</a>" +"<br>" +lineSep);

			}
			classDoc.append("</body>" +lineSep +"</html>");
			
			
			String classDocName = docRoot +clFileName +".html";
			PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(classDocName)));
			pw.write(classDoc.toString());
			pw.flush();
			pw.close();
			
		}
		catch (ClassNotFoundException e) {
			e.printStackTrace();
		}
		catch (IOException e) {
			e.printStackTrace();
		}
	}

	private void genMethDoc(String clName, Method method) {
		String[] allowMethods = method.getAnnotation(RestMethod.class).value();

		StringBuffer methodDoc = new StringBuffer("<html>" +lineSep +"<body>");
		methodDoc.append("<h1>" +clName +"." +method.getName() +"</h1>" +lineSep);
		//methodDoc.append("<div></div>" +lineSep);
		methodDoc.append("<h2>Gh|Cg</h2>" +lineSep);
		methodDoc.append(endPoint +"<br>" +lineSep);
		methodDoc.append("<h2>p[^</h2>" +lineSep);
		methodDoc.append("<strong>method</strong>: " +clName +"." +method.getName() +"<br>" +lineSep);

		Annotation[][] paramAnnotation = method.getParameterAnnotations();
		
		// request parameter to rest method parameter
		for (int i = 0; i < paramAnnotation.length; i++) {
			for (int j = 0; j < paramAnnotation[i].length; j++) {
				if (paramAnnotation[i][j].annotationType() == RestParam.class) {
					RestParam restParam = (RestParam)paramAnnotation[i][j];
					String key = restParam.name();
					String keyDescription = key;
					if (paramResource != null) {
						String description = paramResource.getString(clName +"." +method.getName() +"." +key);
						if (description != null && description.length() > 0) {
							keyDescription = description;
						}
					}
					methodDoc.append("<strong>" +key +"</strong>: "+keyDescription +"<br>" +lineSep);
				}
			}
		}
		methodDoc.append("</body>" +lineSep +"</html>");
		
		methodDoc.append("<h2>Tv</h2>" +lineSep);
		methodDoc.append("<a href=\"" +"form/" +clName +"." +method.getName() +".html" +"\">html</a><br>" +lineSep);
		methodDoc.append("<a href=\"" +"php/" +clName +"." +method.getName() +".php.txt" +"\">php</a><br>" +lineSep);
		methodDoc.append("smarty(<a href=\"" +"smarty/" +clName +"." +method.getName() +".php.txt" +"\">php</a>" +lineSep);
		methodDoc.append("<a href=\"" +"smarty/" +clName +"." +method.getName() +".tpl.txt" +"\">template</a>)" +lineSep);
		methodDoc.append("<h2>X|X</h2>" +lineSep);
		methodDoc.append("</body></html>");
		
		methodDoc.append("<h2>G[ R[h</h2>" +lineSep);		
		String methodFileName = docRoot +clName +"." +method.getName() +".html";
		
		try {
			PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(methodFileName)));
			pw.write(methodDoc.toString());
			pw.flush();
			pw.close();
			
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	private void genMethForm(String clName, Method method) {
		String[] allowMethods = method.getAnnotation(RestMethod.class).value();

		StringBuffer methodDoc = new StringBuffer("");
		methodDoc.append("<h1>" +clName +"." +method.getName() +"</h1>" +lineSep);
		methodDoc.append("<form action=\"" +endPoint +"\" method=\"" +allowMethods[0].toLowerCase() +"\" target=\"_result\">" +lineSep);
		methodDoc.append("<input type=\"hidden\" name=\"method\" value=\""+clName +"." +method.getName() +"\"/>" +lineSep);

		Annotation[][] paramAnnotation = method.getParameterAnnotations();
		
		// request parameter to rest method parameter
		for (int i = 0; i < paramAnnotation.length; i++) {
			for (int j = 0; j < paramAnnotation[i].length; j++) {
				if (paramAnnotation[i][j].annotationType() == RestParam.class) {
					RestParam restParam = (RestParam)paramAnnotation[i][j];
					String key = restParam.name();
					String keyDescription = key;
					if (paramResource != null) {
						String description = paramResource.getString(clName +"." +method.getName() +"." +key);
						if (description != null && description.length() > 0) {
							keyDescription = description;
						}
					}
					methodDoc.append(keyDescription +":<input type=\"text\" name=\"" +key +"\" value=\"\"/><br>" +lineSep);
				}
			}
		}
		methodDoc.append("<input type=\"submit\" name=\"submit\"/>" +lineSep);
		methodDoc.append("</form>" +lineSep);
		

		StringBuffer htmlText = new StringBuffer("<html>" +lineSep +"<body>");
		htmlText.append(methodDoc +lineSep);
		htmlText.append("<plainText>" +methodDoc +"</plainText>");
		htmlText.append("</body>" +lineSep +"</html>");

		String methodFileName = docRoot +"form/" +clName +"." +method.getName() +".html";

		try {
			PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(methodFileName)));
			pw.write(htmlText.toString());
			pw.flush();
			pw.close();
			
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	

	private void genPHP(String clName, Method method) {
		String[] allowMethods = method.getAnnotation(RestMethod.class).value();

		StringBuffer phpDoc = new StringBuffer();
		phpDoc.append("<h1>" +clName +"." +method.getName() +"</h1>" +lineSep);
		phpDoc.append("<form action=\"\" method=\"" +allowMethods[0].toLowerCase() +"\">" +lineSep);

		StringBuffer phpFile = new StringBuffer(); 
		StringBuffer phpReqStr = new StringBuffer("if ($isSubmit) {");
		phpReqStr.append(lineSep);
		phpReqStr.append("$submiturl = \"$serverUrl?method=" +clName +"." +method.getName() +"\";" +lineSep);
		phpReqStr.append("$queries = array(" +lineSep);
		phpFile.append("<?php"+lineSep +"require_once('common.php');" +lineSep +lineSep);
		
//				Class[] paramTypes = targetMethod.getParameterTypes();

		Annotation[][] paramAnnotation = method.getParameterAnnotations();
		
		// request parameter to rest method parameter
		for (int i = 0; i < paramAnnotation.length; i++) {
			if (i != 0) {
				phpReqStr.append("," +lineSep);
			}
			for (int j = 0; j < paramAnnotation[i].length; j++) {
				if (paramAnnotation[i][j].annotationType() == RestParam.class) {
					RestParam restParam = (RestParam)paramAnnotation[i][j];
					String key = restParam.name();
					String keyDescription = key;
					if (paramResource != null) {
						String description = paramResource.getString(clName +"." +method.getName() +"." +key);
						if (description != null && description.length() > 0) {
							keyDescription = description;
						}
					}
					phpDoc.append(keyDescription +":<input type=\"text\" name=\"" +key +"\" value=\"<?php echo $" +key +";?>\"/><br>" +lineSep);
					phpFile.append("$" +key +" = $_REQUEST['" +key +"'];" +lineSep);
					phpReqStr.append("'" +key +"'=>" +"$" +key);
				}
			}
		}
//			methodDoc.append("<input type=\"submit\" name=\"submit\"/>" +lineSep);
		phpDoc.append("</form>" +lineSep);
		phpDoc.append("<input type=\"submit\" name=\"submit\"/>" +lineSep);
		phpDoc.append("</form>" +lineSep);
		phpReqStr.append(");" +lineSep +lineSep);
		phpReqStr.append("$res = simplexml_load_file_with_" +allowMethods[0].toLowerCase() +"($submiturl, $queries, getwsseheader());" +lineSep);
		phpReqStr.append("if ($res->status == 0) {" +lineSep);
		phpReqStr.append("header(\"Location: xxxx\". \"?\".htmlspecialchars( SID ));" +lineSep);
		phpReqStr.append("exit;" +lineSep +"}" +lineSep +"}" +lineSep);
		
		phpFile.append("$isSubmit = $_REQUEST['submit'];" +lineSep);
		phpFile.append(phpReqStr +lineSep);
		phpFile.append("?>" +lineSep +lineSep +"<html>"+ lineSep +"<body>" +phpDoc);
		phpFile.append("</body>" +lineSep +"</html>");
		
		String phpFileName = docRoot +"php/" +clName +"." +method.getName() +".php.txt";
		try {
			PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(phpFileName)));
			pw.write(phpFile.toString());
			pw.flush();
			pw.close();
			
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}

	private void genSmarty(String clName, Method method) {
		String[] allowMethods = method.getAnnotation(RestMethod.class).value();

		StringBuffer assignStr = new StringBuffer("require_once('setup.php');" +lineSep);
		assignStr.append("$smarty = new Smarty_CGM();" +lineSep);
		StringBuffer templateStr = new StringBuffer("<html>"+ lineSep +"<body>" +lineSep);
		templateStr.append("<h1>" +clName +"." +method.getName() +"</h1>" +lineSep);
		templateStr.append("<form action=\"\" method=\"" +allowMethods[0].toLowerCase() +"\">" +lineSep);

		StringBuffer phpFile = new StringBuffer(); 
		StringBuffer phpReqStr = new StringBuffer("if ($isSubmit) {");
		phpReqStr.append(lineSep);
		phpReqStr.append("$submiturl = \"$serverUrl?method=" +clName +"." +method.getName() +"\";" +lineSep);
		phpReqStr.append("$queries = array(" +lineSep);
		phpFile.append("<?php"+lineSep +"require_once('common.php');" +lineSep +lineSep);
		
//				Class[] paramTypes = targetMethod.getParameterTypes();

		Annotation[][] paramAnnotation = method.getParameterAnnotations();
		
		// request parameter to rest method parameter
		for (int i = 0; i < paramAnnotation.length; i++) {
			if (i != 0) {
				phpReqStr.append("," +lineSep);
			}
			for (int j = 0; j < paramAnnotation[i].length; j++) {
				if (paramAnnotation[i][j].annotationType() == RestParam.class) {
					RestParam restParam = (RestParam)paramAnnotation[i][j];
					String key = restParam.name();
					String keyDescription = key;
					if (paramResource != null) {
						String description = paramResource.getString(clName +"." +method.getName() +"." +key);
						if (description != null && description.length() > 0) {
							keyDescription = description;
						}
					}
					assignStr.append("$smarty->assign('" +key +"', $" +key +");" +lineSep);
					templateStr.append(keyDescription +":<input type=\"text\" name=\"" +key +"\" value=\"{{$" +key +"}}\"/><br>" +lineSep);
					phpFile.append("$" +key +" = $_REQUEST['" +key +"'];" +lineSep);
					phpReqStr.append("'" +key +"'=>" +"$" +key);
				}
			}
		}
		assignStr.append(lineSep +"$smarty->display_ua('XXXXX.tpl');" +lineSep);
		templateStr.append("<input type=\"submit\" name=\"submit\"/>" +lineSep);
		templateStr.append("</form>" +lineSep);
		phpReqStr.append(");" +lineSep +lineSep);
		phpReqStr.append("$res = simplexml_load_file_with_" +allowMethods[0].toLowerCase() +"($submiturl, $queries, getwsseheader());" +lineSep);
		phpReqStr.append("if ($res->status == 0) {" +lineSep);
		phpReqStr.append("header(\"Location: xxxx\". \"?\".htmlspecialchars( SID ));" +lineSep);
		phpReqStr.append("exit;" +lineSep +"}" +lineSep +"}" +lineSep);
		
		phpFile.append("$isSubmit = $_REQUEST['submit'];" +lineSep);
		phpFile.append(phpReqStr +lineSep);
		phpFile.append(lineSep +assignStr +lineSep);
		phpFile.append("?>");
		templateStr.append("</body>" +lineSep +"</html>");
		
		String phpFileName = docRoot +"smarty/" +clName +"." +method.getName() +".php.txt";
		String templateFileName = docRoot +"smarty/" +clName +"." +method.getName() +".tpl.txt";
		try {
			PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(phpFileName)));
			pw.write(phpFile.toString());
			pw.flush();
			pw.close();
			
			pw = new PrintWriter(new BufferedWriter(new FileWriter(templateFileName)));
			pw.write(templateStr.toString());
			pw.flush();
			pw.close();
			
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}
}
