package elazyrest.core.provider;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * 
 * @author kaz
 *
 */
public class InstanceProvider {
	protected Map<Class<?>, Object> instances = new HashMap<Class<?>, Object>();

	private static Log log = LogFactory.getLog(InstanceProvider.class);

	public Object get(Class<?> cl) {
		Object targetInstance = null;
		try {
			synchronized (instances) {
				// CX^X݂ΕԂ
				if (instances.containsKey(cl)) {
					targetInstance = instances.get(cl);
				}
				// ŏ̃ANZXɃCX^X𐶐
				else {
					targetInstance = cl.newInstance();
					instances.put(cl, targetInstance);
				}
			}
			return targetInstance;
		}
		catch (InstantiationException e) {
			log.error(e.getMessage(), e);
			//e.printStackTrace();
			throw new RuntimeException(e);
		}
		catch (IllegalAccessException e) {
			log.error(e.getMessage(), e);
			//e.printStackTrace();
			throw new RuntimeException(e);
		}
	}
	
	public void set(Class<?> cl, Object instance) {
		synchronized (instances) {
			instances.put(cl, instance);
		}
	}
	
	public void clear() {
		synchronized (instances) {
			instances.clear();
		}
	}
}
