/**
 * 
 */
package elazyrest.core.util;


import java.util.Iterator;
import java.util.List;
import java.util.Map;

import elazyrest.core.validator.RestParamError;
import elazyrest.core.validator.RestParamErrors;
import elazyrest.core.xml.response.Response;
import elazyrest.core.xml.response.Response.ValidateErrors;
import elazyrest.core.xml.response.Response.ValidateErrors.ValidateError;


/**
 * @author kaz
 *
 */
public class ResponseGen {
	public static final int SUCCESS = 0;
	public static final int INVALID_PARAMETER = 1;
	public static final int INTERNAL_SERVER_ERROR = 2;
	public static final int DATA_EMPTY = 3;
	public static final int AUTHORIZATION_REQUIRED = 4; 
	public static final int AUTHENTICATION_ERROR = 5;
	public static final int DUPLICATION = 6;
	public static final int FORBIDDEN = 7;
	public static final int NOT_SUPPORTED_METHOD = 8;
	public static final int NOT_SUPPORTED_OPERATION = 9;

	public static Response generateXML(int status, String message) {
		return generateXML(status, message, null);
	}

	public static byte[] generateBinary(byte[] bytes, String contentType) {
		AppContext appContext = AppContext.getContext();
		appContext.setIsBinary(true);
		appContext.setContentType(contentType);
		return bytes;
	}

	public static Response generateXML(int status, String message, String guid) {
		elazyrest.core.xml.response.ObjectFactory of = 
			new elazyrest.core.xml.response.ObjectFactory();

		Response res = of.createResponse();
		res.setStatus(new Integer(status));
		res.setMessage(message);
		res.setGuid(guid);

		return res;
	}

	public static Response generateXML(int status, String message, String guid, RestParamErrors errors) {

		elazyrest.core.xml.response.ObjectFactory of = 
			new elazyrest.core.xml.response.ObjectFactory();

		Response res = of.createResponse();
		res.setStatus(new Integer(status));
		res.setMessage(message);
		res.setGuid(guid);
		// validate error
		ValidateErrors validateErrors = new ValidateErrors();
		List<ValidateError> errorList = validateErrors.getValidateError();

		Map<String, RestParamError> errorMap = errors.getErrors();
		Iterator keyIter = errorMap.keySet().iterator();
		while (keyIter.hasNext()) {
			String key = (String)keyIter.next();
			RestParamError error = errorMap.get(key);
			ValidateError validateError = new ValidateError();
			validateError.setKey(key);
			validateError.setError(error.getResourceKey());
			errorList.add(validateError);
		}
		res.setValidateErrors(validateErrors);
		
		return res;
	}
	
	public static void setResponseEncoding(String enc) {
		AppContext context = AppContext.getContext();
		// set charset
		if (enc != null) {
			context.setResponseEncoding(enc);
		}
	}
}
