package elazyrest.core.validator;

import java.util.regex.Pattern;

import elazyrest.i18n.MessageResourceBundle;
import elazyrest.i18n.ResourceBundleEx;

import elazyrest.core.annotation.RestParam;


/**
 * ValidatorNX
 * RestParamAme[V`Ăp[^p
 * @author kaz
 *
 */
public class RestParamValidator {
//	private static MessageResourceBundle paramResource;
//    static {
//        try {
//        	paramResource = new MessageResourceBundle(ResourceBundleEx.getBundle("resources/param_resource"));
//        } catch (Exception x) {
//        	paramResource = null;
//        }
//    }

	/**
	 * validate
	 * @param value
	 * @param annotation
	 * @return
	 */
	public static boolean validate(String methodName, Object value, RestParam annotation, RestParamErrors errors) {
		String description = annotation.description();
//		if (description == null || description.length() == 0) {
//			if (paramResource != null) {
//				description = paramResource.getString(methodName +"." +annotation.name());
//			}
//		}
		// required check
		if (value == null || 
			value.toString().length() <= 0) {
			if (annotation.required()) {
				errors.add(methodName +"." +annotation.name(), description, "required");
				return false;
			}
			else {
				return true;
			}
		}
		if (value instanceof Object[]) {
			boolean isEmpty = true;
			Object[] vals = (Object[])value;
			if (vals.length > 0) {
				for (Object val: vals) {
					if (val != null && val.toString().length() > 0) {
						isEmpty = false;
						break;
					}
				}
			}
			if (isEmpty) {
				if (annotation.required()) {
					errors.add(methodName +"." +annotation.name(), description, "required");
					return false;
				}
				else {
					return true;
				}
			}
		}

		// z̎
		if (value instanceof Object[]) {
			Object[] values = (Object[])value;
			for (Object val: values) {
				// max length check
				if (!validateMaxLength(val, annotation)) {
					String[] params = {String.valueOf(annotation.maxLength())};
					errors.add(methodName +"." +annotation.name(), description, "max_length", params);
					return false;
				}
				// min length check
				if (!validateMinLength(val, annotation)) {
					String[] params = {String.valueOf(annotation.minLength())};
					errors.add(methodName +"." +annotation.name(), description, "min_length", params);
					return false;
				}
				// pattern check
				if (!validatePattern(val, annotation)) {
					errors.add(methodName +"." +annotation.name(), description, "pattern");
					return false;
				}
			}
		}
		// złȂ
		else {
			// max length check
			if (!validateMaxLength(value, annotation)) {
				String[] params = {String.valueOf(annotation.maxLength())};
				errors.add(methodName +"." +annotation.name(), description, "max_length", params);
				return false;
			}
			// min length check
			if (!validateMinLength(value, annotation)) {
				String[] params = {String.valueOf(annotation.minLength())};
				errors.add(methodName +"." +annotation.name(), description, "min_length", params);
				return false;
			}
			
			// pattern check
			if (!validatePattern(value, annotation)) {
				errors.add(methodName +"." +annotation.name(), description, "pattern");
				return false;
			}

		}
		return true;
	}
	
	/**
	 * max length check
	 * @param value
	 * @param annotation
	 * @return
	 */
	public static boolean validateMaxLength(Object value, RestParam annotation) {
		// max length check
		if (annotation.maxLength() > 0) {
			if (value.toString().length() > annotation.maxLength()) {
				return false;
			}
		}
		return true;
	}

	/**
	 * min length check
	 * @param value
	 * @param annotation
	 * @return
	 */
	public static boolean validateMinLength(Object value, RestParam annotation) {
		// max length check
		if (annotation.minLength() > 0) {
			if (value.toString().length() < annotation.minLength()) {
				return false;
			}
		}
		return true;
	}

	/**
	 * pattern check
	 * @param value
	 * @param annotation
	 * @return
	 */
	public static boolean validatePattern(Object value, RestParam annotation) {
		// pattern check
		if (annotation.pattern().length() > 0) {
			if (!Pattern.matches(annotation.pattern(), value.toString())) {
				return false;
			}
		}
		return true;
	}
}
