using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.Sub;

namespace MinorShift.Emuera.GameData.Expression
{

	/// <summary>
	/// BPꂾB
	/// </summary>
	internal sealed class SingleTerm : IOperandTerm
	{
		public SingleTerm(Int64 i, int fBase)
		{
			type = typeof(Int64);
			iValue = i;
			fromBase = fBase;

		}

		public SingleTerm(bool i)
		{
			type = typeof(Int64);
			if (i)
				iValue = 1;
			else
				iValue = 0;
		}
		public SingleTerm(Int64 i)
		{
			type = typeof(Int64);
			iValue = i;
		}
		public SingleTerm(string s)
		{
			type = typeof(string);
			sValue = s;
		}
		readonly Type type;
		readonly int fromBase = 10;
		readonly Int64 iValue;
		readonly string sValue;

		public string Str
		{
			get
			{
				if (type != typeof(string))
					throw new ExeEE("̎ʂُ");
				return sValue;
			}
		}
		public Int64 Int
		{
			get
			{
				if (type != typeof(Int64))
					throw new ExeEE("̎ʂُ");
				return iValue;
			}
		}
		public override string ToString()
		{
			if (type == typeof(Int64))
				return iValue.ToString();
			if (type == typeof(string))
				return sValue.ToString();
			return base.ToString();
		}

		#region IOperandTerm o
		public bool IsConstant { get { return true; } }
		public Type GetOperandType() { return type; }
		#endregion


		#region IKiriScript o

		public string ToKiriScript()
		{
			if (type == typeof(Int64))
			{
				if ((fromBase == 16)||(fromBase == 2))
					return "0x" + iValue.ToString("X");
				return iValue.ToString();

			}
			else if (type == typeof(string))
			{
				//TODO:GXP[v̒ǉ
				return "\"" + sValue + "\"";
			}
			throw new Exception("The method or operation is not implemented.");
		}

		public string ToErbScript()
		{
			return ToKiriScript();
		}

		public int KiriScriptPriority
		{
			get { return -1; }
		}

		#endregion

	}


	internal sealed class BinaryExpressionTerm : IOperandTerm
	{
		public BinaryExpressionTerm(IOperandTerm leftOp, IOperandTerm rightOp, OperatorCode opCode, BinaryMethod method)
		{
			Left = leftOp;
			Right = rightOp;
			Operator = opCode;
			Method = method;
			type = OperatorMethod.GetReturnType(Left.GetOperandType(), Right.GetOperandType(), Operator);
			isConstant = Left.IsConstant && Right.IsConstant;
		}
		readonly public IOperandTerm Left;
		readonly public IOperandTerm Right;
		readonly public OperatorCode Operator;
		readonly public BinaryMethod Method;
		readonly Type type;
		readonly bool isConstant;

		#region IOperandTerm o

		public bool IsConstant
		{
			get { return isConstant; }
		}

		public Type GetOperandType()
		{
			return type;
		}

		#endregion

		#region IKiriScript o

		public string ToKiriScript()
		{
			StringBuilder str = new StringBuilder();
			int thisPriority = this.KiriScriptPriority;
			int leftPriority = Left.KiriScriptPriority;
			if (leftPriority < thisPriority)
			{
				str.Append("( ");
				str.Append(Left.ToKiriScript());
				str.Append(" ) ");
			}
			else
			{
				str.Append(Left.ToKiriScript());
				str.Append(" ");
			}
			str.Append(OperatorManager.ToOperatorString(Operator));
			str.Append(" ");
			int rightPriority = Right.KiriScriptPriority;
			if (rightPriority <= thisPriority)
			{
				str.Append("( ");
				str.Append(Right.ToKiriScript());
				str.Append(" )");
			}
			else
			{
				str.Append(Right.ToKiriScript());
			}
			return str.ToString();

		}

		public string ToErbScript()
		{
			return ToKiriScript();
		}

		public int KiriScriptPriority
		{
			get
			{
				return OperatorManager.GetPriority(Operator);
			}
		}
		#endregion

	}

	internal sealed class UnaryExpressionTerm : IOperandTerm
	{
		public UnaryExpressionTerm(IOperandTerm operandTerm, OperatorCode opCode, UnaryMethod method)
		{
			Operand = operandTerm;
			Operator = opCode;
			Method = method;
			type = OperatorMethod.GetReturnType(Operand.GetOperandType(), Operator);
		}
		readonly public IOperandTerm Operand;
		readonly public OperatorCode Operator;
		readonly public UnaryMethod Method;
		readonly Type type;

		#region IOperandTerm o


		public bool IsConstant
		{
			get { return Operand.IsConstant; }
		}

		public Type GetOperandType()
		{
			return type;
		}

		#endregion

		#region IKiriScript o

		public string ToKiriScript()
		{
			StringBuilder str = new StringBuilder();
			str.Append(OperatorManager.ToOperatorString(Operator));
			if (Operand.KiriScriptPriority >= 0)
			{
				str.Append("( ");
				str.Append(Operand.ToKiriScript());
				str.Append(" )");
			}
			else
				str.Append(Operand.ToKiriScript());
			return str.ToString();
		}

		public string ToErbScript()
		{
			StringBuilder str = new StringBuilder();
			str.Append(OperatorManager.ToOperatorString(Operator));
			if (Operand.KiriScriptPriority >= 0)
			{
				str.Append("( ");
				str.Append(Operand.ToErbScript());
				str.Append(" )");
			}
			else
				str.Append(Operand.ToErbScript());
			return str.ToString();
		}

		public int KiriScriptPriority
		{
			get { return -1; }
		}
		#endregion

	}
}
