using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameView;
using MinorShift.Emuera.GameData.Expression;

namespace MinorShift.Emuera.GameData.Variable
{
	internal sealed class FixedVariablePointer
	{
		public VariableIdentifier ID;
		public Int64 Index1;
		public Int64 Index2;
		public override string ToString()
		{
			if (ID == null)
				return base.ToString();
			return string.Format("{0}:{1}:{2}", ID, Index1, Index2);
		}
	}

	internal sealed class VariableEvaluator : IDisposable
	{
		readonly GameBase gamebase;
		readonly ConstantData constant;
		readonly SysnonymManager synonym = new SysnonymManager();
		readonly VariableData varData;
		readonly List<CharacterData> characterList;
		readonly Random rand = new Random();
		internal GameBase Gamebase { get { return gamebase; } }
		internal ConstantData Constant { get { return constant; } }
		string scope = "";
		internal string Scope { set { scope = value; } }

		public VariableEvaluator(GameBase gamebase, ConstantData constant)
		{
			this.gamebase = gamebase;
			this.constant = constant;
			varData = new VariableData(gamebase, constant);
			characterList = new List<CharacterData>();

		}
		#region set/get

		private void checkElement(FixedVariablePointer p)
		{
			if ((p.ID.IsCalc)&&(p.ID.Code != VariableCode.LOCAL))
				return;
			if (p.ID.IsCharacterData)
			{
				if ((p.Index1 < 0) || (p.Index1 >= characterList.Count))
					throw new CodeEE("LN^zϐ" + p.ID.ToString() + "̑P(" + p.Index1.ToString() + ")̓Lo^ԍ͈̔͊Oł");
				CharacterData chara = characterList[(int)p.Index1];
				if (p.ID.IsArray)
				{
					if (p.ID.IsInteger)
					{
						Int64[] dataList = chara.DataIntegerArray[p.ID.CodeInt];
						if ((p.Index2 < 0) || (p.Index2 >= dataList.Length))
							throw new CodeEE("LN^zϐ" + p.ID.ToString() + "̑Q(" + p.Index2.ToString() + ")͔z͈̔͊Oł");
					}
					else
					{
						throw new ExeEE("2̈镶^ϐ͒`ĂȂ");
					}
				}
			}
			else if (p.ID.IsArray)
			{
				if (p.ID.IsInteger)
				{
					Int64[] dataList = varData.DataIntegerArray[p.ID.CodeInt];
					if ((p.Index1 < 0) || (p.Index1 >= dataList.Length))
						throw new CodeEE("zϐ" + p.ID.ToString() + "̑P(" + p.Index1.ToString() + ")͔z͈̔͊Oł");
				}
				else
				{
					string[] dataList = varData.DataStringArray[p.ID.CodeInt];
					if ((p.Index1 < 0) || (p.Index1 >= dataList.Length))
						throw new CodeEE("zϐ" + p.ID.ToString() + "̑P(" + p.Index1.ToString() + ")͔z͈̔͊Oł");
				}
			}
		}

		private CharacterData createTestChara() { return new CharacterData(constant); }
		public static void SetTestData(VariableEvaluator vEv)
		{
			testData = vEv.varData;
			testChara = vEv.createTestChara();
		}
		static VariableData testData;
		static CharacterData testChara;
		public static bool CheckConstElement(FixedVariablePointer p)
		{
			if ((p.ID.IsCalc)&&(p.ID.Code != VariableCode.LOCAL))
			{
				if (p.ID.Code == VariableCode.RAND)
					if (p.Index1 <= 0)
						return false;
				if (p.ID.Code == VariableCode.CHARANUM)
					return true;
				return true;
			}
			else if (p.ID.IsCharacterData)
			{
				if (p.ID.IsArray)
				{
					if (p.ID.IsInteger)
					{
						Int64[] dataList = testChara.DataIntegerArray[p.ID.CodeInt];
						if ((p.Index2 < 0) || (p.Index2 >= dataList.Length))
							return false;
					}
				}
			}
			else if (p.ID.IsArray)
			{
				if (p.ID.IsInteger)
				{
					Int64[] dataList = testData.DataIntegerArray[p.ID.CodeInt];
					if ((p.Index1 < 0) || (p.Index1 >= dataList.Length))
							return false;
				}
				else
				{
					string[] dataList = testData.DataStringArray[p.ID.CodeInt];
					if ((p.Index1 < 0) || (p.Index1 >= dataList.Length))
							return false;
				}
			}
			return true;
		}

		public Int64 GetInteger(FixedVariablePointer p)
		{
			if (!p.ID.IsInteger)
				throw new CodeEE("^łȂϐ" + p.ID.ToString() + "𐮐^ƂČĂяo܂");
			checkElement(p);
			if (p.ID.IsCalc)
			{
				if (p.ID.Code == VariableCode.RAND)
				{
					if (p.Index1 <= 0)
						throw new CodeEE("RAND̈0ȉ̒l(" + p.Index1.ToString() + ")w肳܂");
					if (p.Index1 > Int32.MaxValue)
						throw new CodeEE("RAND̈ɑ傫l(" + p.Index1.ToString() + ")w肳܂");

					return rand.Next((int)p.Index1);
				}
				if (p.ID.Code == VariableCode.CHARANUM)
					return characterList.Count;
				if (p.ID.Code == VariableCode.LOCAL)
				{
					string varScope = p.ID.Scope;
					if (varScope == null)
						varScope = this.scope;
					return varData.LocalVars.GetValue(varScope, p.Index1);
				}
				throw new ExeEE("`̕ϐ" + p.ID.ToString());
			}
			if (p.ID.IsCharacterData)
			{
				CharacterData chara = characterList[(int)p.Index1];
				if (p.ID.IsArray)
					return chara.DataIntegerArray[p.ID.CodeInt][p.Index2];
				else
					return chara.DataInteger[p.ID.CodeInt];

			}
			else if (p.ID.IsArray)
				return varData.DataIntegerArray[p.ID.CodeInt][p.Index1];
			else
				return varData.DataInteger[p.ID.CodeInt];
		}

		public string GetString(FixedVariablePointer p)
		{
			string ret = m_GetString(p);
			if (ret == null)
				return "";
			return ret;
		}

		private string m_GetString(FixedVariablePointer p)
		{
			if (!p.ID.IsString)
				throw new CodeEE("^łȂϐ" + p.ID.ToString() + "𕶎^ƂČĂяo܂");
			if (p.ID.IsCalc)
			{
				string[] array = null;
				switch (p.ID.Code)
				{
					case VariableCode.ABLNAME:
						array = constant.AblName;
						break;
					case VariableCode.TALENTNAME:
						array = constant.TalentName;
						break;
					case VariableCode.EXPNAME:
						array = constant.ExpName;
						break;
					case VariableCode.MARKNAME:
						array = constant.MarkName;
						break;
					case VariableCode.PALAMNAME:
						array = constant.ParamName;
						break;
					case VariableCode.ITEMNAME:
						array = constant.ItemName;
						break;
					case VariableCode.TRAINNAME:
						array = constant.TrainName;
						break;
					case VariableCode.BASENAME:
						array = constant.BaseName;
						break;
					case VariableCode.SOURCENAME:
						array = constant.SourceName;
						break;
					case VariableCode.EXNAME:
						array = constant.ExName;
						break;
				}
				if (array == null)
					throw new ExeEE(p.ID.Code.ToString() + "IsCalc̕^ƂĎw肳ꂽ");
				if ((p.Index1 < 0) || (p.Index1 >= array.Length))
					return null;
				return array[p.Index1];
			}
			checkElement(p);
			if (p.ID.IsCharacterData)
			{
				CharacterData chara = characterList[(int)p.Index1];
				if (p.ID.IsArray)
					throw new CodeEE("2̈镶^ϐ͒`Ă܂");
				else
					return chara.DataString[p.ID.CodeInt];
			}
			if (p.ID.IsArray)
				return varData.DataStringArray[p.ID.CodeInt][p.Index1];
			else
				return varData.DataString[p.ID.CodeInt];
		}


		public void SetValue(FixedVariablePointer p, Int64 srcValue)
		{
			if (!p.ID.IsInteger)
				throw new CodeEE("^łȂϐ" + p.ID.ToString() + "ɐl悤Ƃ܂");
			if (p.ID.Readonly)
				throw new CodeEE("ǂݎp̕ϐ" + p.ID.ToString() + "ɑ悤Ƃ܂");
			checkElement(p);

			if (p.ID.Code == VariableCode.LOCAL)
			{
				string varScope = p.ID.Scope;
				if (varScope == null)
					varScope = this.scope;
				varData.LocalVars.SetValue(varScope, p.Index1, srcValue);
			}
			else if (p.ID.IsCharacterData)
			{
				CharacterData chara = characterList[(int)p.Index1];
				if (p.ID.IsArray)
					chara.DataIntegerArray[p.ID.CodeInt][p.Index2] = srcValue;
				else
					chara.DataInteger[p.ID.CodeInt] = srcValue;

			}
			else if (p.ID.IsArray)
				varData.DataIntegerArray[p.ID.CodeInt][p.Index1] = srcValue;
			else
				varData.DataInteger[p.ID.CodeInt] = srcValue;
		}

		public void SetValue(FixedVariablePointer p, string srcValue)
		{
			if (!p.ID.IsString)
				throw new CodeEE("^łȂϐ" + p.ID.ToString() + "ɕ^悤Ƃ܂");
			if (p.ID.Readonly)
				throw new CodeEE("ǂݎp̕ϐ" + p.ID.ToString() + "ɑ悤Ƃ܂");
			checkElement(p);
			if (p.ID.IsCharacterData)
			{
				CharacterData chara = characterList[(int)p.Index1];
				if (p.ID.IsArray)
					throw new CodeEE("2̈镶^ϐ͒`Ă܂");
				else
					chara.DataString[p.ID.CodeInt] = srcValue;
			}
			else if (p.ID.IsArray)
				varData.DataStringArray[p.ID.CodeInt][p.Index1] = srcValue;
			else
				varData.DataString[p.ID.CodeInt] = srcValue;
		}

		public string GetTrainComString(int trainCode, int comNo)
		{
			string trainName = constant.TrainName[trainCode];
			return string.Format("{0}[{1,3}]", trainName, comNo);
		}


		public string GetHavingItemsString()
		{
			Int64[] array = varData.DataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.ITEM];
			string[] itemnames = this.ITEMNAME;
			int count = 0;
			StringBuilder builder = new StringBuilder();
			builder.Append("ACeF");
			for (int i = 0; i < array.Length; i++)
			{
				if (array[i] == 0)
					continue;
				if (i >= itemnames.Length)
					break;
				count++;
				if (itemnames[i] != null)
					builder.Append(itemnames[i]);
				builder.Append("(");
				builder.Append(array[i].ToString());
				builder.Append(") ");
			}
			if (count == 0)
				builder.Append("Ȃ");
			return builder.ToString();
		}

		public string GetItemSalesString()
		{
			Int64[] array = varData.DataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.ITEMSALES];
			StringBuilder builder = new StringBuilder();
			for (int i = 0; i < array.Length; i++)
			{
				if (array[i] != 0)
					continue;
				builder.Append(constant.ItemName[i]);
				builder.Append("(");
				builder.Append(array[i].ToString());
				builder.Append(")");
			}
			return builder.ToString();
		}

		public string GetCharacterDataString(Int64 target, BuiltInFunctionCode func)
		{
			StringBuilder builder = new StringBuilder();
			if ((target < 0) || (target >= characterList.Count))
				throw new CodeEE("݂Ȃo^LN^QƂ悤Ƃ܂");
			CharacterData chara = characterList[(int)target];
			Int64[] array = null;
			int i = 0;
			switch (func)
			{
				case BuiltInFunctionCode.PRINT_ABL:
					array = chara.DataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.ABL];
					for (i = 0; i < array.Length; i++)
					{
						if (i >= constant.AblName.Length)
							break;
						if (array[i] == 0)
							continue;
						if (string.IsNullOrEmpty(constant.AblName[i]))
							continue;
						builder.Append(constant.AblName[i]);
						builder.Append("LV");
						builder.Append(array[i].ToString());
						builder.Append(" ");

					}
					break;
				case BuiltInFunctionCode.PRINT_TALENT:
					array = chara.DataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.TALENT];
					for (i = 0; i < array.Length; i++)
					{
						if (i >= constant.TalentName.Length)
							break;
						if (array[i] == 0)
							continue;
						if (string.IsNullOrEmpty(constant.TalentName[i]))
							continue;
						builder.Append("[");
						builder.Append(constant.TalentName[i]);
						builder.Append("]");
					}
					break;
				case BuiltInFunctionCode.PRINT_MARK:
					array = chara.DataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.MARK];
					for (i = 0; i < array.Length; i++)
					{
						if (i >= constant.MarkName.Length)
							break;
						if (array[i] == 0)
							continue;
						if (string.IsNullOrEmpty(constant.MarkName[i]))
							continue;
						builder.Append(constant.MarkName[i]);
						builder.Append("LV");
						builder.Append(array[i].ToString());
						builder.Append(" ");
					}
					break;
				case BuiltInFunctionCode.PRINT_EXP:
					array = chara.DataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.EXP];
					for (i = 0; i < array.Length; i++)
					{
						if (i >= constant.ExpName.Length)
							break;
						if (array[i] == 0)
							continue;
						if (string.IsNullOrEmpty(constant.ExpName[i]))
							continue;
						builder.Append(constant.ExpName[i]);
						builder.Append(array[i].ToString());
						builder.Append(" ");
					}
					break;
				default:
					throw new ExeEE("`̊֐");
			}
			return builder.ToString();
		}
		public string GetCharacterParamString(Int64 target, int paramCode)
		{
			if ((target < 0) || (target >= characterList.Count))
				throw new CodeEE("݂Ȃo^LN^QƂ悤Ƃ܂");
			if ((paramCode < 0) || (paramCode >= constant.ParamName.Length))
				throw new ExeEE("݂Ȃ̂擾悤Ƃ");
			CharacterData chara = characterList[(int)target];
			Int64 param = chara.DataIntegerArray[(int)(VariableCode.PALAM & VariableCode.__LOWERCASE__)][paramCode];
			Int64[] paramlv = varData.DataIntegerArray[(int)(VariableCode.PALAMLV & VariableCode.__LOWERCASE__)];
			string paramName = constant.ParamName[paramCode];
			if ((param == 0) && (string.IsNullOrEmpty(paramName)))
				return null;
			if (paramName == null)
				paramName = "";
			char c = '-';
			Int64 border = paramlv[1];
			if (param >= border)
			{
				c = '=';
				border = paramlv[2];
			}
			if (param >= border)
			{
				c = '>';
				border = paramlv[3];
			}
			if (param >= border)
			{
				c = '*';
				border = paramlv[4];
			}
			StringBuilder bar = new StringBuilder();
			bar.Append('[');
			if ((border <= 0) || (border <= param))
				bar.Append(c, 10);
			else if (param <= 0)
				bar.Append('.', 10);
			else
			{
				unchecked
				{
					int count = (int)(param * 10 / border);
					bar.Append(c, count);
					bar.Append('.', 10 - count);
				}
			}
			bar.Append(']');
			return string.Format("{0}{1}{2,6}", paramName, bar.ToString(), ToKmgtString(param));

		}

		public void AddCharacter(Int64 charaTmplNo, bool isSp)
		{
			CharacterTemplate tmpl = constant.GetCharacterTemplate(charaTmplNo, isSp);
			if (tmpl == null)
				throw new CodeEE("`ĂȂLN^쐬悤Ƃ܂");
			CharacterData chara = new CharacterData(constant, tmpl);
			characterList.Add(chara);
		}

		public void DelCharacter(Int64 charaNo)
		{
			if ((charaNo < 0) || (charaNo >= characterList.Count))
				throw new CodeEE("݂Ȃo^LN^폜悤Ƃ܂");
			characterList.RemoveAt((int)charaNo);
		}


		public void SwapChara(Int64 x, Int64 y)
		{
			if (((x < 0) || (x >= characterList.Count)) || ((y < 0) || (y >= characterList.Count)))
				throw new CodeEE("݂Ȃo^LN^ւ悤Ƃ܂");
			CharacterData data = characterList[(int)y];
			characterList[(int)y] = characterList[(int)x];
			characterList[(int)x] = data;
		}

		public void UpdateInBeginTrain()
		{
			ASSIPLAY = 0;
			PREVCOM = -1;
			NEXTCOM = -1;
			Int64[] array;
			array = varData.DataIntegerArray[(int)(VariableCode.TFLAG & VariableCode.__LOWERCASE__)];
			for (int i = 0; i < array.Length; i++)
				array[i] = 0;
			//{Ƃ̎dlɂ킹AI𒆈ȊÕLN^SZbgB
			foreach (CharacterData chara in characterList)
			{
				array = chara.DataIntegerArray[(int)(VariableCode.GOTJUEL & VariableCode.__LOWERCASE__)];
				for (int i = 0; i < array.Length; i++)
					array[i] = 0;
				array = chara.DataIntegerArray[(int)(VariableCode.TEQUIP & VariableCode.__LOWERCASE__)];
				for (int i = 0; i < array.Length; i++)
					array[i] = 0;
				array = chara.DataIntegerArray[(int)(VariableCode.EX & VariableCode.__LOWERCASE__)];
				for (int i = 0; i < array.Length; i++)
					array[i] = 0;
				array = chara.DataIntegerArray[(int)(VariableCode.STAIN & VariableCode.__LOWERCASE__)];
				for (int i = 0; i < array.Length; i++)
					array[i] = 0;
				//W̉
				array[2] = 2;
				array[3] = 1;
				array[4] = 8;
				array = chara.DataIntegerArray[(int)(VariableCode.PALAM & VariableCode.__LOWERCASE__)];
				for (int i = 0; i < array.Length; i++)
					array[i] = 0;
			}
		}

		public void UpdateInTrainWaitInput()
		{
			Int64[] array;
			array = varData.DataIntegerArray[(int)(VariableCode.UP & VariableCode.__LOWERCASE__)];
			for (int i = 0; i < array.Length; i++)
				array[i] = 0;
			array = varData.DataIntegerArray[(int)(VariableCode.DOWN & VariableCode.__LOWERCASE__)];
			for (int i = 0; i < array.Length; i++)
				array[i] = 0;
			array = varData.DataIntegerArray[(int)(VariableCode.LOSEBASE & VariableCode.__LOWERCASE__)];
			for (int i = 0; i < array.Length; i++)
				array[i] = 0;
			//{Ƃ̎dlɂ킹AI𒆈ȊÕLN^SZbgB
			foreach (CharacterData chara in characterList)
			{
				array = chara.DataIntegerArray[(int)(VariableCode.SOURCE & VariableCode.__LOWERCASE__)];
				for (int i = 0; i < array.Length; i++)
					array[i] = 0;
				array = chara.DataIntegerArray[(int)(VariableCode.NOWEX & VariableCode.__LOWERCASE__)];
				for (int i = 0; i < array.Length; i++)
					array[i] = 0;
			}
			//UP = 0,DOWN = 0,LOSEBASE = 0,SOURCE,NOWEX
		}

		//PREVCOM͍XVȂBXNvg̕ōXVKvB
		//DataEmueraConsole𑀍삷̂͂B
		public void UpdateInUpcheck(EmueraConsole window)
		{
			Int64[] up, down, param;
			up = varData.DataIntegerArray[(int)(VariableCode.UP & VariableCode.__LOWERCASE__)];
			down = varData.DataIntegerArray[(int)(VariableCode.DOWN & VariableCode.__LOWERCASE__)];
			Int64 target = TARGET;
			if ((target < 0) || (target >= characterList.Count))
				goto end;
			CharacterData chara = characterList[(int)target];
			param = chara.DataIntegerArray[(int)(VariableCode.PALAM & VariableCode.__LOWERCASE__)];
			int length = param.Length;
			if (param.Length < up.Length)
				length = up.Length;
			if (param.Length < down.Length)
				length = down.Length;

			for (int i = 0; i < length; i++)
			{
				//{Ƃ̎dlł͕̒l͖B
				if ((up[i] <= 0) && (down[i] <= 0))
					continue;
				StringBuilder builder = new StringBuilder();
				builder.Append(constant.ParamName[i]);
				builder.Append(' ');
				builder.Append(ToKmgtString(param[i]));
				if (up[i] > 0)
				{
					builder.Append('+');
					builder.Append(ToKmgtString(up[i]));
				}
				if (down[i] > 0)
				{
					builder.Append('-');
					builder.Append(ToKmgtString(down[i]));
				}
				unchecked { param[i] += up[i] - down[i]; }
				builder.Append('=');
				builder.Append(ToKmgtString(param[i]));
				window.Print(builder.ToString());
				window.NewLine();

			}
		end:

			for (int i = 0; i < up.Length; i++)
				up[i] = 0;
			for (int i = 0; i < down.Length; i++)
				up[i] = 0;
		}

		private static readonly string[] kMGT = { "", "k", "M", "G", "T", "P" };
		public static string ToKmgtString(Int64 integer)
		{
#if NOTUSE
			//TODO:
			//Ă͌ǂ悤B
			StringBuilder builer = new StringBuilder();
			if (integer < 0)
			{
				builer.Append('-');
				integer = -integer;
			}
			int i = 0;
			for (i = 0; i < kMGT.Length; i++)
			{
				if (integer < 100000)
					break;
				integer /= 1000;
			}
			builer.Append(integer.ToString());
			builer.Append(kMGT[i]);
			return builer.ToString();
#else
			return integer.ToString();
#endif
		}

		public long GetVariableSize(VariableIdentifier varID)
		{
			if ((!varID.IsArray) || (varID.Code == VariableCode.RAND))
			{
				throw new CodeEE("zϐ\"" + varID.Code.ToString() + "\"̒擾悤Ƃ܂");
			}
			if ((varID.IsCalc)&&  (varID.Code != VariableCode.LOCAL))
			{
				switch (varID.Code)
				{
					//case CHARANUM:
					//case RAND:
					//case VariableCode.ITEMPRICE:
					//	return constant.MaxItem;
					case VariableCode.ABLNAME:
						return ConstantData.MaxAbl;
					case VariableCode.TALENTNAME:
						return ConstantData.MaxTalent;
					case VariableCode.EXPNAME:
						return ConstantData.MaxExp;
					case VariableCode.MARKNAME:
						return ConstantData.MaxMark;
					case VariableCode.PALAMNAME:
						return ConstantData.MaxParam;
					case VariableCode.ITEMNAME:
						return ConstantData.MaxItem;
					case VariableCode.TRAINNAME:
						return ConstantData.MaxTrain;
					case VariableCode.BASENAME:
						return ConstantData.MaxBasedata;
					case VariableCode.SOURCENAME:
						return ConstantData.MaxSource;
					case VariableCode.EXNAME:
						return ConstantData.MaxEx;
					default:
						break;
				}
			}
			else if (varID.IsCharacterData)
			{
				if (varID.IsInteger)
					return constant.CharacterIntArrayLength[varID.CodeInt];
				else
					return constant.CharacterStrArrayLength[varID.CodeInt];
			}
			else
			{
				if (varID.IsInteger)
					return constant.VariableIntArrayLength[varID.CodeInt];
				else
					return constant.VariableStrArrayLength[varID.CodeInt];
			}
			throw new ExeEE("\"" + varID.Code.ToString() + "\"̒擾֐ُ̈");
		}

		public bool ItemSales(Int64 itemNo)
		{
			Int64[] itemSales = ITEMSALES;
			string[] itemNames = constant.ItemName;
			if ((itemNo < 0) || (itemNo >= itemSales.Length) || (itemNo >= itemNames.Length))
				return false;
			int index = (int)itemNo;
			return ((itemSales[index] != 0) && (itemNames[index] != null));
		}

		public bool BuyItem(Int64 itemNo)
		{

			if (!ItemSales(itemNo))
				return false;

			Int64[] itemPrice = constant.ItemPrice;
			if (itemNo >= itemPrice.Length)
				return false;
			int index = (int)itemNo;
			if (MONEY < itemPrice[index])
				return false;
			MONEY -= itemPrice[index];
			ITEM[index]++;
			BOUGHT = itemNo;
			return true;
		}

		#endregion

		public void IamaMunchkin()
		{
			if ((MASTER < 0) || (MASTER >= characterList.Count))
				return;
			if (Config.Instance.ChangeMasterNameIfDebug)
            {
                characterList[(int)MASTER].DataString[(int)(VariableCode.NAME & VariableCode.__LOWERCASE__)] = "CJT}";
                characterList[(int)MASTER].DataString[(int)(VariableCode.CALLNAME & VariableCode.__LOWERCASE__)] = "CJT}";
            }
		}


		#region File
		public void SaveToStream(EraDataWriter writer, string saveDataText)
		{
			writer.Write(gamebase.ScriptUniqueCode);
			writer.Write(gamebase.ScriptVersion);
			writer.Write(saveDataText);
			writer.Write(characterList.Count);
			for (int i = 0; i < characterList.Count; i++)
			{
				characterList[i].SaveToStream(writer);
			}
			varData.SaveToStream(writer);
		}

		public static string TextLoadFromStream(GameBase gb, EraDataReader reader)
		{
			if (reader.ReadInt64() != gb.ScriptUniqueCode)
				throw new FileEE("قȂQ[̃Z[uf[^ł");
			Int64 version = reader.ReadInt64();
			if ((gb.ScriptVersion != version) && (gb.ScriptCompatibleMinVersion > version))
				throw new FileEE("Z[uf[^̃o[VقȂ܂");
			return reader.ReadString();
		}

		public void LoadFromStream(EraDataReader reader)
		{
			if (reader.ReadInt64() != gamebase.ScriptUniqueCode)
				throw new FileEE("قȂQ[̃Z[uf[^ł");
			Int64 version = reader.ReadInt64();
			if ((gamebase.ScriptVersion != version) && (gamebase.ScriptCompatibleMinVersion > version))
				throw new FileEE("Z[uf[^̃o[VقȂ܂");
			reader.ReadString();

			int charaCount = (int)reader.ReadInt64();
			characterList.Clear();
			for (int i = 0; i < charaCount; i++)
			{
				CharacterData chara = new CharacterData(constant);
				characterList.Add(chara);
				chara.LoadFromStream(reader);
			}
			varData.LoadFromStream(reader);
		}
		#endregion
		#region IDisposable o

		public void Dispose()
		{


			varData.Dispose();

			for (int i = 0; i < characterList.Count; i++)
				characterList[i].Dispose();
			characterList.Clear();
		}

		#endregion
		#region Property
		public Int64 RESULT
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.RESULT & VariableCode.__LOWERCASE__)][0]; }
			set { varData.DataIntegerArray[(int)(VariableCode.RESULT & VariableCode.__LOWERCASE__)][0] = value; }
		}
		public Int64 COUNT
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.COUNT & VariableCode.__LOWERCASE__)][0]; }
			set { varData.DataIntegerArray[(int)(VariableCode.COUNT & VariableCode.__LOWERCASE__)][0] = value; }
		}
		public string RESULTS
		{
			get
			{
				string ret = varData.DataStringArray[(int)(VariableCode.RESULTS & VariableCode.__LOWERCASE__)][0];
				if (ret == null)
					return "";
				return ret;
			}
			set { varData.DataStringArray[(int)(VariableCode.RESULTS & VariableCode.__LOWERCASE__)][0] = value; }
		}
		public Int64 TARGET
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.TARGET & VariableCode.__LOWERCASE__)][0]; }
			set { varData.DataIntegerArray[(int)(VariableCode.TARGET & VariableCode.__LOWERCASE__)][0] = value; }
		}
		public Int64 MASTER
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.MASTER & VariableCode.__LOWERCASE__)][0]; }
			set { varData.DataIntegerArray[(int)(VariableCode.MASTER & VariableCode.__LOWERCASE__)][0] = value; }
		}
		public Int64 ASSI
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.ASSI & VariableCode.__LOWERCASE__)][0]; }
			set { varData.DataIntegerArray[(int)(VariableCode.ASSI & VariableCode.__LOWERCASE__)][0] = value; }
		}
		public Int64 ASSIPLAY
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.ASSIPLAY & VariableCode.__LOWERCASE__)][0]; }
			set { varData.DataIntegerArray[(int)(VariableCode.ASSIPLAY & VariableCode.__LOWERCASE__)][0] = value; }
		}
		public Int64 PREVCOM
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.PREVCOM & VariableCode.__LOWERCASE__)][0]; }
			set { varData.DataIntegerArray[(int)(VariableCode.PREVCOM & VariableCode.__LOWERCASE__)][0] = value; }
		}
		public Int64 SELECTCOM
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.SELECTCOM & VariableCode.__LOWERCASE__)][0]; }
			set { varData.DataIntegerArray[(int)(VariableCode.SELECTCOM & VariableCode.__LOWERCASE__)][0] = value; }
		}
		public Int64 NEXTCOM
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.NEXTCOM & VariableCode.__LOWERCASE__)][0]; }
			set { varData.DataIntegerArray[(int)(VariableCode.NEXTCOM & VariableCode.__LOWERCASE__)][0] = value; }
		}

		public string[] ITEMNAME
		{
			get { return constant.ItemName; }
		}

		public Int64[] ITEMSALES
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.ITEMSALES & VariableCode.__LOWERCASE__)]; }
		}

		public Int64[] ITEMPRICE
		{
			get { return constant.ItemPrice; }
		}

		private Int64[] ITEM
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.ITEM & VariableCode.__LOWERCASE__)]; }
		}


		private Int64 MONEY
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.MONEY & VariableCode.__LOWERCASE__)][0]; }
			set { varData.DataIntegerArray[(int)(VariableCode.MONEY & VariableCode.__LOWERCASE__)][0] = value; }
		}

		private Int64 BOUGHT
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.BOUGHT & VariableCode.__LOWERCASE__)][0]; }
			set { varData.DataIntegerArray[(int)(VariableCode.BOUGHT & VariableCode.__LOWERCASE__)][0] = value; }
		}
		#endregion

	}
}
