using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using MinorShift.Emuera.GameData;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameView;
using MinorShift.Emuera.GameData.Expression;
using MinorShift.Emuera.GameData.Variable;
namespace MinorShift.Emuera.GameProc
{

    internal sealed partial class Process
    {
        public Process(EmueraConsole view)
        {
            console = view;
        }

        /// <summary>
        /// @~~$~~W߂́BCALL߂ȂǂŎg
        /// sLogicalLinegێB
        /// </summary>
        LabelDictionary labelDic;

        /// <summary>
        /// ϐSBXNvgŕKvɂȂϐ́i[U[ڐGȂ̂܂߁j̒ɂ
        /// </summary>
        private VariableEvaluator vEvaluator;
        private ExpressionEvaluator eEvaluator;
        readonly EmueraConsole console;
        ProcessState state;
        public bool Initialize()
        {
            isInitialized = false;
            state = new ProcessState();
            string csvDir = Program.ExeDir + "csv\\";
            string erbDir = Program.ExeDir + "erb\\";
            GameBase gamebase = null;

            try
            {
                gamebase = new GameBase();
                gamebase.LoadGameBaseCsv(csvDir + "GAMEBASE.CSV");
                ConstantData constant = new ConstantData(gamebase);
                constant.LoadData(csvDir, console);
                vEvaluator = new VariableEvaluator(gamebase, constant);
                VariableEvaluator.SetTestData(vEvaluator);
                eEvaluator = new ExpressionEvaluator(vEvaluator);
                //if (File.Exists(csvDir + "_Rename.csv"))
                //    VarData.LoadEraExRenameFile(csvDir + "_Rename.csv");
                ErbLoader loader = new ErbLoader(console, vEvaluator);
				if (Config.Instance.UseRenameFile)
                {
                    if (File.Exists(csvDir + "_Rename.csv"))
                        loader.LoadEraExRenameFile(csvDir + "_Rename.csv");
                    else
                        console.PrintLine("csv\\_Rename.csv܂");
                }

                labelDic = loader.LoadErbFiles(erbDir);

                vEvaluator.AddCharacter(0, false);
                if (gamebase.DefaultCharacter > 0)
                    vEvaluator.AddCharacter(gamebase.DefaultCharacter, false);
                initSystemProcess();
            }
            catch (CodeEE e)
            {
                if (e.Position != null)
                {
                    console.PrintLine(e.Position.Filename + "" + e.Position.LineNo.ToString() + "sڂŃG[܂");
                    console.PrintLine(e.Position.RowLine);
                }
                console.PrintLine(e.Message);
                return false;
            }
            catch (Exception)
            {
                console.PrintLine("ɒvIȃG[܂");
                return false;
            }
            if (labelDic == null)
            {
                return false;
            }
            isInitialized = true;
            console.ReadAnyKey();
            return true;
        }


        public void InputInteger(Int64 i)
        {
            vEvaluator.RESULT = i;
        }
        public void InputSystemInteger(Int64 i)
        {
            systemResult = i;
        }
        public void InputString(string s)
        {
            vEvaluator.RESULTS = s;
        }

        public bool isInitialized = false;

        public void DoScript()
        {
            while (true)
            {
                if (state.ScriptEnd)
                    runSystemProcWithCatch();
                if (!console.IsRunning)
                {
                    if (console.hasWaitRefresh || console.needRefresh)
                        console.RefreshStrings(true);
                    break;
                }
                runScriptProcWithCatch();
                if (console.needRefresh)
                    console.RefreshStrings(true);
            }
            return;
        }

        private void runSystemProcWithCatch()
        {
            try
            {
                runSystemProc();
            }
            catch (Exception e)
            {
                if (e is CodeEE)
                    console.PrintLine("֐̏I[ŃG[܂");
                else if (e is ExeEE)
                    console.PrintLine("֐̏I[EmuerãG[܂");
                else
                    console.PrintLine("֐̏I[ŗ\ȂG[܂");
                console.PrintLine(e.Message);
                console.ThrowError();
            }
        }

        ///DoScript()̈ꕔBG[Ȃ̂ŕB
        private void runScriptProcWithCatch()
        {
            try
            {
                runScriptProc();
            }
            catch (Exception ec)
            {
                LogicalLine currentLine = state.CurrentLine;
                if ((currentLine == null) || (currentLine is NullLine))
                    currentLine = null;
                if ((currentLine != null) && (currentLine.Position != null))
                {
                    if (ec is CodeEE)//*.ERB̖ƎvO
                        console.PrintLine(currentLine.Position.Filename + "" + currentLine.Position.LineNo.ToString() + "sڂŃG[܂");
                    else if (ec is ExeEE)//emuera.exe{̂ɋNƎvOBoOB
                        console.PrintLine(currentLine.Position.Filename + "" + currentLine.Position.LineNo.ToString() + "sڂEmuera.exẽG[܂");
                    else//SystemExceptionB\ȂO
                        console.PrintLine(currentLine.Position.Filename + "" + currentLine.Position.LineNo.ToString() + "sڂŗ\ȂG[܂");
                    console.PrintLine(currentLine.Position.RowLine);
                }
                else
                {
                    if (ec is CodeEE)//*.ERB̖ƎvO
                        console.PrintLine("G[܂");
                    else if (ec is ExeEE)//emuera.exe{̂ɋNƎvOBoOB
                        console.PrintLine("Emuera.exẽG[܂");
                    else//SystemExceptionB\ȂO
                        console.PrintLine("\ȂG[܂");
                    console.PrintLine("ӏł܂ł");
                }
                if (ec is EmueraException)
                    console.PrintLine(ec.Message);
                else//SystemExceptionBG[em邽߂ɂMessageނType̕dv
                    console.PrintLine(ec.GetType().ToString() + ":" + ec.Message);
                console.ThrowError();
            }
            return;
        }







    }
}
