﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using MinorShift._Library;
using System.IO;

namespace MinorShift.Emuera
{
	static class Program
	{
		/*
		コードの開始地点。
		ここでMainWindowを作り、
		MainWindowがProcessを作り、
		ProcessがGameBase・ConstantData・Variableを作る。
		
		
		*.ERBの読み込み、実行、その他の処理をProcessが、
		入出力をMainWindowが、
		定数の保存をConstantDataが、
		変数の管理をVariableが行う。
		 
		と言う予定だったが改変するうちに境界が曖昧になってしまった。
		 
		後にEmueraConsoleを追加し、それに入出力を担当させることに。

		*/
		/// <summary>
		/// アプリケーションのメイン エントリ ポイントです。
		/// </summary>
		[STAThread]
		static void Main()
		{
			
			Application.EnableVisualStyles();
			Application.SetCompatibleTextRenderingDefault(false);
			Config.Instance.LoadConfig();
			//二重起動の禁止かつ二重起動
			if ((!Config.Instance.AllowMultipleInstances) && (Sys.PrevInstance()))
			{

				MessageBox.Show("多重起動を許可する場合、emuera.configを書き換えて下さい", "既に起動しています");
				return;
			}
			if (!Directory.Exists(ExeDir + "csv"))
			{
				MessageBox.Show("csvフォルダが見つかりません", "フォルダなし");
				return;
			}
			if (!Directory.Exists(ExeDir + "erb"))
			{
				MessageBox.Show("erbフォルダが見つかりません", "フォルダなし");
				return;
			}

			while (true)
			{
				Application.Run(new MainWindow());
                if (!Reboot)
					break;
				Reboot = false;
				Config.Instance.LoadConfig();
			}
		}

		public static string ExeDir
		{
			get
			{
#if DEBUG
				//return @"D:\MyDoc\era\era咲-saki-\";
				//return @"D:\MyDoc\era\eratohoYM Mk-2 rev.2改\";
				//return @"D:\MyDoc\era\eratohoCPMver0.12\";
				//return @"D:\MyDoc\era\eraTRPG\";
				//return @"D:\MyDoc\era\eraWIZ\";
				//return @"D:\MyDoc\era\eraWitch\";
				//return @"D:\MyDoc\era\eraTest\";
				//return @"D:\MyDoc\era\eratohoRR1331\";
				//return @"D:\MyDoc\era\eratohoSlow\";
				//return @"D:\MyDoc\era\eraFIRE\";
				//return @"D:\MyDoc\era\eraIm@s_ver.0.17βd\";
				//return @"D:\MyDoc\era\eraPersona\";
				//return @"D:\MyDoc\era\eraSQ_2009_05_21_β\";
				//return @"D:\MyDoc\era\eraSQN_2009_07_04\";
				//return @"D:\MyDoc\era\eratohoA ver1.104\";
				//return @"D:\MyDoc\era\eratohoCommerce\";
				//return @"D:\MyDoc\era\eratohoDM\";
				//return @"D:\MyDoc\era\eraTRPG\";				
				return Sys.ExeDir;
#else
				return Sys.ExeDir;
#endif
			}
		}
		public static bool Reboot = false;
        public static int ClientX = 0;
        public static int ClientY = 0;
	}
}