/* ~Օʉ
 * Copyright (C) 2004 Kagetani Hideto
 */

#include <stdio.h>
#include "struct.h"
#include "cmd.h"
#include "ui.h"

WORD Get2bytes(BYTE *buf)
{
	return (WORD)buf[0]<<8 | buf[1];
}

DWORD Get3bytes(BYTE *buf)
{
	return (DWORD)buf[0]<<16 | (DWORD)buf[1]<<8 | buf[2];
}

DWORD Get4bytes(BYTE *buf)
{
	return (DWORD)buf[0]<<24 | (DWORD)buf[1]<<16 | (DWORD)buf[2]<<8 | buf[3];
}

void Set2bytes(BYTE *buf, WORD value)
{
	buf[0] = (BYTE)(value>>8);
	buf[1] = (BYTE)value;
}

void Set3bytes(BYTE *buf, DWORD value)
{
	buf[0] = (BYTE)(value>>16);
	buf[1] = (BYTE)(value>>8);
	buf[2] = (BYTE)value;
}

void Set4bytes(BYTE *buf, DWORD value)
{
	buf[0] = (BYTE)(value>>24);
	buf[1] = (BYTE)(value>>16);
	buf[2] = (BYTE)(value>>8);
	buf[3] = (BYTE)value;
}


DWORD MSF2LBA(BYTE min, BYTE sec, BYTE frame, BOOL force_positive)
{
	DWORD ret = min*60 + sec;
	ret *= 75;
	ret += frame;
	if(min < 90 || force_positive)
		ret -= 150;
	else
		ret -= 450150;
	return ret;
}

BOOL LBA2MSF(DWORD lba, BYTE *min, BYTE *sec, BYTE *frame)
{
	BYTE m, s, f;

	if(lba >= (DWORD)-150 || lba < 405000){
		m = (BYTE)((lba+150)/60/75);
		s = (BYTE)((lba+150 - m*60*75)/75);
		f = (BYTE)(lba+150 - m*60*75 - s*75);
	}
	else if(lba>=(DWORD)-45150 && lba<=(DWORD)-151){
		m = (BYTE)((lba+450150)/60/75);
		s = (BYTE)((lba+450150 - m*60*75)/75);
		f = (BYTE)(lba+450150 - m*60*75 - s*75);
	}
	else{
		*min = 0xff;
		*sec = 0xff;
		*frame = 0xff;
		return FALSE;
	}

	*min = m;
	*sec = s;
	*frame = f;

	if(lba>404849)
		return FALSE;
	return TRUE;
}



int SendTestUnitReady(DRIVE *drive)
{
	BYTE cdb[12];

	memset(cdb, 0, sizeof(cdb));
	return SendCmd(drive, cdb, 0, REQ_NODATA);
}

int SendStartStop(DRIVE *drive, BYTE immed, BYTE load_eject, BYTE start_or_load)
{
	BYTE cdb[12];

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_START_STOP;
	cdb[1] = (BYTE)(immed ? 1:0);
	cdb[4] = (BYTE)((load_eject ? 2:0)|(start_or_load ? 1:0));
	return SendCmd(drive, cdb, 0, REQ_NODATA);
}

int SendPreventAllow(DRIVE *drive, BYTE prevent)
{
	BYTE cdb[12];

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_PREVENT_ALLOW;
	cdb[4] = (BYTE)(prevent ? 1:0);
	return SendCmd(drive, cdb, 0, REQ_NODATA);
}

int SendModeSense(DRIVE *drive, BYTE page_control, BYTE page_code)
{
	BYTE cdb[12];
	WORD len;
	int ret;

	len = drive->atapi ? 8:16;

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_MODE_SENSE10;
	cdb[2] = (BYTE)(page_control<<6 | page_code);
	Set2bytes(cdb+7, len);
	ret = SendCmd(drive, cdb, len, REQ_DATAIN);
	if(ret!=RET_OK){
		return ret;
	}
	len = Get2bytes(drive->data_buf) + 2;
	Set2bytes(cdb+7, len);
	return SendCmd(drive, cdb, len, REQ_DATAIN);
}

int SendModeSelect(DRIVE *drive, BYTE pf)
{
	BYTE cdb[12];
	WORD len;
	struct _MODEPAGE_HEADER *mph;

	mph = (struct _MODEPAGE_HEADER *)(drive->data_buf+(drive->atapi ? 8:16));
	len = mph->p_len + (drive->atapi ? 8:16) + 2;
	memset(drive->data_buf, 0, drive->atapi ? 8:16);

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_MODE_SELECT10;
	cdb[1] = (BYTE)(pf ? 0x10:0);
	Set2bytes(cdb+7, len);
	return SendCmd(drive, cdb, len, REQ_DATAOUT);
}

int SendReadToc(DRIVE *drive, WORD track_sess_num, BYTE msf, BYTE format)
{
	BYTE cdb[12];
	WORD len = 4;
	int ret;

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_READ_TOC;
	cdb[1] = (BYTE)(msf ? 2:0);
	cdb[2] = (BYTE)(format & 0x0f);
	cdb[6] = (BYTE)(track_sess_num);
	Set2bytes(cdb+7, len);
	ret = SendCmd(drive, cdb, len, REQ_DATAIN);
	if(ret!=RET_OK){
		return ret;
	}
	len = Get2bytes(drive->data_buf);
        len += 2;
	Set2bytes(cdb+7, len);
	return SendCmd(drive, cdb, len, REQ_DATAIN);
}


int SendReadDiscInfo(DRIVE *drive)
{
	BYTE cdb[12];
	WORD len;
	int ret;

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_READ_DISC_INFO;
	Set2bytes(cdb+7, 2);
	ret = SendCmd(drive, cdb, 2, REQ_DATAIN);
	if(ret!=RET_OK){
		return ret;
	}
	len = Get2bytes(drive->data_buf) + 2;
	Set2bytes(cdb+7, len);
	memset(drive->data_buf, 0, sizeof(struct _DISCINFO));
	return SendCmd(drive, cdb, len, REQ_DATAIN);
}


int SendReadTrackInfo(DRIVE *drive, WORD track_num)
{
	BYTE cdb[12];
	WORD len = sizeof(struct _TRACKINFO);

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_READ_TRACK_INFO;
	cdb[1] = 0x01;
	Set2bytes(cdb+4, track_num);
	Set2bytes(cdb+7, len);
	return SendCmd(drive, cdb, len, REQ_DATAIN);
}


int SendCloseTrackSession(DRIVE *drive, BYTE immed, BYTE type, WORD track_num)
{
	BYTE cdb[12];
	
	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_CLOSE_TRACK_SESSION;
	cdb[1] = (BYTE)(immed ? 1:0);
	cdb[2] = (BYTE)(type & 7);
	Set2bytes(cdb+4, track_num);
	return SendCmd(drive, cdb, 0, REQ_NODATA);
}

int SendReadSubchannel(DRIVE *drive, BYTE track_num, BYTE msf, BYTE subq, BYTE format)
{
	BYTE cdb[12];
	WORD len=4;
	int ret;

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_READ_SUBCHANNEL;
	cdb[1] = (BYTE)(msf ? 2:0);
	cdb[2] = (BYTE)(subq ? 0x40:0);
	cdb[3] = format;
	cdb[6] = track_num;
	Set2bytes(cdb+7, len);
	ret = SendCmd(drive, cdb, len, REQ_DATAIN);
	if(ret!=RET_OK)
		return ret;
	len = Get2bytes(drive->data_buf+2) + 4;
	Set2bytes(cdb+7, len);
	return SendCmd(drive, cdb, len, REQ_DATAIN);
}

int SendReadCD(DRIVE *drive, DWORD addr, DWORD len)
{
	BYTE cdb[12];

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_READ_CD;
	Set4bytes(cdb+2, addr);
	Set3bytes(cdb+6, len);
	cdb[9] = 0xf8;
	return SendCmd(drive, cdb, len*2352, REQ_DATAIN);
}

int SendReadFormatCapacities(DRIVE *drive)
{
	BYTE cdb[12];
	WORD len=4;
	int ret;

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_READ_FORMAT_CAPACITIES;
	Set2bytes(cdb+7, len);
	ret = SendCmd(drive, cdb, len, REQ_DATAIN);
	if(ret!=RET_OK)
		return ret;
	len = drive->data_buf[3] + sizeof(struct _FORMATCAPA_HEADER) +
								sizeof(struct _FORMATCURMAXDESC);
	Set2bytes(cdb+7, len);
	return SendCmd(drive, cdb, len, REQ_DATAIN);
}



int SendFormatUnit(DRIVE *drive, BYTE fmtdata, BYTE cmplist, BYTE format_code, WORD len)
{
	BYTE cdb[12];

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_FORMAT_UNIT;
	cdb[1] = (BYTE)((fmtdata ? 0x10:0)|(cmplist ? 8:0)|(format_code & 7));
	return SendCmd(drive, cdb, len, REQ_DATAOUT);
}

int SendSetCdSpeed(DRIVE *drive, WORD read_speed, WORD write_speed, BYTE rotctl)
{
	BYTE cdb[12];

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_SET_CD_SPEED;
	cdb[1] = (BYTE)(rotctl & 3);
	Set2bytes(cdb+2, read_speed);
	Set2bytes(cdb+4, write_speed);
	return SendCmd(drive, cdb, 0, REQ_NODATA);
}

int SendSetStreaming(DRIVE *drive)
{
	BYTE cdb[12];
	WORD len = sizeof(struct _PERFORMANCEDESC);

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_SET_STREAMING;
	Set2bytes(cdb+9, len);
	return SendCmd(drive, cdb, len, REQ_DATAOUT);
}


int SendSynchronizeCache(DRIVE *drive, BYTE immed)
{
	BYTE cdb[12];

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_SYNCHRONIZE_CACHE;
	cdb[1] = (BYTE)(immed ? 2:0);
	return SendCmd(drive, cdb, 0, REQ_NODATA);
}

int SendReserveTrack(DRIVE *drive, DWORD size)
{
	BYTE cdb[12];

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_RESERVE_TRACK;
	Set4bytes(cdb+5, size);
	return SendCmd(drive, cdb, 0, REQ_NODATA);
}

int SendRead10(DRIVE *drive, DWORD lba, WORD len, DWORD buflen)
{
	BYTE cdb[12];

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_READ10;
	Set4bytes(cdb+2, lba);
	Set2bytes(cdb+7, len);
	return SendCmd(drive, cdb, buflen, REQ_DATAIN);
}

int SendWrite10(DRIVE *drive, DWORD lba, WORD len, DWORD buflen)
{
	BYTE cdb[12];
	int ret;

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_WRITE10;
	Set4bytes(cdb+2, lba);
	Set2bytes(cdb+7, len);
	while(TRUE){
		ret = SendCmd(drive, cdb, buflen, REQ_DATAOUT);
		if(ret!=RET_CMDERR)
			break;
		if(!(SD_ASC(drive)==0x04 && SD_ASCQ(drive)==0x08))
			break;
	}
	return ret;
}

int SendSeek10(DRIVE *drive, DWORD lba)
{
	BYTE cdb[12];

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_SEEK10;
	Set4bytes(cdb+2, lba);
	return SendCmd(drive, cdb, 0, REQ_NODATA);
}

int SendSendCueSheet(DRIVE *drive, void *cuesheet, DWORD len)
{
	BYTE cdb[12];

	if(len >= (DWORD)drive->bufsize)
		return RET_NG;

	if(cuesheet!=NULL)
		memcpy(drive->data_buf, cuesheet, len);

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_SEND_CUE_SHEET;
	Set3bytes(cdb+6, len);
	return SendCmd(drive, cdb, len, REQ_DATAOUT);
}




int OpenTray(DRIVE *drive)
{
	SendPreventAllow(drive, 0);
	return SendStartStop(drive, 1, 1, 0);
}

int CloseTray(DRIVE *drive)
{
	return SendStartStop(drive, 1, 1, 1);
}


int GetDiscType(DRIVE *drive, int *disc_type_ret)
{
	BYTE cdb[12];
	int ret;
	struct _FEATURE_HEADER *fh;
	struct _DISCINFO *di;
	int disc_type;

	*disc_type_ret = DT_UNKNOWN;

	ret = CheckReady(drive);
	if(ret!=RET_OK){
		return ret;
	}

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_GET_CONFIGURATION;
	cdb[8] = 8;
	ret = SendCmd(drive, cdb, 8, REQ_DATAIN);
	if(ret==RET_OK){
		fh = (struct _FEATURE_HEADER *)drive->data_buf;
		disc_type = Get2bytes(fh->cur_profile);
		*disc_type_ret = disc_type;
		return RET_OK;
	}
	if(SD_SENSEKEY(drive)==5 && SD_ASC(drive)==0x20){
		/* GET CONFIG R}hT|[g */
		ret = SendReadDiscInfo(drive);
		if(ret!=RET_OK){
			return ret;
		}
		di = (struct _DISCINFO *)drive->data_buf;
		*disc_type_ret = di->erasable ? DT_CDRW : DT_CDR;
		return RET_OK;
	}

	return ret;
}

int CheckReady(DRIVE *drive)
{
	int ret;
	BOOL bGood=FALSE;
	BOOL bEjected=FALSE;

	while(bGood==FALSE){
		if(UICheckAbort()){
			return RET_ABORT;
		}
		ret = SendTestUnitReady(drive);
		if(ret==RET_OK){
			bGood=TRUE;
		}
		else{
			if(SD_SENSEKEY(drive)==0x02 && SD_ASC(drive)==0x04 && SD_ASCQ(drive)==0x01){
				/* becoming ready */
			}
			else if(SD_SENSEKEY(drive)==0x06 && SD_ASC(drive)==0x28 && SD_ASCQ(drive)==0x00){
				/* medium change */
			}
			else if(SD_SENSEKEY(drive)==0x06 && SD_ASC(drive)==0x29 && SD_ASCQ(drive)==0x00){
				/* power on, reset */
			}
#if 0
			else if(SD_SENSEKEY(drive)==0x02 && SD_ASC(drive)==0x3a && SD_ASCQ(drive)==0x00){
				/* medium not present */
			}
#endif
			else{
				/* Eject */
				if(bEjected==FALSE){
					OpenTray(drive);
					bEjected=TRUE;
				}
			}
			/*Sleep(100);*/
		}
	}

	return RET_OK;
}

int BlankDisc(DRIVE *drive, BYTE type)
{
	BYTE cdb[12];
	int ret;

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_BLANK;
	cdb[1] = (BYTE)(0x10|type);
	ret = SendCmd(drive, cdb, 0, REQ_NODATA);
	if(ret!=RET_OK){
		return ret;
	}

	ret = WaitProgress(drive, "", FALSE);
	return ret;
}


int WaitProgress(DRIVE *drive, const char *message, BOOL meter1)
{
	WORD indicator=0;
	BOOL bGood=FALSE;
	int ret;

	if(message!=NULL){
		if(meter1)
			UIMeter1Initialize(message);
		else
			UIMeter2Initialize(message);
	}

	while(bGood==FALSE){
		if(UICheckAbort()){
			return RET_ABORT;
		}
		//ret = SendTestUnitReady(drive);
		ret = SendReadDiscInfo(drive);
		if(ret==RET_OK){
			bGood=TRUE;
		}
		else{
			if(SD_SENSEKEY(drive)!=0x02){
				return RET_CMDERR;
			}
			/*  */
			if(drive->sense_data[15] & 0x80){
				indicator = Get2bytes(drive->sense_data+16);
				if(message!=NULL){
					if(meter1)
						UIMeter1Update((int)((indicator*100+0x7fff)/0xffff));
					else
						UIMeter2Update((int)((indicator*100+0x7fff)/0xffff));
				}
			}
			/*Sleep(100);*/
		}
	}

	return RET_OK;
}

void DispCommandError(DRIVE *drive)
{
	char buf[80];

	sprintf(buf, "R}hsG[(%02Xh : %X/%02X/%02X)",
		drive->cmdcode, SD_SENSEKEY(drive), SD_ASC(drive), SD_ASCQ(drive));
	UIDispMessage(buf, UIDMT_ERROR);
}

/*
 * READ CD R}h SUB-Q f[^擾
 */
int GetSubQ(DRIVE *drive, DWORD lba, DWORD len)
{
	BYTE cdb[12];

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_READ_CD;
	Set4bytes(cdb+2, lba);
	Set3bytes(cdb+6, len);
	cdb[10] = 2;
	return SendCmd(drive, cdb, len*16, REQ_DATAIN);
}

