//#include <Carbon/Carbon.h>
#include <CoreFoundation/CoreFoundation.h>
#include <IOKit/IOKitLib.h>
#include <IOKit/scsi-commands/SCSITaskLib.h>
#include "aspi.h"
#include "cmd.h"
#include "cmdlog.h"

#define MAXDEVICE	16
static mach_port_t				masterPort;
static io_iterator_t			scsiObjectIterator;
static io_service_t				scsiObjects[MAXDEVICE];
static int numObject;
static UInt64 transferCount;


UInt64 GettransferCount(void)
{
    return transferCount;
}

//-----------------------
int OpenAspi(void)
{
	CFMutableDictionaryRef	matchingDictionary;
	CFMutableDictionaryRef	subDictionary;
	kern_return_t	kr;

	/*
	 * ܂IOKitƒʐMׂ̃}X^[|[g쐬
	 */
	kr = IOMasterPort(MACH_PORT_NULL, &masterPort);
	if(kr||!masterPort){
		printf ( "ERR: Couldn't create a master IOKit Port(%08x)\n", kr );
		return RET_NG;
	}

	/*
	 * SCSI Architecture Model foCXׂ
	 * }b`OfBNVi쐬
	 */
	matchingDictionary = CFDictionaryCreateMutable(kCFAllocatorDefault, 0, NULL, NULL);
	/*
	 * TufBNVi쐬(I[TOfoCX)
	 */
	subDictionary = CFDictionaryCreateMutable(kCFAllocatorDefault, 0, NULL, NULL);
	CFDictionarySetValue(subDictionary,
						CFSTR(kIOPropertySCSITaskDeviceCategory),
						CFSTR(kIOPropertySCSITaskAuthoringDevice));
	/*
	 * }b`OfBNViɃTufBNViǉ
	 */
	CFDictionarySetValue(matchingDictionary, CFSTR(kIOPropertyMatchKey),
						subDictionary);

	/*
	 * foCX
	 */
	kr = IOServiceGetMatchingServices(masterPort, matchingDictionary,
									&scsiObjectIterator);
	if(kr!=kIOReturnSuccess){
		/* foCX */
		return RET_OK;
	}

	/*
	 * T[rXIuWFNg쐬Ă
	 */
	for(numObject=0; numObject<MAXDEVICE; numObject++){
		scsiObjects[numObject]=IOIteratorNext(scsiObjectIterator);
		if(scsiObjects[numObject]==NULL){
			break;
		}
	}

	return RET_OK;
}


void CloseAspi(void)
{
	int i;

	/*
	 * IuWFNg
	 */
	for(i=0; i<numObject; i++){
		IOObjectRelease(scsiObjects[i]);
	}

	/*
	 * }X^[|[g
	 */
	if(masterPort){
		mach_port_deallocate(mach_task_self(), masterPort);
	}
	masterPort=0;
}

int InitializeDrive(DRIVE *drive, int bufsize, int cmdlog_size)
{
	FreeDrive(drive);
	drive->hid = -1;
	drive->tid = -1;

	CmdLogInit(drive, cmdlog_size);
	if(drive->data_buf!=NULL){
		free(drive->data_buf);
		drive->data_buf = NULL;
	}
	if(bufsize>0){
		drive->data_buf = (BYTE *)malloc(bufsize);
		if(drive->data_buf==NULL)
			return RET_NG;
		drive->bufsize = bufsize;
	}
	
	drive->interface = NULL;
	drive->mmcInterface = NULL;
	drive->plugInInterface = NULL;
	
	return RET_OK;
}


static void ClearAspiSetting(DRIVE *drive)
{
    if(drive->interface){
        (*drive->interface)->RemoveCallbackDispatcherFromRunLoop(drive->interface);
		(*drive->interface)->ReleaseExclusiveAccess(drive->interface);
		(*drive->interface)->Release(drive->interface);
		drive->interface = NULL;
    }
    if(drive->mmcInterface){
		(*drive->mmcInterface)->Release(drive->mmcInterface);
		drive->mmcInterface = NULL;
    }
	if(drive->plugInInterface){
		IODestroyPlugInInterface(drive->plugInInterface);
		drive->plugInInterface = NULL;
	}
}

void FreeDrive(DRIVE *drive)
{
	CmdLogFree(drive);
	
	if(drive->data_buf!=NULL){
		free(drive->data_buf);
		drive->data_buf = NULL;
	}
	ClearAspiSetting(drive);
}

static void CheckAtapi(DRIVE *drive)
{
	BYTE cdb[12];
	int ret;
	
	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_MODE_SENSE10;
	cdb[2] = 0x2a;
	cdb[8] = 12;
	ret = SendCmd(drive, cdb, 12, REQ_DATAIN);
	if(ret!=RET_OK){
		drive->atapi = FALSE;
	}
	else{
		drive->atapi = drive->data_buf[8]==0x2a;
	}
}


int SetAspiSetting(DRIVE *drive, int *haid, int *tgid, DWORD *timeout)
{
	HRESULT			herr;
	kern_return_t	kr;
	SInt32	score;
	IOReturn ioRet;

	/* haid͎gpȂ */

	if(tgid!=NULL){
		if(*tgid<numObject){
			/* ܂ł̂ */
			ClearAspiSetting(drive);
			/* Vڑ */
			kr = IOCreatePlugInInterfaceForService(scsiObjects[*tgid],
												kIOMMCDeviceUserClientTypeID,
												kIOCFPlugInInterfaceID,
												&drive->plugInInterface,
												&score);
			if(kr!=noErr){
				printf("ERR: IOCreatePlugInInterfaceForService returned %d\n", kr);
				fflush(stdout);
				return RET_NG;
			}
			herr = (*drive->plugInInterface)->QueryInterface(drive->plugInInterface,
											 CFUUIDGetUUIDBytes(kIOMMCDeviceInterfaceID),
											 (LPVOID)&drive->mmcInterface);
			if(herr!=S_OK){
				printf("ERR: QueryInterface returned %ld\n", herr);
				fflush(stdout);
				return RET_NG;
			}

			drive->interface = (*drive->mmcInterface)->GetSCSITaskDeviceInterface(drive->mmcInterface);
			if(drive->interface==NULL){
				printf("ERR: GetSCSITaskDeviceInterface returned NULL\n");
				fflush(stdout);
				return RET_NG;
			}
			ioRet = (*drive->interface)->AddCallbackDispatcherToRunLoop(drive->interface,
														CFRunLoopGetCurrent());
			if(ioRet!=kIOReturnSuccess){
				printf("ERR: AddCallbackDispatcherToRunLoop()\n");
				fflush(stdout);
			}

			kr = (*drive->interface)->ObtainExclusiveAccess(drive->interface);
			if(kr!=noErr){
				printf("ERR: ObrainExclusiveAccess returned %d\n", kr);
				if(kr==kIOReturnBusy){
					printf("Media is still mounted.\n");
					fflush(stdout);
					return RET_NG;
				}
				if(kr==kIOReturnExclusiveAccess){
					printf("Another sofrware has exclusive access\n");
				}
				fflush(stdout);
				return RET_NG;
			}
			drive->tid = *tgid;
		}
		CheckAtapi(drive);
	}
	if(timeout!=NULL){
		drive->timeout = *timeout;
	}

	return RET_OK;
}


void GetAspiSetting(DRIVE *drive, int *haid, int *tgid, DWORD *timeout)
{
	/* haid͎gpȂ */

	if(tgid!=NULL){
		*tgid = drive->tid;
	}
	if(timeout!=NULL){
		*timeout = drive->timeout;
	}
}


///////////////////////////////////////////////////////////////////////////////////////////////
//	R}hR[h(cdb0)ACDBQbg
///////////////////////////////////////////////////////////////////////////////////////////////
static BYTE GetCDBLen( BYTE cdb0 )
{
	BYTE len=0;

	switch(cdb0&0xe0){
	case 0x00:  // 000X XXXX
		len = 6;  break;
	case 0x20:  // 001X XXXX
	case 0x40:  // 010X XXXX
	case 0x60:	// 011X XXXX
		len = 10;  break;
	case 0x80:  // 100X XXXX
	case 0xA0:  // 101X XXXX
	case 0xC0:  // 110X XXXX
	case 0xE0:  // 111X XXXX
		len = 12;  break;
	}
	return len;
}

int SendCmd(DRIVE *drive, BYTE *cdb, DWORD buflen, BYTE reqflag)
{
	SCSITaskInterface **task;
	SCSITaskStatus taskStatus;
	IOReturn ioRet;
	BYTE cdblen, transdir;
	IOVirtualRange	range;
	int retcode;

        drive->cmdcode = cdb[0];
	cdblen = GetCDBLen(cdb[0]);
	switch(reqflag){
	case REQ_DATAOUT:	transdir = kSCSIDataTransfer_FromInitiatorToTarget;	break;
	case REQ_DATAIN:	transdir = kSCSIDataTransfer_FromTargetToInitiator;	break;
	default:	transdir = kSCSIDataTransfer_NoDataTransfer;
	}

	memset(&drive->sense_data, 0, SENSEDATA_SIZE);

	task = (*drive->interface)->CreateSCSITask(drive->interface);
	if(task==NULL)
		return RET_NG;
	range.address = (IOVirtualAddress)drive->data_buf;
	range.length = buflen;
	ioRet = (*task)->SetCommandDescriptorBlock(task, cdb, cdblen);
	if(ioRet != kIOReturnSuccess){
		printf("ERR: Setting CDB : %02X...\n", cdb[0]);
		(*task)->Release(task);
		return RET_NG;
	}
	ioRet = (*task)->SetScatterGatherEntries(task, &range, 1, (UInt64)buflen, transdir);
	if(ioRet != kIOReturnSuccess){
		printf("ERR: Setting SG Entries : buf=%08X buflen=%08lX dir=%d\n",
		 range.address, range.length, transdir);
		(*task)->Release(task);
		return RET_NG;
	}
	ioRet = (*task)->SetTimeoutDuration(task, drive->timeout*1000);
	if(ioRet != kIOReturnSuccess){
		printf("ERR: Setting Timeout : %08lX\n", drive->timeout*1000);
		(*task)->Release(task);
		return RET_NG;
	}
	ioRet = (*task)->ExecuteTaskSync(task, (SCSI_Sense_Data *)drive->sense_data, &taskStatus, &transferCount);
	if(ioRet!=kIOReturnSuccess){
		printf("ERR: Executing Task\n");
		(*task)->Release(task);
		return RET_NG;
	}
                
	if(taskStatus==kSCSITaskStatus_GOOD){
		(*task)->Release(task);
		retcode = RET_OK;
	}
	else if(taskStatus==kSCSITaskStatus_CHECK_CONDITION){
		(*task)->Release(task);
		retcode = RET_CMDERR;
	}
	else{
		(*task)->Release(task);
		return RET_NG;
	}

	CmdLog(drive, cdb, buflen, reqflag, retcode);
	return retcode;
}

int GetDriveCount()
{
	return numObject;
}

io_service_t *GetSCSIObject(int drive_number)
{
    if(drive_number>=numObject){
        return NULL;
    }
    return &scsiObjects[drive_number];
}

int GetInquiryString(int targetid, char *buff, int bufsize)
{
	int count;
	HRESULT		herr;
	kern_return_t	kr;
	SInt32	score;
	IOReturn ioret;
	IOCFPlugInInterface 	**plugInInterface = NULL;
	MMCDeviceInterface	**mmcInterface = NULL;
	SCSICmd_INQUIRY_StandardData inqbuf;
	SCSITaskStatus taskStatus;
	SCSI_Sense_Data senseDataBuffer;
	unsigned char *bufptr = (unsigned char *)&inqbuf;
	int myerr = RET_NG;
	
	memset(bufptr, '\0', sizeof(SCSICmd_INQUIRY_StandardData));
	
	kr = IOCreatePlugInInterfaceForService(*GetSCSIObject(targetid),
										kIOMMCDeviceUserClientTypeID,
										kIOCFPlugInInterfaceID,
										&plugInInterface,
										&score);
	if(kr!=noErr){
		goto ERRRET;
	}
	herr = (*plugInInterface)->QueryInterface(plugInInterface,
										   CFUUIDGetUUIDBytes(kIOMMCDeviceInterfaceID),
										   (LPVOID)&mmcInterface);
	if(herr!=S_OK){
		goto ERRRET;
	}
	
	/* Inquirys */
	ioret = (*mmcInterface)->Inquiry(mmcInterface,
								  &inqbuf,
								  sizeof(SCSICmd_INQUIRY_StandardData),
								  &taskStatus,
								  &senseDataBuffer);
	if(ioret==kIOReturnExclusiveAccess){
		/* rIANZX擾G[ */
		myerr = RET_NG;
		goto ERRRET;
	}
	else if(ioret!=kIOReturnSuccess){
		/* ̑̃G[ */
		goto ERRRET;
	}
	
	if(bufsize>sizeof(inqbuf)-8+1){
		bufsize = sizeof(inqbuf)-8+1;
	}
	
	strncpy(buff, bufptr+8, bufsize);
	
	for(count=0; count<bufsize; count++){
		if(buff[count]<0x20){
			buff[count]='\0';
			break;
		}
	}
	if(count>=bufsize){
		buff[bufsize-1]='\0';
	}
	
	(*mmcInterface)->Release(mmcInterface);
	IODestroyPlugInInterface(plugInInterface);
	
	return RET_OK;
	
ERRRET:
	if(mmcInterface!=NULL){
		(*mmcInterface)->Release(mmcInterface);
	}
	if(plugInInterface!=NULL){
		IODestroyPlugInInterface(plugInInterface);
	}
	
	return myerr;
}

