#import <Cocoa/Cocoa.h>
#import "ui.h"
#import "MainWindowControl.h"

static BOOL g_bAbort=FALSE;
static MainWindowControl *g_mwc=NULL;

static void UIFlushMessage()
{
#ifndef USE_THREAD
	NSEvent *ev;
	while(1){
		ev = [NSApp nextEventMatchingMask: NSAnyEventMask
									untilDate: [NSDate date]
										inMode: NSEventTrackingRunLoopMode /*NSDefaultRunLoopMode*/
										   dequeue: YES];
		if(ev==nil)
			break;
		[NSApp sendEvent: ev];
	}
#endif
}

//void UISetCurrentEvent(NSEvent *ev)
//{
//	g_currEvent = ev;
//}

void UISetMWC(void *mwc)
{
	g_mwc = (MainWindowControl *)mwc;
}

BOOL UICheckAbort()
{
	UIFlushMessage();
	return g_bAbort;
}

void UISetAbort()
{
	g_bAbort=TRUE;
}

void UIClearAbort()
{
	g_bAbort=FALSE;
}


int UIDispMessage(const char *message, int type)
{
	int ret;
	NSString *msgStr;

	msgStr = [NSString stringWithCString : message];
	switch(type){
	case UIDMT_ERROR:
		ret = NSRunAlertPanel(@"ERROR", msgStr, @"OK", nil, nil);
		ret = UIDMRET_OK;
		break;
	case UIDMT_QUESTION:
		ret = NSRunAlertPanel(@"QUESTION", msgStr, @"YES", @"NO", nil);
		ret = (ret==0) ? UIDMRET_CANCEL : UIDMRET_OK;
		break;
	default:
		ret = NSRunInformationalAlertPanel(@"Information", msgStr, @"OK", nil, nil);
	}
	return ret;
}

void UIMeter1Initialize(const char *message)
{
//	::SendMessage(g_hWnd, WM_USER_UICTL, UICTL_METER1INIT, (LPARAM)message);
	[g_mwc uiCtlMeter1Initialize : message];
}

void UIMeter2Initialize(const char *message)
{
//	::SendMessage(g_hWnd, WM_USER_UICTL, UICTL_METER2INIT, (LPARAM)message);
	[g_mwc uiCtlMeter2Initialize : message];
}

void UIMeter1Update(int percentage)
{
//	::SendMessage(g_hWnd, WM_USER_UICTL, UICTL_METER1SETPOS, (LPARAM)percentage);
	[g_mwc uiCtlMeter1Update : percentage];
}

void UIMeter2Update(int percentage)
{
//	::SendMessage(g_hWnd, WM_USER_UICTL, UICTL_METER2SETPOS, (LPARAM)percentage);
	[g_mwc uiCtlMeter2Update : percentage];
}

void UIDispInfo(const char *message)
{
	[g_mwc uiCtlDispInfo : message];
}

int UISetting(OPTIONS *option)
{
//	return ::SendMessage(g_hWnd, WM_USER_UICTL, UICTL_SETTING, (LPARAM)option);
	return [g_mwc uiCtlSetting : option];
}

