/* ~Օʉ
 * Copyright (C) 2004 Kagetani Hideto
 */
// ThemeMessageDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "ThemeMessageDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CThemeMessageDlg _CAO


CThemeMessageDlg::CThemeMessageDlg(CWnd* pParent /*=NULL*/)
	: CThemeDialog(CThemeMessageDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CThemeMessageDlg)
	//}}AFX_DATA_INIT
	m_hIconStop = AfxGetApp()->LoadIcon(IDI_MSGDLG_STOP);
	m_hIconExclamation = AfxGetApp()->LoadIcon(IDI_MSGDLG_EXCLAMATION);
	m_hIconQuestion = AfxGetApp()->LoadIcon(IDI_MSGDLG_QUESTION);
	m_hIconInformation = AfxGetApp()->LoadIcon(IDI_APPICON);
}


void CThemeMessageDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CThemeMessageDlg)
	DDX_Control(pDX, IDC_STC_ICON, m_StcIcon);
	DDX_Control(pDX, IDC_BTN_EXTRA, m_BtnExtra);
	DDX_Control(pDX, IDC_STC_MESSAGE, m_StcMessage);
	DDX_Control(pDX, IDOK, m_BtnOK);
	DDX_Control(pDX, IDCANCEL, m_BtnCancel);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CThemeMessageDlg, CDialog)
	//{{AFX_MSG_MAP(CThemeMessageDlg)
	ON_BN_CLICKED(IDC_BTN_EXTRA, OnBtnExtra)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CThemeMessageDlg bZ[W nh
int CThemeMessageDlg::Disp(LPCTSTR pMessage, LPCTSTR pTitle, UINT nFlags)
{
	m_pMessage = pMessage;
	m_pTitle = pTitle;
	m_nFlags = nFlags;
	return this->DoModal();
}

BOOL CThemeMessageDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: ̈ʒuɏ̕⑫ǉĂ
	int nNumButton;
	if(m_pTitle!=NULL){
		SetWindowText(m_pTitle);
	}

	m_StcMessage.SetWindowText(m_pMessage);

	// {^ݒ
	switch(m_nFlags & MB_TYPEMASK){
	case MB_ABORTRETRYIGNORE:
		m_BtnExtra.SetWindowText("~");
		m_BtnOK.SetWindowText("Ďs");
		m_BtnCancel.SetWindowText("");
		m_nRetCodeExtra  = IDABORT;
		m_nRetCodeOK     = IDRETRY;
		m_nRetCodeCancel = IDIGNORE;
		nNumButton = 3;
		break;
	case MB_OKCANCEL:
		m_BtnOK.SetWindowText("OK");
		m_BtnCancel.SetWindowText("LZ");
		m_nRetCodeExtra  = IDCANCEL;
		m_nRetCodeOK     = IDOK;
		m_nRetCodeCancel = IDCANCEL;
		nNumButton = 2;
		break;
	case MB_RETRYCANCEL:
		m_BtnOK.SetWindowText("Ďs");
		m_BtnCancel.SetWindowText("LZ");
		m_nRetCodeExtra  = IDCANCEL;
		m_nRetCodeOK     = IDRETRY;
		m_nRetCodeCancel = IDCANCEL;
		nNumButton = 2;
		break;
	case MB_YESNO:
		m_BtnOK.SetWindowText("͂");
		m_BtnCancel.SetWindowText("");
		m_nRetCodeExtra  = IDCANCEL;
		m_nRetCodeOK     = IDYES;
		m_nRetCodeCancel = IDNO;
		nNumButton = 2;
		break;
	case MB_YESNOCANCEL:
		m_BtnExtra.SetWindowText("͂");
		m_BtnOK.SetWindowText("");
		m_BtnCancel.SetWindowText("LZ");
		m_nRetCodeExtra  = IDYES;
		m_nRetCodeOK     = IDNO;
		m_nRetCodeCancel = IDCANCEL;
		nNumButton = 3;
		break;
	case MB_OK:
		m_BtnCancel.SetWindowText("OK");
		m_nRetCodeExtra  = IDCANCEL;
		m_nRetCodeOK     = IDCANCEL;
		m_nRetCodeCancel = IDOK;
		nNumButton = 1;
		break;
	default:
		TRACE("^CvG[ : %s,0x%X\n", m_pMessage, m_nFlags);
		EndDialog(IDCANCEL);
		return TRUE;
	}

	if(nNumButton==3){
		m_BtnExtra.ShowWindow(SW_SHOW);
		m_BtnOK.ShowWindow(SW_SHOW);
		m_BtnCancel.ShowWindow(SW_SHOW);
		m_BtnExtra.ModifyStyle(0, BS_DEFPUSHBUTTON);
		m_BtnOK.ModifyStyle(BS_DEFPUSHBUTTON, 0);
		m_BtnCancel.ModifyStyle(BS_DEFPUSHBUTTON, 0);
		m_BtnExtra.SetFocus();
	}
	else if(nNumButton==2){
		m_BtnExtra.ShowWindow(SW_HIDE);
		m_BtnOK.ShowWindow(SW_SHOW);
		m_BtnCancel.ShowWindow(SW_SHOW);
		m_BtnExtra.ModifyStyle(BS_DEFPUSHBUTTON, 0);
		m_BtnOK.ModifyStyle(0, BS_DEFPUSHBUTTON);
		m_BtnCancel.ModifyStyle(BS_DEFPUSHBUTTON, 0);
		m_BtnOK.SetFocus();
	}
	else{
		m_BtnExtra.ShowWindow(SW_HIDE);
		m_BtnOK.ShowWindow(SW_HIDE);
		m_BtnCancel.ShowWindow(SW_SHOW);
		m_BtnExtra.ModifyStyle(BS_DEFPUSHBUTTON, 0);
		m_BtnOK.ModifyStyle(BS_DEFPUSHBUTTON, 0);
		m_BtnCancel.ModifyStyle(0, BS_DEFPUSHBUTTON);
		m_BtnCancel.SetFocus();
	}

	// ACRݒ
	HICON hIcon;
	switch(m_nFlags & MB_ICONMASK){
	case MB_ICONEXCLAMATION:
		hIcon = m_hIconExclamation;
		break;
	case MB_ICONINFORMATION:
		hIcon = m_hIconInformation;
		break;
	case MB_ICONQUESTION:
		hIcon = m_hIconQuestion;
		break;
	case MB_ICONSTOP:
		hIcon = m_hIconStop;
		break;
	default:
		hIcon = m_hIconInformation;
	}
	m_StcIcon.SetIcon(hIcon);

	// e[}ݒ
	CThemeSet *ThemeClass = GetTheme();
	m_BtnExtra.SetTheme(ThemeClass);
	m_BtnOK.SetTheme(ThemeClass);
	m_BtnCancel.SetTheme(ThemeClass);
	m_StcMessage.SetTheme(ThemeClass);

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CThemeMessageDlg::OnBtnExtra() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	EndDialog(m_nRetCodeExtra);
}

void CThemeMessageDlg::OnOK() 
{
	// TODO: ̈ʒuɂ̑̌ؗp̃R[hǉĂ
	EndDialog(m_nRetCodeOK);
//	CDialog::OnOK();
}

void CThemeMessageDlg::OnCancel() 
{
	// TODO: ̈ʒuɓʂȌ㏈ǉĂB
	EndDialog(m_nRetCodeCancel);
//	CDialog::OnCancel();
}
