/**
 * ~Օʉ - EnbanKensa
 * Copyright (C) 2005 Kagetani Hideto
 * drive.c - fBXNnhCuANZX֐Q
 * $Date: 2005/12/11 15:25:30 $
 * $Revision: 1.5 $
 */

#if !defined(WIN32)
# include <stdlib.h>
# include <string.h>
#endif

#include "drive.h"
#include "cmd.h"

int SendCmd(CMDDRIVE *drive, BYTE *cdb, DWORD buflen, BYTE reqflag)
{
  int ret;

  if(drive->cmd_type == CMDDRVCTYPE_UNKNOWN){
	drive->cmd_type = CMDDRVCTYPE_CHECKING;
	CheckAtapi(drive);
  }

  drive->cmdcode = cdb[0];
  ret = SendAspiCmd(&drive->drive, cdb, drive->data_buf, buflen,
					drive->sense_data, sizeof(drive->sense_data), reqflag);
  return ret;
}

int InitializeCmdDrive(CMDDRIVE *drive, int bufsize)
{
  int ret;

  FreeCmdDrive(drive);
  drive->cmd_type = CMDDRVCTYPE_UNKNOWN;

  if(bufsize>0){
	drive->data_buf = (BYTE *)malloc(bufsize);
	if(drive->data_buf==NULL){
	  return RET_NG;
	}
	drive->bufsize = bufsize;
	drive->own_alloc = TRUE;
  }

  ret = InitializeDrive(&drive->drive);
  if(ret != RET_OK){
	if(drive->own_alloc){
	  free(drive->data_buf);
	  drive->data_buf=NULL;
	}
	return ret;
  }

  return RET_OK;
}

void FreeCmdDrive(CMDDRIVE *drive)
{
  if(drive->data_buf!=NULL){
	if(drive->own_alloc){
	  free(drive->data_buf);
	}
	drive->data_buf=NULL;
  }

  FreeDrive(&drive->drive);
}

void CheckAtapi(CMDDRIVE *drive)
{
  BYTE cdb[12];
  BYTE buf[12];
  BYTE *keep;
  int ret;

  keep = drive->data_buf;
  drive->data_buf = buf;

  memset(cdb, 0, sizeof(cdb));
  cdb[0] = CMD_MODE_SENSE10;
  cdb[2] = 0x2a;
  cdb[8] = 12;
  ret = SendCmd(drive, cdb, 12, REQ_DATAIN);
  if(ret!=RET_OK){
	drive->cmd_type = CMDDRVCTYPE_SCSI;
  }
  else{
	drive->cmd_type = (drive->data_buf[8]==0x2a ? CMDDRVCTYPE_ATAPI:CMDDRVCTYPE_SCSI);
  }

  drive->data_buf = keep;
}

int SetDriveAspiSetting(CMDDRIVE *drive, int *ha, int *tg, DWORD *timeout)
{
  drive->cmd_type = CMDDRVCTYPE_UNKNOWN;
  return SetAspiSetting(&drive->drive, ha, tg, timeout);
}

void SetDriveBuffer(CMDDRIVE *drive, char *data_buf, int bufsize)
{
  drive->data_buf = data_buf;
  drive->bufsize = bufsize;
}

