/* ~Օʉ - EnbanKensa
 * Copyright (c) 2005 Kagetani Hideto
 * ui.c - [UC^[tF[X
 * $Date: 2005/12/07 15:35:35 $
 * $Revision: 1.2 $
 */
#ifndef __UI_H__
#define __UI_H__

#include "option.h"

#if defined(COCOA)
# include <Cocoa/Cocoa.h>
#endif

typedef struct {
	unsigned short red;
	unsigned short green;
	unsigned short blue;
} UICOLOR;

#if defined(COCOA)
typedef struct {
  id label;
  id view;
  id settingPanel;
  NSImage *drawArea;
  NSFont *font;
} UIWIDGETINFO;

extern void UISetWidgetInfo(UIWIDGETINFO *widget_info);
#endif

extern BOOL UICheckAbort();
extern void UISetAbort();
extern void UIClearAbort();
extern int UIDispMessage(const char *message, int type);
/* type value */
#define UIDMT_INFORMATION	0
#define UIDMT_ERROR		1
#define UIDMT_QUESTION	2
/* return value */
#define UIDMRET_OK		0
#define UIDMRET_CANCEL	1

extern void UIDispInfo(const char *message);
extern void UIDrawLine(int x0, int y0, int x1, int y1, const UICOLOR *color);
extern void UIDrawBox(int x0, int y0, int x1, int y1, const UICOLOR *color, BOOL fill);
extern void UIDrawText(int x0, int y0, const UICOLOR *color, const char *text);
extern void UIGetDrawableSize(int *width, int *height);
extern int UISetting(OPTIONS *option);

#endif /* !__UI_H__ */
