/* ~Օʉ - EnbanKensa
 * Copyright (c) 2005 Kagetani Hideto
 * ui.m - [UC^[tF[X
 * $Date: 2005/12/07 15:35:35 $
 * $Revision: 1.2 $
 */
#define COCOA
#include "ui.h"
#include "SettingDialogControl.h"

#define min_value(a,b) ((a)<(b) ? (a):(b))

static BOOL g_bAbort=FALSE;
static UIWIDGETINFO *g_WidgetInfo=NULL;

static void UIFlushMessage()
{
  NSEvent *ev;
  while(1){
	ev = [NSApp nextEventMatchingMask: NSAnyEventMask
		  untilDate: [NSDate date]
		  inMode: NSEventTrackingRunLoopMode /*NSDefaultRunLoopMode*/
		  dequeue: YES];
	if(ev==nil)
	  break;
	[NSApp sendEvent: ev];
  }
}

BOOL UICheckAbort()
{
  UIFlushMessage();
  return g_bAbort;
}

void UISetAbort()
{
  g_bAbort = TRUE;
}

void UIClearAbort()
{
  g_bAbort = FALSE;
}

int UIDispMessage(const char *message, int type)
{
  int ret;
  NSString *msgStr;

  msgStr = [NSString stringWithCString : message];
  switch(type){
  case UIDMT_ERROR:
	ret = NSRunAlertPanel(@"ERROR", msgStr,
						  [NSString stringWithCString: ""],
						  nil, nil);
	ret = UIDMRET_OK;
	break;
  case UIDMT_QUESTION:
	ret = NSRunAlertPanel(@"QUESTION", msgStr,
						  [NSString stringWithCString: "͂"],
						  [NSString stringWithCString: ""], nil);
	ret = (ret==0) ? UIDMRET_CANCEL : UIDMRET_OK;
	break;
  default:
	ret = NSRunInformationalAlertPanel(@"Information", msgStr,
									   [NSString stringWithCString: ""],
									   nil, nil);
	ret = UIDMRET_OK;
  }
  return ret;
}

void UISetWidgetInfo(UIWIDGETINFO *widget_info)
{
  g_WidgetInfo = widget_info;
}


void UIDispInfo(const char *message)
{
  if(message==NULL)
	message="";
  if(g_WidgetInfo!=NULL)
	[g_WidgetInfo->label  setStringValue : [NSString stringWithCString : message]];
}

void UIDrawLine(int x0, int y0, int x1, int y1, const UICOLOR *color)
{
  NSPoint point0, point1;

  if(g_WidgetInfo == NULL)
	return;

  [g_WidgetInfo->drawArea lockFocus];

  [[NSColor colorWithDeviceRed:(color->red)/65536.0
	green:(color->green)/65536.0
	blue:(color->blue)/65536.0
	alpha:1.0] set];

  NSSize size = [g_WidgetInfo->drawArea size];
  point0.x = x0;
  point0.y = size.height - y0;
  point1.x = x1;
  point1.y = size.height - y1;
  [NSBezierPath strokeLineFromPoint:point0 toPoint:point1];

  [g_WidgetInfo->drawArea unlockFocus];

  [g_WidgetInfo->view setNeedsDisplayInRect:
				 NSMakeRect(min_value(point0.x, point1.x),
							min_value(point0.y, point1.y),
							abs(point1.x-point0.x)+1,
							abs(point1.y-point0.y)+1)];
}

void UIDrawBox(int x0, int y0, int x1, int y1, const UICOLOR *color, BOOL fill)
{
  NSRect rect;

  if(g_WidgetInfo == NULL)
	return;
  
  [g_WidgetInfo->drawArea lockFocus];

  [[NSColor colorWithDeviceRed:(color->red)/65536.0
	green:(color->green)/65536.0
	blue:(color->blue)/65536.0
	alpha:1.0] set];

  NSSize size = [g_WidgetInfo->drawArea size];
  rect = NSMakeRect(min_value(x0, x1),
					min_value(size.height-y0, size.height-y1),
					abs(x1-x0), abs(y1-y0));

  if(fill)
	NSRectFill(rect);
  else
	NSFrameRect(rect);
  
  [g_WidgetInfo->drawArea unlockFocus];

  [g_WidgetInfo->view setNeedsDisplayInRect: rect];
}

void UIDrawText(int x0, int y0, const UICOLOR *color, const char *text)
{
  if(g_WidgetInfo == NULL)
	return;

  NSAttributedString *string;
  NSMutableDictionary *attributes;
  NSColor *col;
  NSSize size;

  [g_WidgetInfo->drawArea lockFocus];
  
  col = [NSColor colorWithDeviceRed:(color->red)/65536.0
		 green:(color->green)/65536.0
		 blue:(color->blue)/65536.0
		 alpha:1.0];
  
  NSSize areaSize = [g_WidgetInfo->drawArea size];

  attributes = [NSMutableDictionary dictionary];
  [attributes setObject:col forKey:NSForegroundColorAttributeName];

  [g_WidgetInfo->font set];
  
  string = [[NSAttributedString alloc]
			 initWithString: [NSString stringWithCString: text]
			 attributes: attributes];
  size = [string size];
  [string drawAtPoint: NSMakePoint(x0, areaSize.height-y0-size.height)];
  
  [g_WidgetInfo->drawArea unlockFocus];

  [g_WidgetInfo->view setNeedsDisplayInRect:
   NSMakeRect(x0, areaSize.height-y0-size.height, size.width, size.height)];

  [string release];
}

void UIGetDrawableSize(int *width, int *height)
{
  if(g_WidgetInfo==NULL){
	*width = 0;
	*height = 0;
	return;
  }

  NSSize size = [g_WidgetInfo->drawArea size];
  *width = size.width;
  *height = size.height;
}

int UISetting(OPTIONS *option)
{
	if(g_WidgetInfo==NULL){
		return RET_NG;
	}
	
	return [g_WidgetInfo->settingPanel openSettingDialog: option];
}
