// EnbanKensaDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "EnbanKensa.h"
#include "EnbanKensaDlg.h"
#include "ThemeSelectDlg.h"
#include "ThemeMessageDlg.h"
#include "SettingDlg.h"
#include <GraphicUtil.h>
#include "ui.h"
#include "check.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define THEME_DEFAULT	0
#define THEME_AQUA		1

/////////////////////////////////////////////////////////////////////////////
// AvP[Ṽo[WŎgĂ CAboutDlg _CAO

class CAboutDlg : public CThemeDialog
{
public:
	CAboutDlg();

// _CAO f[^
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	CThemeButton	m_BtnOK;
	CThemeLabel	m_StcVersion;
	CThemeLabel	m_StcCopyright;
	//}}AFX_DATA

	// ClassWizard ͉z֐̃I[o[Ch𐶐܂
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV ̃T|[g
	//}}AFX_VIRTUAL

// Cve[V
protected:
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	CBitmap m_bmpLogo;
	CBitmap m_bmpLogoMask;
	void DrawAppLogo(CDC *pDC);
};

CAboutDlg::CAboutDlg() : CThemeDialog(CAboutDlg::IDD, NULL)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
	m_bmpLogo.LoadBitmap(IDB_APPLOGO);
	m_bmpLogoMask.LoadBitmap(IDB_APPLOGO_MASK);
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Control(pDX, IDOK, m_BtnOK);
	DDX_Control(pDX, IDC_STC_VERSION, m_StcVersion);
	DDX_Control(pDX, IDC_STC_COPYRIGHT, m_StcCopyright);
	//}}AFX_DATA_MAP
}

BOOL CAboutDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: ̈ʒuɏ̕⑫ǉĂ
	m_BtnOK.SetTheme(GetTheme());
	m_StcCopyright.SetTheme(GetTheme());
	m_StcVersion.SetTheme(GetTheme());
	
	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}


void CAboutDlg::OnPaint() 
{
	CPaintDC dc(this); // `p̃foCX ReLXg
	
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉĂ
	DrawAppLogo(&dc);
	// `pbZ[WƂ CDialog::OnPaint() ĂяoĂ͂܂
}

void CAboutDlg::DrawAppLogo(CDC *pDC)
{
	RECT rcLogo;
	SIZE szLogo;
	THEME_BITMAP tb;
	CGraphicUtil GUtil;

	tb.bitmap = &m_bmpLogo;
	tb.mask = &m_bmpLogoMask;
	tb.border_height = 0;
	tb.border_height = 0;
	tb.flags = TBF_TILE;

	szLogo = GUtil.GetBitmapSize(&m_bmpLogo);

	GetDlgItem(IDC_STC_LOGO)->GetWindowRect(&rcLogo);
	ScreenToClient(&rcLogo);

	rcLogo.right = rcLogo.left + szLogo.cx;
	rcLogo.bottom = rcLogo.top + szLogo.cy;
	GUtil.DrawThemeBitmap(this, pDC, &tb, &rcLogo);
}


BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEnbanKensaDlg _CAO

CEnbanKensaDlg::CEnbanKensaDlg(CWnd* pParent /*=NULL*/)
	: CThemeDialog(CEnbanKensaDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEnbanKensaDlg)
		// : ̈ʒu ClassWizard ɂăȍǉ܂B
	//}}AFX_DATA_INIT
	// : LoadIcon  Win32  DestroyIcon ̃TuV[PXv܂B
	m_hIcon = AfxGetApp()->LoadIcon(IDI_APPICON);
	m_nThemeNumber = THEME_DEFAULT;
	m_bScanDone = FALSE;
	m_pDrives = NULL;
	m_bRunning = FALSE;
	::ZeroMemory(&m_Drawable, sizeof(m_Drawable));
	m_bmpLogo.LoadBitmap(IDB_LOGO);
	m_bmpLogoMask.LoadBitmap(IDB_LOGOMASK);

}

void CEnbanKensaDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEnbanKensaDlg)
	DDX_Control(pDX, IDC_STC_INFO, m_StcInfo);
	DDX_Control(pDX, IDC_STC_DRAWAREA, m_StcDrawArea);
	DDX_Control(pDX, IDOK, m_BtnOK);
	DDX_Control(pDX, IDC_STC_DRIVE, m_StcDrive);
	DDX_Control(pDX, IDC_CMB_DRIVE, m_CmbDrive);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CEnbanKensaDlg, CDialog)
	//{{AFX_MSG_MAP(CEnbanKensaDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_KICKIDLE, OnKickIdle)
	ON_MESSAGE(WM_USER_UICTL, OnUICtl)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEnbanKensaDlg bZ[W nh

BOOL CEnbanKensaDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// "o[W..." j[ڂVXe j[֒ǉ܂B

	// IDM_ABOUTBOX ̓R}h j[͈̔͂łȂ΂Ȃ܂B
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL){
		CString strAboutMenu, strThemeSelect;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		strThemeSelect.LoadString(IDS_THEMESELECT);
		if (!strAboutMenu.IsEmpty()){
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
			if(!strThemeSelect.IsEmpty()){
				pSysMenu->AppendMenu(MF_STRING, IDM_THEMESELECT, strThemeSelect);
			}
		}
	}

	// ̃_CAOp̃ACRݒ肵܂Bt[[N̓AvP[ṼC
	// EBhE_CAOłȂ͎Iɐݒ肵܂B
	SetIcon(m_hIcon, TRUE);			// 傫ACRݒ
	SetIcon(m_hIcon, FALSE);		// ACRݒ
	
	// TODO: ʂȏs͂̏ꏊɒǉĂB
	LoadIniFile();
	LoadTheme();
	SetWindowText("~Ռ");
	OpenAspi();
	RECT rect;
	m_StcDrawArea.GetClientRect(&rect);
	CreateDrawable(rect.right-rect.left, rect.bottom-rect.top);
	m_BtnOK.SetWindowText("Jn");

	return TRUE;  // TRUE ԂƃRg[ɐݒ肵tH[JX͎܂B
}

void CEnbanKensaDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	switch(nID & 0xFFF0){
	case IDM_ABOUTBOX:
		{
			CAboutDlg dlgAbout;
			dlgAbout.SetTheme(GetTheme());
			dlgAbout.DoModal();
		}
		break;
	case IDM_THEMESELECT:
		{
			CThemeSelectDlg dlgThemeSel;
			CThemeSet *pThemeClass = ((CEnbanKensaApp *)AfxGetApp())->GetThemeClass();
			dlgThemeSel.SetTheme(pThemeClass);
			dlgThemeSel.SetThemeNumber(m_nThemeNumber);
			if(dlgThemeSel.DoModal()==IDOK){
				m_nThemeNumber = dlgThemeSel.GetThemeNumber();
				LoadTheme();
				RedrawWindow(NULL, NULL, RDW_INVALIDATE|RDW_FRAME);
				Invalidate();
			}
		}
		break;
	default:
		CDialog::OnSysCommand(nID, lParam);
	}
}

// _CAO{bNXɍŏ{^ǉȂ΁AACR`悷
// R[hȉɋLqKv܂BMFC AvP[V document/view
// fgĂ̂ŁȀ̓t[[Nɂ莩Iɏ܂B

void CEnbanKensaDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // `p̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// NCAg̋`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR`悵܂B
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CPaintDC dc(this);
		DrawLogo(&dc);

		CDialog::OnPaint();
	}
}

// VXéA[U[ŏEBhEhbOĂԁA
// J[\\邽߂ɂĂяo܂B
HCURSOR CEnbanKensaDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CEnbanKensaDlg::OnOK() 
{
	// TODO: ̈ʒuɂ̑̌ؗp̃R[hǉĂ
	
	//CDialog::OnOK();
	if(m_bRunning){
		UISetAbort();
		m_bRunning = FALSE;
		m_BtnOK.EnableWindow(FALSE);
		return;
	}

	DRIVEID drive;
	int sel_drive;
	int ret;

	/* IhCu擾 */
	sel_drive = m_CmbDrive.GetCurSel();
	if(sel_drive == CB_ERR)
		return;

	drive.hid = m_pDrives[sel_drive].hid;
	drive.tid = m_pDrives[sel_drive].tid;

	UIClearAbort();
	UISetHWND(this->m_hWnd);
	m_BtnOK.SetWindowText("f");
	m_BtnOK.SetFocus();
	m_CmbDrive.EnableWindow(FALSE);
	m_bRunning = TRUE;

	ret = CheckDisc(&drive);

	m_BtnOK.SetWindowText("Jn");
	m_BtnOK.EnableWindow(TRUE);
	m_CmbDrive.EnableWindow(TRUE);
	m_bRunning = FALSE;
}

void CEnbanKensaDlg::LoadIniFile()
{
	char buf[80];

	GetRegString("theme", buf, sizeof(buf));
	if(!strcmp(buf, "aqua")){
		m_nThemeNumber = THEME_AQUA;
	}
	else{
		m_nThemeNumber = THEME_DEFAULT;
	}
}

void CEnbanKensaDlg::SaveIniFile()
{
	char *type;

	switch(m_nThemeNumber){
	case THEME_AQUA:
		type = "aqua";
		break;
	default:
		type = "normal";
	}
	WriteRegString("theme", type);
}

void CEnbanKensaDlg::GetRegString(const char *key, char *string_ret, DWORD size)
{
	LONG lRet;
	HKEY hKey;
	DWORD dwCount;
	DWORD dwType;

	if(size==0)
		return;
	if(string_ret==NULL)
		return;
	if(key==NULL)
		return;

	lRet = RegCreateKeyEx(HKEY_CURRENT_USER, "SOFTWARE\\EnbanKensa", 0, NULL,
						REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, NULL);
	if(lRet!=ERROR_SUCCESS)
		return;
	dwCount = size;
	dwType = REG_SZ;
	lRet = RegQueryValueEx(hKey, key, NULL, &dwType, (unsigned char *)string_ret, &dwCount);
	if(lRet!=ERROR_SUCCESS){
		RegCloseKey(hKey);
		return;
	}
	RegCloseKey(hKey);
	string_ret[size-1]='\0';
}

void CEnbanKensaDlg::WriteRegString(const char *key, const char *string)
{
	LONG lRet;
	HKEY hKey;

	if(key==NULL)
		return;
	if(string==NULL)
		string="";
	lRet = RegCreateKeyEx(HKEY_CURRENT_USER, "SOFTWARE\\EnbanKensa", 0, NULL,
						REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, NULL);
	if(lRet!=ERROR_SUCCESS)
		return;
	lRet = RegSetValueEx(hKey, key, 0, REG_SZ, (const unsigned char *)string, strlen(string));
	if(lRet!=ERROR_SUCCESS){
		RegCloseKey(hKey);
		return;
	}
	RegCloseKey(hKey);
}

void CEnbanKensaDlg::LoadTheme()
{
	LOADABLE_THEME_BITMAP ltbButtonNormal		= { IDB_BUTTON_NORMAL, 0, 2, 2, TBF_STRETCH };
	LOADABLE_THEME_BITMAP ltbButtonFocus		= { IDB_BUTTON_FOCUS, 0, 2, 2, TBF_STRETCH };
	LOADABLE_THEME_BITMAP ltbButtonSelect		= { IDB_BUTTON_SELECT, 0, 2, 2, TBF_STRETCH };
	LOADABLE_THEME_BITMAP ltbButtonDisable		= { IDB_BUTTON_DISABLE, 0, 2, 2, TBF_STRETCH };
	LOADABLE_THEME_BITMAP ltbDropButton			= { IDB_DROPDOWN, 0, 2, 2, TBF_STRETCH };
//	LOADABLE_THEME_BITMAP ltbComboBoxBG			= { IDB_COMBOBOX, 0, 2, 2, TBF_TILE };
//	LOADABLE_THEME_BITMAP ltbChecked			= { IDB_CHECKED, 0, 4, 4, TBF_STRETCH };
//	LOADABLE_THEME_BITMAP ltbUnchecked			= { IDB_UNCHECKED, 0, 4, 4, TBF_STRETCH };
//	LOADABLE_THEME_BITMAP ltbProgressBG			= { IDB_PROGRESSBG, 0, 16, 4, TBF_VSTRETCH };
//	LOADABLE_THEME_BITMAP ltbProgressFG			= { IDB_PROGRESSFG, 0, 12, 4, TBF_VSTRETCH };
	LOADABLE_THEME_BITMAP ltbDialogBG			= { IDB_DIALOGBG, 0, 16, 0, TBF_TILE };
	LOADABLE_THEME_BITMAP ltbCloseButton		= { IDB_CLOSEBUTTON, 0, 2, 2, TBF_STRETCH };
	LOADABLE_THEME_BITMAP ltbMaxButton			= { IDB_MAXBUTTON, 0, 2, 2, TBF_STRETCH };
	LOADABLE_THEME_BITMAP ltbMinButton			= { IDB_MINBUTTON, 0, 2, 2, TBF_STRETCH };
	LOADABLE_THEME_BITMAP ltbTitleActive		= { IDB_TITLE_ACT, 0, 16, 0, TBF_VSTRETCH };
	LOADABLE_THEME_BITMAP ltbTitleInactive		= { IDB_TITLE_INACT, 0, 16, 0, TBF_VSTRETCH };
	LOADABLE_THEME theme_normal[] = {
		{ TCID_DEFAULT, TTID_FGCOLOR, TSID_NORMAL, THEME_DATA_COLOR(RGB(255,255,200)) },
		{ TCID_DEFAULT, TTID_FGCOLOR, TSID_FOCUSED, THEME_DATA_COLOR(RGB(250,250,235)) },
		{ TCID_DEFAULT, TTID_FGCOLOR, TSID_SELECTED, THEME_DATA_COLOR(RGB(235,238,230)) },
		{ TCID_DEFAULT, TTID_FGCOLOR, TSID_DISABLED, THEME_DATA_COLOR(RGB(192,192,192)) },
		{ TCID_BUTTON, TTID_BITMAP, TSID_NORMAL, THEME_DATA_BITMAP(&ltbButtonNormal) },
		{ TCID_BUTTON, TTID_BITMAP, TSID_FOCUSED, THEME_DATA_BITMAP(&ltbButtonFocus) },
		{ TCID_BUTTON, TTID_BITMAP, TSID_SELECTED, THEME_DATA_BITMAP(&ltbButtonSelect) },
		{ TCID_BUTTON, TTID_BITMAP, TSID_DISABLED, THEME_DATA_BITMAP(&ltbButtonDisable) },
//		{ TCID_CHECKBOX, TTID_CHECKED, TSID_NORMAL, THEME_DATA_BITMAP(&ltbChecked) },
//		{ TCID_CHECKBOX, TTID_UNCHECKED, TSID_NORMAL, THEME_DATA_BITMAP(&ltbUnchecked) },
//		{ TCID_COMBOBOX, TTID_BITMAP, TSID_NORMAL, THEME_DATA_BITMAP(&ltbComboBoxBG) },
		{ TCID_COMBOBOX, TTID_DROPBUTTON, TSID_NORMAL, THEME_DATA_BITMAP(&ltbDropButton) },
//		{ TCID_PROGRESSBAR, TTID_BITMAP, TSID_NORMAL, THEME_DATA_BITMAP(&ltbProgressBG) },
//		{ TCID_PROGRESSBAR, TTID_FGBITMAP, TSID_NORMAL, THEME_DATA_BITMAP(&ltbProgressFG) },
		{ TCID_DIALOG, TTID_BGBITMAP, TSID_NORMAL, THEME_DATA_BITMAP(&ltbDialogBG) },
		{ TCID_DIALOG, TTID_CLOSEBUTTON, TSID_NORMAL, THEME_DATA_BITMAP(&ltbCloseButton) },
		{ TCID_DIALOG, TTID_MAXBUTTON, TSID_NORMAL, THEME_DATA_BITMAP(&ltbMaxButton) },
		{ TCID_DIALOG, TTID_MINBUTTON, TSID_NORMAL, THEME_DATA_BITMAP(&ltbMinButton) },
		{ TCID_DIALOG, TTID_TITLEBITMAP, TSID_NORMAL, THEME_DATA_BITMAP(&ltbTitleActive) },
		{ TCID_DIALOG, TTID_TITLEBITMAP, TSID_DISABLED, THEME_DATA_BITMAP(&ltbTitleInactive) },
		{ TCID_END, 0, 0, NULL }
	};
	/* Aqua */
	LOADABLE_THEME_BITMAP ltbAquaButton      = { IDB_AQUA_BUTTON, IDB_AQUA_BUTTONMASK, 10, 2, TBF_STRETCH };
	LOADABLE_THEME_BITMAP ltbAquaButtonFocus = { IDB_AQUA_BUTTONFOCUS, IDB_AQUA_BUTTONMASK, 10, 2, TBF_STRETCH };
	LOADABLE_THEME_BITMAP ltbAquaCheck       = { IDB_AQUA_CHECKED, IDB_AQUA_CHECKEDMASK, 0, 0, TBF_TILE };
	LOADABLE_THEME_BITMAP ltbAquaUncheck     = { IDB_AQUA_UNCHECKED, IDB_AQUA_UNCHECKEDMASK, 0, 0, TBF_TILE };
	LOADABLE_THEME_BITMAP ltbAquaProgressBG  = { IDB_AQUA_PROGRESSBG, 0, 0, 0, TBF_VSTRETCH };
	LOADABLE_THEME_BITMAP ltbAquaProgressFG  = { IDB_AQUA_PROGRESSFG, 0, 0, 0, TBF_VSTRETCH };
	LOADABLE_THEME_BITMAP ltbAquaDropButton  = { IDB_AQUA_DROPBUTTON, IDB_AQUA_DROPBUTTONMASK, 0, 0, TBF_STRETCH };
	LOADABLE_THEME_BITMAP ltbAquaComboBoxBG  = { IDB_AQUA_COMBOBOXBG, 0, 6, 2, TBF_VSTRETCH };
	LOADABLE_THEME_BITMAP ltbAquaTitleActive = { IDB_AQUA_TITLEACT, 0, 0, 0, TBF_VSTRETCH };
	LOADABLE_THEME_BITMAP ltbAquaTitleInactive  = { IDB_AQUA_TITLEINACT, 0, 0, 0, TBF_VSTRETCH };
	LOADABLE_THEME_BITMAP ltbAquaDialog      = { IDB_AQUA_DIALOGBG, 0, 0, 0, TBF_TILE };
	LOADABLE_THEME_BITMAP ltbAquaCloseButton = { IDB_AQUA_CLOSEBUTTON, IDB_AQUA_CLOSEBUTTONMASK, 0, 0, TBF_STRETCH };
	LOADABLE_THEME_BITMAP ltbAquaMaxButton = { IDB_AQUA_MAXBUTTON, IDB_AQUA_CLOSEBUTTONMASK, 0, 0, TBF_STRETCH };
	LOADABLE_THEME_BITMAP ltbAquaMinButton = { IDB_AQUA_MINBUTTON, IDB_AQUA_CLOSEBUTTONMASK, 0, 0, TBF_STRETCH };
	LOADABLE_THEME theme_aqua[] = {
		{ TCID_DEFAULT, TTID_FGCOLOR, TSID_NORMAL, THEME_DATA_COLOR(RGB(0,0,0)) },
		{ TCID_DEFAULT, TTID_FGCOLOR, TSID_DISABLED, THEME_DATA_COLOR(RGB(128,128,128)) },
		{ TCID_BUTTON, TTID_BITMAP, TSID_NORMAL, THEME_DATA_BITMAP(&ltbAquaButton) },
		{ TCID_BUTTON, TTID_BITMAP, TSID_FOCUSED, THEME_DATA_BITMAP(&ltbAquaButtonFocus) },
		{ TCID_BUTTON, TTID_BITMAP, TSID_SELECTED, THEME_DATA_BITMAP(&ltbAquaButtonFocus) },
		{ TCID_CHECKBOX, TTID_CHECKED, TSID_NORMAL, THEME_DATA_BITMAP(&ltbAquaCheck) },
		{ TCID_CHECKBOX, TTID_UNCHECKED, TSID_NORMAL, THEME_DATA_BITMAP(&ltbAquaUncheck) },
		{ TCID_PROGRESSBAR, TTID_BITMAP, TSID_NORMAL, THEME_DATA_BITMAP(&ltbAquaProgressBG) },
		{ TCID_PROGRESSBAR, TTID_FGBITMAP, TSID_NORMAL, THEME_DATA_BITMAP(&ltbAquaProgressFG) },
		{ TCID_COMBOBOX, TTID_DROPBUTTON, TSID_NORMAL, THEME_DATA_BITMAP(&ltbAquaDropButton) },
		{ TCID_COMBOBOX, TTID_BITMAP, TSID_NORMAL, THEME_DATA_BITMAP(&ltbAquaComboBoxBG) },
		{ TCID_DIALOG, TTID_BGBITMAP, TSID_NORMAL, THEME_DATA_BITMAP(&ltbAquaDialog) },
		{ TCID_DIALOG, TTID_TITLEFGCOLOR, TSID_NORMAL, THEME_DATA_COLOR(RGB(0,0,0)) },
		{ TCID_DIALOG, TTID_TITLEBITMAP, TSID_NORMAL, THEME_DATA_BITMAP(&ltbAquaTitleActive) },
		{ TCID_DIALOG, TTID_TITLEBITMAP, TSID_DISABLED, THEME_DATA_BITMAP(&ltbAquaTitleInactive) },
		{ TCID_DIALOG, TTID_CLOSEBUTTON, TSID_NORMAL, THEME_DATA_BITMAP(&ltbAquaCloseButton) },
		{ TCID_DIALOG, TTID_MAXBUTTON, TSID_NORMAL, THEME_DATA_BITMAP(&ltbAquaMaxButton) },
		{ TCID_DIALOG, TTID_RESTOREBUTTON, TSID_NORMAL, THEME_DATA_BITMAP(&ltbAquaMaxButton) },
		{ TCID_DIALOG, TTID_MINBUTTON, TSID_NORMAL, THEME_DATA_BITMAP(&ltbAquaMinButton) },
		{ TCID_END, 0, 0, NULL }
	};

	CThemeSet *pThemeClass = ((CEnbanKensaApp *)AfxGetApp())->GetThemeClass();
	LOADABLE_THEME *theme;
	
	switch(m_nThemeNumber){
	case THEME_AQUA:
		theme = theme_aqua;
		break;
	default:
		theme = theme_normal;
	}

	pThemeClass->InitializeTheme();
	pThemeClass->LoadThemeFromStruct(theme);
	m_BtnOK.SetTheme(pThemeClass);
	m_StcDrive.SetTheme(pThemeClass);
	m_CmbDrive.SetTheme(pThemeClass);
	m_StcInfo.SetTheme(pThemeClass);
	this->SetTheme(pThemeClass);
}

void CEnbanKensaDlg::OnCancel() 
{
	// TODO: ̈ʒuɓʂȌ㏈ǉĂB
	if(m_bRunning){
		UISetAbort();
		m_bRunning=FALSE;
		m_BtnOK.EnableWindow(FALSE);
		return;
	}
	SaveIniFile();
	CDialog::OnCancel();
}

LRESULT CEnbanKensaDlg::OnKickIdle(WPARAM wParam, LPARAM lParam)
{
	SCAN_t *drives;
	CString csMessage;
	CComboBox *cb = &m_CmbDrive;
	int nDrive;

	if(m_bScanDone)
		return 0;

	CThemeSet *pThemeClass = ((CEnbanKensaApp *)AfxGetApp())->GetThemeClass();
	CThemeMessageDlg MsgDlg;
	MsgDlg.SetTheme(pThemeClass);

	if(cb->GetCount()==0){
		drives = ScanDrive(FALSE);
		if(drives==NULL){
			csMessage.LoadString(IDS_DRIVENOTFOUND);
			MsgDlg.Disp(csMessage, NULL, MB_ICONERROR);
			return 0;
		}
		for(nDrive=0; strlen((LPCTSTR)drives[nDrive].inqdata)!=0; nDrive++){
			cb->AddString((LPCTSTR)drives[nDrive].inqdata);
		}
		if(m_pDrives!=NULL)
			free(m_pDrives);
		m_pDrives = drives;
		cb->SetCurSel(0);
	}

	m_bScanDone = TRUE;
	return 0;
}


BOOL CEnbanKensaDlg::DestroyWindow() 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	CloseAspi();
	if(m_pDrives != NULL){
		free(m_pDrives);
		m_pDrives = NULL;
	}
	DestroyDrawable();
	return CDialog::DestroyWindow();
}

LRESULT CEnbanKensaDlg::OnUICtl(WPARAM wParam, LPARAM lParam)
{
	LPCTSTR lpMessage;

	switch(wParam){
	case UICTL_DISPINFO:
		if(lParam==NULL){
			lpMessage = "";
		}
		else{
			lpMessage = (LPCTSTR)lParam;
		}
		m_StcInfo.SetWindowText(lpMessage);
		break;
	case UICTL_DRAWLINE:
		DrawLine((DRAWLINE_t *)lParam);
		break;
	case UICTL_DRAWBOX:
		DrawBox((DRAWBOX_t *)lParam);
		break;
	case UICTL_DRAWTEXT:
		DrawText((DRAWTEXT_t *)lParam);
		break;
	case UICTL_GETDRAWABLESIZE:
		GetDrawableSize((DRAWABLESIZE_t *)lParam);
		break;
	case UICTL_SETTING:
		return Setting((OPTIONS *)lParam);
	}

	return 0;
}

void CEnbanKensaDlg::CreateDrawable(int width, int height)
{
	DRAWBOX_t db;
	CWindowDC dc(this);

	DestroyDrawable();
	m_Drawable.hDC = ::CreateCompatibleDC(dc.m_hDC);
	m_Drawable.hBitmap = ::CreateCompatibleBitmap(dc.m_hDC, width, height);
	m_Drawable.hBitmapOld = (HBITMAP)::SelectObject(m_Drawable.hDC, m_Drawable.hBitmap);
	m_Drawable.width = width;
	m_Drawable.height = height;
	m_Drawable.hFont = CreateFont(16, 8, 0, 0, 400, FALSE, FALSE, FALSE, DEFAULT_CHARSET,
						OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY,
						FIXED_PITCH|FF_DONTCARE, "lr SVbN");
	m_Drawable.hFontOld = (HFONT)::SelectObject(m_Drawable.hDC, m_Drawable.hFont);
	::SetBkMode(m_Drawable.hDC, TRANSPARENT);
	db.x0 = 0;
	db.y0 = 0;
	db.x1 = width-1;
	db.y1 = height-1;
	db.color = RGB(0,0,0);
	db.fill = TRUE;
	DrawBox(&db);
}


void CEnbanKensaDlg::DestroyDrawable()
{
	if(m_Drawable.hDC != NULL){
		if(m_Drawable.hBitmap != NULL){
			::SelectObject(m_Drawable.hDC, m_Drawable.hBitmapOld);
			::DeleteObject(m_Drawable.hBitmap);
			m_Drawable.hBitmap = NULL;
		}
		if(m_Drawable.hFont != NULL){
			::SelectObject(m_Drawable.hDC, m_Drawable.hFontOld);
			::DeleteObject(m_Drawable.hFont);
			m_Drawable.hFont = NULL;
		}
		::DeleteDC(m_Drawable.hDC);
		m_Drawable.hDC = NULL;
	}
}


void CEnbanKensaDlg::DrawLine(DRAWLINE_t *param)
{
	HPEN hPen, hPenOld;
	hPen = ::CreatePen(PS_SOLID, 1, param->color);
	hPenOld = (HPEN)::SelectObject(m_Drawable.hDC, hPen);

	::MoveToEx(m_Drawable.hDC, param->x0, param->y0, NULL);
	::LineTo(m_Drawable.hDC, param->x1, param->y1);
	::SetPixel(m_Drawable.hDC, param->x1, param->y1, param->color);

	::SelectObject(m_Drawable.hDC, hPenOld);
	::DeleteObject(hPen);

//	m_StcDrawArea.Invalidate();
	RECT rect;
	if(param->x0 < param->x1){
		rect.left = param->x0;
		rect.right = param->x1;
	}
	else{
		rect.left = param->x1;
		rect.right = param->x0;
	}
	if(param->y0 < param->y1){
		rect.top = param->y0;
		rect.bottom = param->y1;
	}
	else{
		rect.top = param->y1;
		rect.bottom = param->y0;
	}
	rect.right++;
	rect.bottom++;
	::InvalidateRect(m_StcDrawArea.m_hWnd, &rect, FALSE);
}

void CEnbanKensaDlg::DrawBox(DRAWBOX_t *param)
{
	HBRUSH hBrush;
	RECT rect;
	hBrush = ::CreateSolidBrush(param->color);
	if(param->x0 < param->x1){
		rect.left = param->x0;
		rect.right = param->x1;
	}
	else{
		rect.left = param->x1;
		rect.right = param->x0;
	}
	if(param->y0 < param->y1){
		rect.top = param->y0;
		rect.bottom = param->y1;
	}
	else{
		rect.top = param->y1;
		rect.bottom = param->y0;
	}
	rect.right++;
	rect.bottom++;

	::FillRect(m_Drawable.hDC, &rect, hBrush);

	::DeleteObject(hBrush);

	::InvalidateRect(m_StcDrawArea.m_hWnd, &rect, FALSE);
}

void CEnbanKensaDlg::DrawText(DRAWTEXT_t *param)
{
	RECT rect;
	SIZE size;
	::SetTextColor(m_Drawable.hDC, param->color);
	::TextOut(m_Drawable.hDC, param->x0, param->y0, param->text, strlen(param->text));
	::GetTextExtentPoint32(m_Drawable.hDC, param->text, strlen(param->text), &size);
	rect.left = param->x0;
	rect.top = param->y0;
	rect.right = rect.left+size.cx;
	rect.bottom = rect.top+size.cy;
	::InvalidateRect(m_StcDrawArea.m_hWnd, &rect, FALSE);
}

void CEnbanKensaDlg::GetDrawableSize(DRAWABLESIZE_t *param)
{
	param->width = m_Drawable.width;
	param->height = m_Drawable.height;
}


void CEnbanKensaDlg::DrawLogo(CDC *pDC)
{
	RECT rcLogo;
	SIZE szLogo;
	THEME_BITMAP tb;
	CGraphicUtil GUtil;

	tb.bitmap = &m_bmpLogo;
	tb.mask = &m_bmpLogoMask;
	tb.border_height = 0;
	tb.border_height = 0;
	tb.flags = TBF_TILE;

	szLogo = GUtil.GetBitmapSize(&m_bmpLogo);

	GetDlgItem(IDC_STC_TITLELOGO)->GetWindowRect(&rcLogo);
	ScreenToClient(&rcLogo);

	rcLogo.right = rcLogo.left + szLogo.cx;
	rcLogo.bottom = rcLogo.top + szLogo.cy;
	GUtil.DrawThemeBitmap(this, pDC, &tb, &rcLogo);
}

int CEnbanKensaDlg::Setting(OPTIONS *pOption)
{
	CSettingDlg dlg;
	int ret;

	dlg.SetTheme(GetTheme());
	dlg.SetData(pOption);
	ret = dlg.DoModal();
	return ret==IDOK ? RET_OK : RET_ABORT;
}

