// EnbanKensaDlg.h : wb_[ t@C
//

#if !defined(AFX_YAKEGUAIDLG_H__28617C93_A81E_446B_8EC9_948885394AB0__INCLUDED_)
#define AFX_YAKEGUAIDLG_H__28617C93_A81E_446B_8EC9_948885394AB0__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <afxpriv.h>	// for WM_KICKIDLE
#include <ThemeButton.h>
#include <ThemeComboBox.h>
#include <ThemeLabel.h>
#include <ThemeDialog.h>
#include <GraphicDraw.h>
#include <scan.h>
#include <option.h>

typedef struct {
	int x0, y0, x1, y1;
	COLORREF color;
} DRAWLINE_t;

typedef struct {
	int x0, y0, x1, y1;
	COLORREF color;
	BOOL fill;
} DRAWBOX_t;

typedef struct {
	int x0, y0;
	COLORREF color;
	const char *text;
} DRAWTEXT_t;

typedef struct {
	int width;
	int height;
} DRAWABLESIZE_t;

/////////////////////////////////////////////////////////////////////////////
// CEnbanKensaDlg _CAO

class CEnbanKensaDlg : public CThemeDialog
{
// \z
public:
	CEnbanKensaDlg(CWnd* pParent = NULL);	// W̃RXgN^

// _CAO f[^
	//{{AFX_DATA(CEnbanKensaDlg)
	enum { IDD = IDD_ENBANKENSA_DIALOG };
	CThemeLabel	m_StcInfo;
	CGraphicDraw	m_StcDrawArea;
	CThemeButton	m_BtnOK;
	CThemeLabel	m_StcDrive;
	CThemeComboBox	m_CmbDrive;
	//}}AFX_DATA

	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B
	//{{AFX_VIRTUAL(CEnbanKensaDlg)
	public:
	virtual BOOL DestroyWindow();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV ̃T|[g
	//}}AFX_VIRTUAL

// Cve[V
protected:
	HICON m_hIcon;

	// ꂽbZ[W }bv֐
	//{{AFX_MSG(CEnbanKensaDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	virtual void OnOK();
	virtual void OnCancel();
	//}}AFX_MSG
	afx_msg LRESULT OnKickIdle(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnUICtl(WPARAM wParam, LPARAM lParam);
	DECLARE_MESSAGE_MAP()

public:
	HDC GetDrawableDC(){ return m_Drawable.hDC; };

private:
	void LoadIniFile();
	void SaveIniFile();
	void GetRegString(const char *key, char *string_ret, DWORD size);
	void WriteRegString(const char *key, const char *string);
	void LoadTheme();
	void CreateDrawable(int width, int height);
	void DestroyDrawable();
	void DrawLine(DRAWLINE_t *param);
	void DrawBox(DRAWBOX_t *param);
	void DrawText(DRAWTEXT_t *param);
	void GetDrawableSize(DRAWABLESIZE_t *param);
	void DrawLogo(CDC *pDC);
	int Setting(OPTIONS *pOption);

private:
	int m_nThemeNumber;
	BOOL m_bScanDone;
	SCAN_t *m_pDrives;
	int m_nDrawableWidth;
	int m_nDrawableHeight;
	struct _DRAWABLE {
		HDC hDC;
		HBITMAP hBitmap;
		HBITMAP hBitmapOld;
		HFONT hFont;
		HFONT hFontOld;
		int width;
		int height;
	} m_Drawable;
	BOOL m_bRunning;
	CBitmap m_bmpLogo;
	CBitmap m_bmpLogoMask;
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_YAKEGUAIDLG_H__28617C93_A81E_446B_8EC9_948885394AB0__INCLUDED_)
