/**
 * @file log.c
 * @brief O֌W
 * @author BananaJinn
 * @version $Id: log.c,v 1.2 2006/06/02 16:48:49 bananajinn Exp $
 * ~Օʉ
 * Copyright (C) 2004-2006 BananaJinn<banana@mxh.mesh.ne.jp>.
 */

#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#if defined(WIN32)
# include <io.h>
#else
# include <pwd.h>
# include <unistd.h>
#endif
#ifdef linux
# include <fcntl.h>
#endif
#include <time.h>
#include "aspi.h"

#if defined(WIN32)
# define vsnprintf _vsnprintf
#endif



void DebugLog(char *fmt, ...)
{
#ifdef DEBUGLOG
  va_list args;
  char str[512];
  FILE *fp;
  time_t now;
  static char path[_MAX_PATH]="";
#if defined(WIN32)
  char *fname = "\\enban-debug.log";
#else
  char *fname = "/enban-debug.log";
  struct passwd *pwent;
#endif

  if(strlen(path)==0){
#if defined(WIN32)
    GetCurrentDirectory(sizeof(path), path);
#else
    pwent = getpwuid(getuid());
    strncpy(path, pwent->pw_dir, sizeof(path));
    path[sizeof(path)-1] = '\0';
#endif
    if(strlen(path)+strlen(fname)+1 >= _MAX_PATH){
      return;
    }
    strcat(path, fname);
  }
  
  fp = fopen(path, "a");
  if(fp == NULL)
    return;
  
  time(&now);
  strftime(str, sizeof(str)-1, "%Y/%m/%d %H:%M:%S : ", localtime(&now));
  fputs(str, fp);
  
  va_start(args, fmt);
  vsnprintf(str, sizeof(str), fmt, args);
  
  fputs(str, fp);
  fclose(fp);
#endif
}
