/**
 * @file netserver.c
 * @brief T[o
 * @author BananaJinn
 * @version $Id: netserver.c,v 1.6 2006/03/21 14:06:22 bananajinn Exp $
 * ~Օʉ
 * Copyright (C) 2004-2006 BananaJinn<banana@mxh.mesh.ne.jp>.
 */
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#ifdef linux
# include <fcntl.h>
#endif
#include <time.h>
#if defined(WIN32)
# include <io.h>
#endif
#if !defined(MACOSX)
# include <malloc.h>
#endif
#include "aspi.h"
#include "struct.h"
#include "cmd.h"
#include "ui.h"
#include "copydisc.h"
#include "cmdlog.h"
#include "text.h"

static int ReceiveNetCmd(CMDDRIVE *netdrive, CMDDRIVE *realdrive,
						 BOOL enable_longread);

/**
 * @brief	[gvɂR}hs
 * @param[in]	netdrive	lbg[NhCu([ghCu)
 * @param[in]	realdrive	hCu([JhCu)
 * @retval	RET_OK	I
 * @retval	RET_TIMEOUT	^CAEg
 * @retval	RET_SOCKET	\PbgG[
 * @retval	RET_NG	G[
 */
static int ExecuteCommand(CMDDRIVE *netdrive, CMDDRIVE *realdrive)
{
  int ret;
  DWORD length;
  NETCMDHEADER cmdheader;
  BYTE netdata_common[8];

  memset(netdata_common, 0, sizeof(netdata_common));
  
	  /* R}hM */
  ret = NAReceive(&netdrive->u.net, (char *)&cmdheader, sizeof(cmdheader),
				  NETTIMEOUT);
  if(ret != RET_OK){
	return ret;
  }
  length = Get4bytes(cmdheader.data_length);
  if(length > (DWORD)netdrive->bufsize){
	length = (DWORD)netdrive->bufsize;
  }
  
  if((length > 0) && (cmdheader.reqflag==REQ_DATAOUT)){
		/* R}hf[^M */
	ret = NAReceive(&netdrive->u.net, (char *)netdrive->data_buf,
					(int)length, NETTIMEOUT);
	if(ret != RET_OK){
	  return ret;
	}
  }
  ret = SendCmd(realdrive, cmdheader.cdb, length, cmdheader.reqflag);
	  /* G[ĂAG[͕ԋp */
	  /* f[^ԑ */
  if(cmdheader.reqflag == REQ_DATAIN){
	Set4bytes(netdata_common, length+sizeof(NETCMDHEADER));
  }
  else{
	Set4bytes(netdata_common, sizeof(NETCMDHEADER));
  }
  netdata_common[4] = NETDATATYPE_RESPONSE;
  ret = NASend(&netdrive->u.net, (char *)netdata_common, 8,
			   NETTIMEOUT, FALSE);
  if(ret != RET_OK){
	return ret;
  }
  memcpy(cmdheader.sense_data, realdrive->sense_data,
		 sizeof(cmdheader.sense_data));
  ret = NASend(&netdrive->u.net, (char *)&cmdheader, sizeof(cmdheader),
			   NETTIMEOUT, FALSE);
  if(ret != RET_OK){
	return ret;
  }
  if(cmdheader.reqflag == REQ_DATAIN){
	ret = NASend(&netdrive->u.net, (char *)netdrive->data_buf, length,
				 NETTIMEOUT, FALSE);
	if(ret != RET_OK){
	  return ret;
	}
  }

  return RET_OK;
}



/**
 * @brief	[gvɂAREADs
 * @param[in]	netdrive	lbg[NhCu([ghCu)
 * @param[in]	realdrive	hCu([JhCu)
 * @param[in]	org_header	󂯂ṽR}hwb_[
 * @retval	RET_OK	I
 * @retval	RET_TIMEOUT	^CAEg
 * @retval	RET_SOCKET	\PbgG[
 * @retval	RET_NG	G[
 */
static int ExecuteLongRead(CMDDRIVE *netdrive, CMDDRIVE *realdrive)
{
  DWORD lba, start_lba;
  DWORD length, total_length;
  DWORD blocksize;
  int ret;
  BYTE netdata_common[8];
  NETCMDHEADER org_header, header;
  BYTE work4[4];

	  /* R}hM */
  ret = NAReceive(&netdrive->u.net, (char *)&org_header, sizeof(org_header),
				  NETTIMEOUT);
  if(ret != RET_OK){
	return ret;
  }
	  /* vubNM */
  ret = NAReceive(&netdrive->u.net, (char *)work4, sizeof(work4),
				  NETTIMEOUT);
  if(ret != RET_OK){
	return ret;
  }
  total_length = Get4bytes(work4);
  start_lba = Get4bytes(org_header.cdb+2);
  
  memcpy(header.cdb, org_header.cdb, 12);
  lba = start_lba;
  if(header.cdb[0]==CMD_READ12){
	length = Get4bytes(header.cdb+6);
	blocksize = 2048;
  }
  else if(header.cdb[0]==CMD_READ_CD){
	length = Get3bytes(header.cdb+6);
	blocksize = 2352;
  }
  else{
	return RET_NG;
  }

  while(total_length > 0){
	if(UICheckAbort()){
	  return RET_ABORT;
	}
	if(length > total_length){
	  length = total_length;
	  if(header.cdb[0]==CMD_READ12){
		Set4bytes(header.cdb+2, lba);
		Set4bytes(header.cdb+6, length);
	  }
	  else /* CMD_READ_CD */{
		Set4bytes(header.cdb+2, lba);
		Set3bytes(header.cdb+6, length);
	  }
	}
		/* hCuREAD */
	Set4bytes(header.cdb+2, lba);
	ret = SendCmd(realdrive, header.cdb, length*blocksize, REQ_DATAIN);
	if(ret != RET_OK){
	  return ret;
	}
	memcpy(header.sense_data, realdrive->sense_data,
		   sizeof(header.sense_data));

		/* READf[^ԑ */
	Set4bytes(netdata_common, length*blocksize+sizeof(header));
	netdata_common[4] = NETDATATYPE_RESPONSE;
	while(1){
	  ret = NASend(&netdrive->u.net, (char *)netdata_common, 8,
				   NETTIMEOUT, TRUE);
	  if(ret==RET_OK){
		break;
	  }
	  if(ret!=RET_READFD){
		return ret;
	  }
	  ret = ReceiveNetCmd(netdrive, realdrive, FALSE);
	  if(ret != RET_OK){
		return ret;
	  }
	}
	ret = NASend(&netdrive->u.net, (char *)&header, sizeof(header),
				 NETTIMEOUT, FALSE);
	if(ret != RET_OK){
	  return ret;
	}
	ret = NASend(&netdrive->u.net, (char *)netdrive->data_buf,
				 length*blocksize, NETTIMEOUT, FALSE);
	if(ret != RET_OK){
	  return ret;
	}

	lba += length;
	total_length -= length;
  }

  return RET_OK;
}

/**
 * @brief	[gvɂ郁bZ[W\
 * @param[in]	netdrive	lbg[NhCu([ghCu)
 * @param[in]	receive_bytes	󂯂ṽoCg
 * @retval	RET_OK	I
 * @retval	RET_TIMEOUT	^CAEg
 * @retval	RET_NG	G[
 * @retval	RET_MEMERR	s
 */
static int DisplayMessage(CMDDRIVE *netdrive, DWORD receive_bytes)
{
  NETDISPHEADER dispheader;
  int ret;
  char *message=NULL;
  DWORD message_len, ignore_len=0;
  
  ret = NAReceive(&netdrive->u.net, (char *)&dispheader, sizeof(dispheader),
				  NETTIMEOUT);
  if(ret != RET_OK){
	return ret;
  }
  if(receive_bytes > (DWORD)sizeof(dispheader)){
	message_len = receive_bytes-sizeof(dispheader);
		/* ő255Ƃ */
	if(message_len > 255){
	  ignore_len = message_len-255;
	  message_len = 255;
	}
	message = (char *)malloc(message_len+1);
	if(message==NULL){
	  UIDispMessage(MSG_MEM_ALLOC_ERROR
			/*"mۂɎs܂B"*/, UIDMT_ERROR);
	  return RET_MEMERR;
	}
	/* bZ[WM */
	ret = NAReceive(&netdrive->u.net, message, message_len, NETTIMEOUT);
	if(ret != RET_OK){
	  free(message);
	  return ret;
	}
	ret = NAReceive(&netdrive->u.net, NULL, ignore_len, NETTIMEOUT);
	if(ret != RET_OK){
	  free(message);
	  return ret;
	}
	message[message_len] = '\0';
#if defined(linux)
	{
	  char *message_euc = ConvertCharset(netdrive->u.net.iconv_desc,
										 message);
	  if(message_euc == NULL){
	    free(message);
	    UIDispMessage(MSG_CODE_CONV_ERROR
			  /*"R[hϊɎs܂B"*/, UIDMT_ERROR);
	    return RET_MEMERR;
	  }
	  free(message);
	  message = message_euc;
	}
#endif
  }
  switch(dispheader.area){
  case 0:	/* ʉbZ[W */
    UIDispInfo(message);
    break;
  case 1:	/* vOXo[1 */
	if(message!=NULL)
	  UIMeter1Initialize(message);
	else
	  UIMeter1Update((float)dispheader.percent);
	break;
  case 2:	/* vOXo[2 */
	if(message!=NULL)
	  UIMeter2Initialize(message);
	else
	  UIMeter2Update((float)dispheader.percent);
	break;
  }
  free(message);
  
  return RET_OK;
}


/**
 * @brief	[gv
 * @param[in]	netdrive	lbg[NhCu([ghCu)
 * @param[in]	realdrive	hCu([JhCu)
 * @param[in]	enable_longread	AREAD
 * @retval	RET_OK	I
 * @retval	RET_TIMEOUT	^CAEg
 * @retval	RET_ABORT	f
 * @retval	RET_COMPLETE	
 * @retval	RET_SOCKET	\PbgG[
 * @retval	RET_NG	G[
 */
static int ReceiveNetCmd(CMDDRIVE *netdrive, CMDDRIVE *realdrive,
						 BOOL enable_longread)
{
  int ret;
  BYTE netdata_common[8];
  DWORD receive_bytes;
  
  /* ʕ(f[^ƃf[^^Cv)M */
  ret = NAReceive(&netdrive->u.net, (char *)netdata_common, 8, 1000);
  if(ret != RET_OK){
    return ret;
  }

  receive_bytes = Get4bytes(netdata_common);

  switch(netdata_common[4]){
  case NETDATATYPE_COMMAND:
    ret = ExecuteCommand(netdrive, realdrive);
    if(ret != RET_OK){
      return ret;
    }
    break;
    
  case NETDATATYPE_RESPONSE:
    /* 蓾Ȃ */
    break;
	
  case NETDATATYPE_LONGREAD:
    if(enable_longread){
      ret = ExecuteLongRead(netdrive, realdrive);
      if(ret != RET_OK){
	return ret;
      }
    }
    else{
      UIDispMessage(MSG_UNKNOWN_COMMAND
		    /*"sȃR}hM܂B"*/, UIDMT_ERROR);
      return RET_NG;
    }
    break;
	
  case NETDATATYPE_DISPLAY:
    ret = DisplayMessage(netdrive, receive_bytes);
    if(ret != RET_OK){
      return ret;
    }
    break;
	
  case NETDATATYPE_ABORT:
    return RET_ABORT;
    
  case NETDATATYPE_COMPLETE:
    return RET_COMPLETE;

  default:
    /* sȃR}h */
    UIDispMessage(MSG_UNKNOWN_COMMAND
		  /*"sȃR}hM܂B"*/, UIDMT_ERROR);
    return RET_NG;
  }
  return RET_OK;
}


/**
 * @brief	[gvt
 * @param[in]	netdrive	lbg[NhCu([ghCu)
 * @param[in]	realdrive	hCu([JhCu)
 * @retval	RET_OK	I
 * @retval	RET_ABORT	f
 * @retval	RET_COMPLETE	
 * @retval	RET_SOCKET	\PbgG[
 * @retval	RET_MEMERR	s
 * @retval	RET_NG	G[
 */
int WaitingNetCmd(CMDDRIVE *netdrive, CMDDRIVE *realdrive)
{
  BOOL done=FALSE;
  int ret;
  
  while(!done){
    if(UICheckAbort()){
      return RET_ABORT;
    }
    ret = ReceiveNetCmd(netdrive, realdrive, TRUE);
    if(ret == RET_COMPLETE){
      done=TRUE;
    }
    else if((ret != RET_OK) && (ret != RET_TIMEOUT)){
      return ret;
    }
  }
  
  return RET_OK;
}

