/*
 * @file text.c
 * @brief ϊ
 * @author BananaJinn
 * @version $Id: text.c,v 1.5 2006/05/14 16:12:37 bananajinn Exp $
 * ~Օʉ
 * Copyright (C) 2004-2006 BananaJinn<banana@mxh.mesh.ne.jp>.
 */

#if defined(linux)
# include <stdio.h>
# include <libintl.h>
#elif defined(WIN32)
# include <windows.h>
static char stringBuffer[1024];
#elif defined(MACOSX)
# import <cocoa/cocoa.h>
#endif

#if defined(linux)
char *GetText(const char *string)
{
  return gettext(string);
}
#endif

#if defined(WIN32)
char *GetText(int string_id)
{
  stringBuffer[0] = '\0';
  LoadString(NULL, string_id, stringBuffer, sizeof(stringBuffer));
  return stringBuffer;
}
#endif

#if defined(MACOSX)
const char *GetText(const char *string)
{
	NSString *nsString = [NSString stringWithCString: string];
	return [NSLocalizedString(nsString, @"") cString];
}
#endif

