#!/bin/bash
RPMTOP=/usr/src/redhat
PROG=EnbanFukusyaYa
TMPDIR=/tmp/$PROG
SPECFILE=../${PROG}-fc4.spec

SOURCE=`grep ^Source: $SPECFILE`
SOURCEFILE=${SOURCE##*:\ }
VERSION=`grep ^Version: $SPECFILE`
VERNUM=${VERSION##*:\ }
PROGDIR=$PROG"-"$VERNUM

rm -rf $TMPDIR
mkdir $TMPDIR
cp -pr ../../../$PROG $TMPDIR/$PROGDIR
find $TMPDIR/$PROG"-"$VERNUM -type d -name CVS -exec rm -rf {} \; \
	> /dev/null 2>&1
pushd $TMPDIR > /dev/null
tar zcf $SOURCEFILE $PROGDIR
rm -rf $PROGDIR
popd > /dev/null

cp $SPECFILE $RPMTOP/SPECS/
mv $TMPDIR/$SOURCEFILE $RPMTOP/SOURCES/

rpmbuild -ba $RPMTOP/SPECS/$PROG-fc4.spec
