/* ʣ̲
 * Copyright (c) 2004 Kagetani Hideto
 */
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "option.h"
#include "settingdlg.h"
#include "common.h"
#include "ok.xpm"
#include "ng.xpm"
#include "text.h"

static BOOL g_Done = FALSE;
static int g_RetCode = RET_OK;
static GtkWidget *g_OptMenuReadSpeed = NULL;
static GtkWidget *g_OptMenuWriteSpeed = NULL;
static GtkWidget *g_CheckTestWrite = NULL;
static GtkWidget *g_CheckBUFE = NULL;
static GtkWidget *g_CheckOnthefly = NULL;
static GtkWidget *g_CheckDAO = NULL;
static GtkWidget *g_TempPath = NULL;

static void
on_ok_clicked(GtkWidget *widget, gpointer user_data)
{
  g_RetCode = RET_OK;
  g_Done = TRUE;
}

static void
on_cancel_clicked(GtkWidget *widget, gpointer user_data)
{
  if(g_RetCode<0){
	g_RetCode = RET_ABORT;
	g_Done = TRUE;
  }
}

static void
set_speed_items(GtkWidget *optmenu, gint16 default_speed, BOOL dvd,
		BYTE *speeds, int num_speeds)
{
  gint16 i, defsel;
  GtkWidget *menu;
  GtkWidget *menuitem;
  char buf[32];

  gtk_option_menu_remove_menu(GTK_OPTION_MENU(optmenu));
  menu = gtk_menu_new();

  defsel = 0;
  menuitem = gtk_menu_item_new_with_label(dvd ?
					  GT("Normal Speed"):GT("Max Speed"));
  gtk_object_set_user_data(GTK_OBJECT(menuitem), GINT_TO_POINTER(0));
  gtk_menu_append(GTK_MENU(menu), menuitem);
  gtk_widget_show(menuitem);

  for(i=0; i<(gint16)num_speeds; i++){
    snprintf(buf, sizeof(buf), "%d", speeds[i]);
    strncpy(buf+strlen(buf), GT("x"), sizeof(buf)-strlen(buf));
    buf[sizeof(buf)-1]='\0';
    menuitem = gtk_menu_item_new_with_label(buf);
    gtk_object_set_user_data(GTK_OBJECT(menuitem),
			     GINT_TO_POINTER((int)speeds[i]));
    gtk_menu_append(GTK_MENU(menu), menuitem);
    gtk_widget_show(menuitem);
    if((gint16)speeds[i]==default_speed){
      defsel = i+1;
    }
  }
  gtk_menu_set_active(GTK_MENU(menu), defsel);
  gtk_option_menu_set_menu(GTK_OPTION_MENU(optmenu), menu);
}

static void
set_options(OPTIONS *option)
{
  set_speed_items(g_OptMenuReadSpeed, option->read_speed,
		  option->flags & OPFLG_DVD,
		  option->readable_speed, option->num_readable_speed);
  set_speed_items(g_OptMenuWriteSpeed, option->write_speed,
		  option->flags & OPFLG_DVD,
		  option->writable_speed, option->num_writable_speed);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(g_CheckTestWrite),
			       option->test_write);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(g_CheckBUFE),
			       option->bufe);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(g_CheckOnthefly),
			       option->on_the_fly);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(g_CheckDAO),
			       option->dao);

  gtk_widget_set_sensitive(g_CheckTestWrite,
			   (option->flags & OPFLG_TESTWRITE)!=0);
  gtk_widget_set_sensitive(g_CheckBUFE,
			   (option->flags & OPFLG_BUFE)!=0);
  gtk_widget_set_sensitive(g_CheckOnthefly,
			   (option->flags & OPFLG_ONTHEFLY)!=0);
  gtk_widget_set_sensitive(g_CheckDAO,
			   (option->flags & OPFLG_DAO)!=0);

  gtk_entry_set_text (GTK_ENTRY (g_TempPath), option->temppath);
  gtk_widget_set_sensitive(g_TempPath,
			   (option->flags & OPFLG_TEMPPATH)!=0);
}

static void
get_options(OPTIONS *option)
{
  GtkWidget *menu;
  GtkWidget *menuitem;

  menu = gtk_option_menu_get_menu(GTK_OPTION_MENU(g_OptMenuReadSpeed));
  menuitem = gtk_menu_get_active(GTK_MENU(menu));
  option->read_speed = GPOINTER_TO_INT(gtk_object_get_user_data(GTK_OBJECT(menuitem)));

  menu = gtk_option_menu_get_menu(GTK_OPTION_MENU(g_OptMenuWriteSpeed));
  menuitem = gtk_menu_get_active(GTK_MENU(menu));
  option->write_speed = GPOINTER_TO_INT(gtk_object_get_user_data(GTK_OBJECT(menuitem)));
  
  option->test_write = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(g_CheckTestWrite));
  option->bufe = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(g_CheckBUFE));
  option->on_the_fly = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(g_CheckOnthefly));
  option->dao = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(g_CheckDAO));

  strncpy(option->temppath, gtk_entry_get_text(GTK_ENTRY(g_TempPath)), _MAX_PATH);
  option->temppath[_MAX_PATH-1] = '\0';
}

static GtkWidget*
create_setting_dialog (void)
{
  GtkWidget *setting_dlg;
  GtkWidget *dialog_vbox1;
  GtkWidget *table1;
  GtkWidget *label_readspeed;
  GtkWidget *label_writespeed;
  GtkWidget *label_temppath;
  GtkWidget *optmenu_readspeed;
  GtkWidget *optmenu_readspeed_menu;
  GtkWidget *optmenu_writespeed;
  GtkWidget *optmenu_writespeed_menu;
  GtkWidget *check_testwrite;
  GtkWidget *check_bufe;
  GtkWidget *check_onthefly;
  GtkWidget *check_dao;
  GtkWidget *dialog_action_area1;
  GtkWidget *hbox1;
  GtkWidget *button_ok;
  GtkWidget *button_cancel;
  GtkWidget *entry_temppath;

  setting_dlg = gtk_dialog_new ();
  gtk_object_set_data (GTK_OBJECT (setting_dlg), "setting_dlg", setting_dlg);
  gtk_window_set_title (GTK_WINDOW (setting_dlg), GT("Setting")/*"ʣ"*/);
  /*GTK_WINDOW (setting_dlg)->type = GTK_WINDOW_DIALOG;*/
  gtk_window_set_position (GTK_WINDOW (setting_dlg), GTK_WIN_POS_CENTER);
  gtk_window_set_modal (GTK_WINDOW (setting_dlg), TRUE);
  gtk_window_set_policy (GTK_WINDOW (setting_dlg), FALSE, FALSE, FALSE);

  dialog_vbox1 = GTK_DIALOG (setting_dlg)->vbox;
  gtk_object_set_data (GTK_OBJECT (setting_dlg), "dialog_vbox1", dialog_vbox1);
  gtk_widget_show (dialog_vbox1);

  table1 = gtk_table_new (7, 2, FALSE);
  gtk_widget_ref (table1);
  gtk_object_set_data_full (GTK_OBJECT (setting_dlg), "table1", table1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), table1, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (table1), 10);
  gtk_table_set_row_spacings (GTK_TABLE (table1), 5);
  gtk_table_set_col_spacings (GTK_TABLE (table1), 5);

  label_readspeed = gtk_label_new (GT("Read speed")/*"ɼ®"*/);
  gtk_widget_ref (label_readspeed);
  gtk_object_set_data_full (GTK_OBJECT (setting_dlg), "label_readspeed",
			    label_readspeed,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_readspeed);
  gtk_table_attach (GTK_TABLE (table1), label_readspeed, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_readspeed), 0, 0.5);

  label_writespeed = gtk_label_new (GT("Write speed")/*"Ͽ®"*/);
  gtk_widget_ref (label_writespeed);
  gtk_object_set_data_full (GTK_OBJECT (setting_dlg), "label_writespeed",
			    label_writespeed,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_writespeed);
  gtk_table_attach (GTK_TABLE (table1), label_writespeed, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_writespeed), 0, 0.5);

  optmenu_readspeed = gtk_option_menu_new ();
  gtk_widget_ref (optmenu_readspeed);
  gtk_object_set_data_full (GTK_OBJECT (setting_dlg), "optmenu_readspeed",
			    optmenu_readspeed,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (optmenu_readspeed);
  gtk_table_attach (GTK_TABLE (table1), optmenu_readspeed, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  optmenu_readspeed_menu = gtk_menu_new ();
  gtk_option_menu_set_menu (GTK_OPTION_MENU (optmenu_readspeed),
			    optmenu_readspeed_menu);

  optmenu_writespeed = gtk_option_menu_new ();
  gtk_widget_ref (optmenu_writespeed);
  gtk_object_set_data_full (GTK_OBJECT (setting_dlg), "optmenu_writespeed",
			    optmenu_writespeed,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (optmenu_writespeed);
  gtk_table_attach (GTK_TABLE (table1), optmenu_writespeed, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  optmenu_writespeed_menu = gtk_menu_new ();
  gtk_option_menu_set_menu (GTK_OPTION_MENU (optmenu_writespeed),
			    optmenu_writespeed_menu);

  check_testwrite = gtk_check_button_new_with_label (GT("Test write")
						     /*"Ͽ(TestWrite)"*/);
  gtk_widget_ref (check_testwrite);
  gtk_object_set_data_full (GTK_OBJECT (setting_dlg), "check_testwrite",
			    check_testwrite,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (check_testwrite);
  gtk_table_attach (GTK_TABLE (table1), check_testwrite, 0, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  check_bufe = gtk_check_button_new_with_label (GT("Buffer underrun free enable")
						/*"®­(BufferUnderrunFreeEnable)"*/);
  gtk_widget_ref (check_bufe);
  gtk_object_set_data_full (GTK_OBJECT (setting_dlg), "check_bufe",
			    check_bufe,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (check_bufe);
  gtk_table_attach (GTK_TABLE (table1), check_bufe, 0, 2, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  check_onthefly = gtk_check_button_new_with_label (GT("On the fly")
						    /*"ľŪϿ(on-the-fly)"*/);
  gtk_widget_ref (check_onthefly);
  gtk_object_set_data_full (GTK_OBJECT (setting_dlg), "check_onthefly", check_onthefly,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (check_onthefly);
  gtk_table_attach (GTK_TABLE (table1), check_onthefly, 0, 2, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  check_dao = gtk_check_button_new_with_label (GT("Disc at once")
					       /*"ɮ(Disc-at-once)"*/);
  gtk_widget_ref (check_dao);
  gtk_object_set_data_full (GTK_OBJECT (setting_dlg), "check_dao",
			    check_dao,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (check_dao);
  gtk_table_attach (GTK_TABLE (table1), check_dao, 0, 2, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  label_temppath = gtk_label_new (GT("Temporary directory")
				  /*"ǥ쥯ȥ"*/);
  gtk_widget_ref (label_temppath);
  gtk_object_set_data_full (GTK_OBJECT (setting_dlg), "label_temppath",
			   label_temppath,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_temppath);
  gtk_table_attach (GTK_TABLE(table1), label_temppath, 0, 1, 6, 7,
		    (GtkAttachOptions)(GTK_FILL),
		    (GtkAttachOptions)(0), 0, 0);
  gtk_misc_set_alignment(GTK_MISC(label_temppath), 0, 0.5);

  entry_temppath = gtk_entry_new();
  gtk_widget_ref(entry_temppath);
  gtk_object_set_data_full(GTK_OBJECT(setting_dlg), "entry_temppath",
			   entry_temppath,
			   (GtkDestroyNotify)gtk_widget_unref);
  gtk_widget_show(entry_temppath);
  gtk_table_attach(GTK_TABLE(table1), entry_temppath, 1, 2, 6, 7,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);


  dialog_action_area1 = GTK_DIALOG (setting_dlg)->action_area;
  gtk_object_set_data (GTK_OBJECT (setting_dlg), "dialog_action_area1",
		       dialog_action_area1);
  gtk_widget_show (dialog_action_area1);
  gtk_container_set_border_width (GTK_CONTAINER (dialog_action_area1), 10);

  hbox1 = gtk_hbox_new (FALSE, 10);
  gtk_widget_ref (hbox1);
  gtk_object_set_data_full (GTK_OBJECT (setting_dlg), "hbox1", hbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox1);
  gtk_box_pack_end (GTK_BOX (dialog_action_area1), hbox1, FALSE, FALSE, 0);

  button_ok = xpm_button_new (setting_dlg, ok_xpm, GT("OK")/*""*/);
  gtk_widget_ref (button_ok);
  gtk_object_set_data_full (GTK_OBJECT (setting_dlg), "button_ok",
							button_ok,
                            (GtkDestroyNotify) gtk_widget_unref);
  GTK_WIDGET_SET_FLAGS(button_ok, GTK_CAN_DEFAULT);
  gtk_widget_show (button_ok);
  gtk_box_pack_start (GTK_BOX (hbox1), button_ok, FALSE, FALSE, 0);

  button_cancel = xpm_button_new (setting_dlg, ng_xpm, GT("Cancel")/*""*/);
  gtk_widget_ref (button_cancel);
  gtk_object_set_data_full (GTK_OBJECT (setting_dlg), "button_cancel",
			    button_cancel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_cancel);
  gtk_box_pack_start (GTK_BOX (hbox1), button_cancel, FALSE, FALSE, 0);


  gtk_signal_connect(GTK_OBJECT(button_ok), "clicked",
		     GTK_SIGNAL_FUNC(on_ok_clicked),
		     NULL);
  gtk_signal_connect(GTK_OBJECT(button_cancel), "clicked",
		     GTK_SIGNAL_FUNC(on_cancel_clicked),
		     NULL);
  gtk_signal_connect(GTK_OBJECT(setting_dlg), "destroy",
					 GTK_SIGNAL_FUNC(on_cancel_clicked),
					 NULL);

  gtk_widget_grab_default (button_ok);
  
  g_OptMenuReadSpeed = optmenu_readspeed;
  g_OptMenuWriteSpeed = optmenu_writespeed;
  g_CheckTestWrite = check_testwrite;
  g_CheckBUFE = check_bufe;
  g_CheckOnthefly = check_onthefly;
  g_CheckDAO = check_dao;
  g_TempPath = entry_temppath;

  return setting_dlg;
}

int SettingDlg(OPTIONS *option)
{
  GtkWidget *setting_dialog;

  g_Done = FALSE;
  g_RetCode = -1;

  setting_dialog = create_setting_dialog();
  set_options(option);
  gtk_widget_show(setting_dialog);

  while(!g_Done)
    gtk_main_iteration();

  if(GTK_IS_WIDGET(setting_dialog)){
	get_options(option);
	gtk_widget_destroy(setting_dialog);
  }

  return g_RetCode;
}

