#import "SettingNetControl.h"
#import <drive.h>

@implementation SettingNetControl

- (IBAction)buttonCancel:(id)sender
{
	[NSApp stopModalWithCode: RET_ABORT];
}

- (IBAction)buttonOk:(id)sender
{
	[NSApp stopModalWithCode: RET_OK];
}

- (int)openNetSettingDialog:(BOOL)serverMode
			  remoteAddress:(char *)remoteAddressReturn
				addressSize:(int)size
				 portNumber:(int *)portNumberReturn
{
	int ret;
	
	[serverAddressLabel setEnabled : !serverMode];
	[serverAddress setEnabled : !serverMode];
	[portNumber setIntValue : 11877];
	
	/* _CAO\ */
	ret = [NSApp runModalForWindow : netSettingPanel];
	[netSettingPanel orderOut : self];
	if(ret != RET_OK){
		return ret;
	}
	
	if(!serverMode){
		const char *inputAddress = [[serverAddress stringValue] cString];
		strncpy(remoteAddressReturn, inputAddress, size-1);
		remoteAddressReturn[size-1] = '\0';
	}
	*portNumberReturn = [portNumber intValue];
	return RET_OK;
}

@end
