#ifndef __UI_H__
#define __UI_H__

#include <aspi.h>
#include <option.h>

#undef USE_THREAD
//#define USE_THREAD

#ifdef __cplusplus
extern "C" {
#endif

#define WM_USER_UICTL	(WM_USER+1)
#define UICTL_METER1INIT	0
#define UICTL_METER2INIT	1
#define UICTL_METER1SETPOS	2
#define UICTL_METER2SETPOS	3
#define UICTL_SETTING		4

extern void UISetMWC(void *mwc);
extern BOOL UICheckAbort();
extern void UISetAbort();
extern void UIClearAbort();
extern int UIDispMessage(const char *message, int type);
/* type value */
#define UIDMT_INFORMATION	0
#define UIDMT_ERROR		1
#define UIDMT_QUESTION	2
/* return value */
#define UIDMRET_OK		0
#define UIDMRET_CANCEL	1

extern void UIMeter1Initialize(const char *message);
extern void UIMeter2Initialize(const char *message);
extern void UIMeter1Update(int percentage);
extern void UIMeter2Update(int percentage);
extern void UIDispInfo(const char *message);
extern int UIFileDialog(BOOL bOpen, char *filename, int size, const char *suffix);
extern int UINetDialog(BOOL bServer, char *remote, int size, int *port_number);

extern int UISetting(OPTIONS *option);

#ifdef __cplusplus
}
#endif

#endif /* !__EVENT_H__ */
