/* ~Օʉ
 * Copyright (C) 2004 Kagetani Hideto
 */
#ifndef __WINASPI_H__
#define __WINASPI_H__

#include <windows.h>

#include <scsidefs.h>
#include <srbcmn.h>
#include <srb32.h>

#define USE_SCSIPT	1

typedef struct {
	int hid;
	int tid;
	DWORD timeout;
	SRB32_ExecSCSICmd *srb;
#if USE_SCSIPT
	HANDLE hDrive;
#endif
} DRIVE;

#ifdef __cplusplus
extern "C" {
#endif

extern int OpenAspi(void);
extern void CloseAspi(void);
extern int InitializeDrive(DRIVE *drive);
extern void FreeDrive(DRIVE *drive);
extern int SetAspiSetting(DRIVE *drive, int *ha, int *tg, DWORD *timeout);
extern void GetAspiSetting(DRIVE *drive, int *ha, int *tg, DWORD *timeout);
extern int SendAspiCmd(DRIVE *drive, BYTE *cdb, BYTE *buf, DWORD buflen,
						BYTE *sensedata, DWORD senselen, BYTE reqflag);
extern int GetHostAdapterCount(void);
extern int GetMaxTarget(void);
extern BOOL CheckDiscDevice(DRIVE *drive);
extern BOOL UsingSPTI();


#ifdef __cplusplus
}
#endif


#endif /* !__WINASPI_H__ */
