#!/bin/sh
#
# 5macro_uptex.sh
# modified from ptexlive-20090716/5macro.sh
#

. ./common.sh
root_check

PACKAGE=$TEXMF/packages
PACKAGE2=../../packages
PACKAGE3=../../../packages
MAP=$TEXMF/fonts/map/dvipdfm

## arg check
if test -z "$1"; then
cat <<EOF
usage : $0 {default,utf,otf,clean}
ex.:    $0 default
EOF
exit 1
fi

clean() {
$RM -r $PACKAGE
}

default() {
$MKDIR $PACKAGE

## jsclasses
$MKDIR                     $PACKAGE/jsclasses
tarx macro/jsclasses-*.zip $PACKAGE/jsclasses
lndir $PACKAGE2/jsclasses $TEXMF/ptex/platex jsclasses
nkfutf8n $PACKAGE/jsclasses/*.dtx
nkfutf8n $PACKAGE/jsclasses/*.cls
nkfutf8n $PACKAGE/jsclasses/o*.sty

## tateyoko
#$MKDIR                     $PACKAGE/tateyoko
#tarx macro/tateyoko.tar.gz $PACKAGE/tateyoko
#lndir $PACKAGE2/tateyoko $TEXMF/ptex/platex tateyoko

## tategumi
#$MKDIR                     $PACKAGE/tategumi
#tarx macro/tategumi.tar.gz $PACKAGE/tategumi
#lndir $PACKAGE2/tategumi $TEXMF/ptex/platex tategumi

## burasage
# not yet
}


## UTF
utf() {
enoughspace $TEXMF 12000
tarx macro/utfsrc.zip $PACKAGE
zpatch macro/utfsrc-speedup.patch 0 $PACKAGE
nkfutf8  $PACKAGE/utfsrc/readme.txt
nkfutf8n $PACKAGE/utfsrc/basepl/* $PACKAGE/utfsrc/test/utfsmpl.tex $PACKAGE/utfsrc/sty/ajmacros.sty
chmod -x $PACKAGE/utfsrc/*.txt $PACKAGE/utfsrc/sty/* $PACKAGE/utfsrc/fontmap/* $PACKAGE/utfsrc/basepl/*
chmod +x $PACKAGE/utfsrc/script/*.pl
perlprint 's/pltotf/ppltotf/g' $PACKAGE/utfsrc/makeutf
(cd $PACKAGE/utfsrc || exit; ./makeutf)

lndir $PACKAGE2/utfsrc/sty $TEXMF/ptex/platex      utfsrc
lndir $PACKAGE3/utfsrc/vf  $TEXMF/fonts/vf/public  utfsrc
lndir $PACKAGE3/utfsrc/tfm $TEXMF/fonts/tfm/public utfsrc

cat <<EOF > $MAP/utf-noEmbed.map || exit
% UTF for dvipdfmx

unijmin-h   UniJIS-UTF16-H    !Ryumin-Light
unijmin-v   UniJIS-UTF16-V    !Ryumin-Light
cidmin-h    Identity-H        !Ryumin-Light
cidmin-v    Identity-V        !Ryumin-Light
hmr         H                 !Ryumin-Light
hmrv        V                 !Ryumin-Light

unijgoth-h  UniJIS-UTF16-H    !GothicBBB-Medium
unijgoth-v  UniJIS-UTF16-V    !GothicBBB-Medium
cidgoth-h   Identity-H        !GothicBBB-Medium
cidgoth-v   Identity-V        !GothicBBB-Medium
hkb         H                 !GothicBBB-Medium
hkbv        V                 !GothicBBB-Medium
EOF

perl -pe 's/\!Ryumin-Light/ipam.ttf/g; 
	  s/\!GothicBBB-Medium/ipag.ttf/g;' \
	      < $MAP/utf-noEmbed.map > $MAP/utf-ipa.map
perl -pe 's/\!Ryumin-Light/ipam.otf/g; 
	  s/\!GothicBBB-Medium/ipag.otf/g;' \
	      < $MAP/utf-noEmbed.map > $MAP/utf-ipa-otf.map
perl -pe 's/\!Ryumin-Light/HiraMinPro-W3/g; 
	  s/\!GothicBBB-Medium/HiraKakuPro-W6/g;' \
	      < $MAP/utf-noEmbed.map > $MAP/utf-hiragino.map
perl -pe 's/\!Ryumin-Light/KozMinPro-Regular-Acro.otf/g; 
	  s/\!GothicBBB-Medium/KozGoStd-Regular.otf/g;' \
	      < $MAP/utf-noEmbed.map > $MAP/utf-kozuka.map
perl -pe 's/\!Ryumin-Light/A-OTF-RyuminPro-Light.otf/g; 
	  s/\!GothicBBB-Medium/A-OTF-GothicBBBPro-Medium.otf/g;' \
	      < $MAP/utf-noEmbed.map > $MAP/utf-morisawa.map

$UPDMAP --nomkmap --enable KanjiMap utf-@kanjiEmbed@.map
}

## OTF
otf() {
enoughspace $TEXMF 82000
tarx macro/otfstable.zip $PACKAGE
zpatch macro/otfstable-speedup.patch 0 $PACKAGE
tarx $SRC/../uptex-*/patch/otfstable-uptex-*.tar.gz $PACKAGE
chmod -x $PACKAGE/otfstable/*.txt \
         $PACKAGE/otfstable/sty/* $PACKAGE/otfstable/fontmap/*
chmod +x $PACKAGE/otfstable/script/*.pl
perlprint 's/pltotf/ppltotf/g' $PACKAGE/otfstable/makeotf

(cd $PACKAGE/otfstable/fontmap/ || exit
$MV "ckt.map(for udvips)"         ckt.map       || exit
$MV "cktx.map(for dvipdfmx)"      cktx.map      || exit
$MV "hiragino.map(for udvips)"    hiragino.map  || exit
$MV "hiraginox.map(for dvipdfmx)" hiraginox.map || exit
$MV "morisawa.map(for udvips)"    morisawa.map  || exit
$MV "morisawax.map(for dvipdfmx)" morisawax.map || exit
)

(cd $PACKAGE/otfstable || exit; ./makeotf; ./umakeotf)

lndir $PACKAGE2/otfstable/sty $TEXMF/ptex/platex      otfstable
lndir $PACKAGE3/otfstable/vf  $TEXMF/fonts/vf/public  otfstable
lndir $PACKAGE3/otfstable/tfm $TEXMF/fonts/tfm/public otfstable
lndir $PACKAGE3/otfstable/ofm $TEXMF/fonts/ofm/public otfstable

perlprint 's/(W.)$/\1.otf/g' $PACKAGE/otfstable/fontmap/hiraginox.map
$LN $PACKAGE3/otfstable/fontmap/hiraginox.map \
                       $MAP/otf-hiragino.map
$LN $PACKAGE3/otfstable/fontmap/kozukax.map \
                       $MAP/otf-kozuka.map
$LN $PACKAGE3/otfstable/fontmap/morisawax.map \
                       $MAP/otf-morisawa.map

cat <<EOF > $MAP/otf-noEmbed.map || exit
% OTF for dvipdfmx

%%%%% min %%%%%
otf-ujmr-h	UniJIS-UTF16-H		!Ryumin-Light
otf-ujmr-v	UniJIS-UTF16-V		!Ryumin-Light
otf-cjmr-h	Identity-H		!Ryumin-Light
otf-cjmr-v	Identity-V		!Ryumin-Light
hminr-h		H			!Ryumin-Light
hminr-v		V			!Ryumin-Light
uphminr-h	UniJIS-UTF16-H		!Ryumin-Light
uphminr-v	UniJIS-UTF16-V		!Ryumin-Light

%%%%% goth %%%%%
otf-ujgr-h	UniJIS-UTF16-H		!GothicBBB-Medium
otf-ujgr-v	UniJIS-UTF16-V		!GothicBBB-Medium
otf-cjgr-h	Identity-H		!GothicBBB-Medium
otf-cjgr-v	Identity-V		!GothicBBB-Medium
hgothr-h	H			!GothicBBB-Medium
hgothr-v	V			!GothicBBB-Medium
uphgothr-h	UniJIS-UTF16-H		!GothicBBB-Medium
uphgothr-v	UniJIS-UTF16-V		!GothicBBB-Medium

%%%%% bold min %%%%%
otf-ujmb-h	UniJIS-UTF16-H		!Ryumin-Light,Bold
otf-ujmb-v	UniJIS-UTF16-V		!Ryumin-Light,Bold
otf-cjmb-h	Identity-H		!Ryumin-Light,Bold
otf-cjmb-v	Identity-V		!Ryumin-Light,Bold
hminb-h		H			!Ryumin-Light,Bold
hminb-v		V			!Ryumin-Light,Bold
uphminb-h	UniJIS-UTF16-H		!Ryumin-Light,Bold
uphminb-v	UniJIS-UTF16-V		!Ryumin-Light,Bold

%%%%% bold goth %%%%%
otf-ujgb-h	UniJIS-UTF16-H		!GothicBBB-Medium,Bold
otf-ujgb-v	UniJIS-UTF16-V		!GothicBBB-Medium,Bold
otf-cjgb-h	Identity-H		!GothicBBB-Medium,Bold
otf-cjgb-v	Identity-V		!GothicBBB-Medium,Bold
hgothb-h	H			!GothicBBB-Medium,Bold
hgothb-v	V			!GothicBBB-Medium,Bold
uphgothb-h	UniJIS-UTF16-H		!GothicBBB-Medium,Bold
uphgothb-v	UniJIS-UTF16-V		!GothicBBB-Medium,Bold

%%%%% maru goth %%%%%
otf-ujmgr-h	UniJIS-UTF16-H		!Ryumin-Light	
otf-ujmgr-v	UniJIS-UTF16-V		!Ryumin-Light
otf-cjmgr-h	Identity-H		!Ryumin-Light
otf-cjmgr-v	Identity-V		!Ryumin-Light
hmgothr-h	H			!Ryumin-Light
hmgothr-v	V			!Ryumin-Light
uphmgothr-h	UniJIS-UTF16-H		!Ryumin-Light
uphmgothr-v	UniJIS-UTF16-V		!Ryumin-Light
EOF

perl -pe 's/\!Ryumin-Light/ipam.ttf/g; 
	  s/\!GothicBBB-Medium/ipag.ttf/g;' \
	      < $MAP/otf-noEmbed.map > $MAP/otf-ipa.map

perl -pe 's/\!Ryumin-Light/ipam.otf/g; 
	  s/\!GothicBBB-Medium/ipag.otf/g;' \
	      < $MAP/otf-noEmbed.map > $MAP/otf-ipa-otf.map

cat <<EOF > $MAP/otf-cktx.map || exit
% OTF for dvipdfmx

%%%%% traditional Chinese -- serif %%%%%
otf-utmr-h	UniCNS-UTF16-H	!MSung-Light
otf-utmr-v	UniCNS-UTF16-V	!MSung-Light
otf-ctmr-h	Identity-H	!MSung-Light
otf-ctmr-v	Identity-V	!MSung-Light

%%%%% traditional Chinese -- sans serif %%%%%
otf-utgr-h	UniCNS-UTF16-H	!MHei-Medium
otf-utgr-v	UniCNS-UTF16-V	!MHei-Medium
otf-ctgr-h	Identity-H	!MHei-Medium
otf-ctgr-v	Identity-V	!MHei-Medium

%%%%% simplified Chinese -- serif %%%%%
otf-ucmr-h	UniGB-UTF16-H	!STSong-Light
otf-ucmr-v	UniGB-UTF16-V	!STSong-Light
otf-ccmr-h	Identity-H	!STSong-Light
otf-ccmr-v	Identity-V	!STSong-Light

%%%%% simplified Chinese -- sans serif %%%%%
otf-ucgr-h	UniGB-UTF16-H	!STHeitiStd-Regular
otf-ucgr-v	UniGB-UTF16-V	!STHeitiStd-Regular
otf-ccgr-h	Identity-H	!STHeitiStd-Regular
otf-ccgr-v	Identity-V	!STHeitiStd-Regular

%%%%% hangeul -- serif %%%%%
otf-ukmr-h	UniKS-UTF16-H	!HYSMyeongJo-Medium
otf-ukmr-v	UniKS-UTF16-V	!HYSMyeongJo-Medium
otf-ckmr-h	Identity-H	!HYSMyeongJo-Medium
otf-ckmr-v	Identity-V	!HYSMyeongJo-Medium

%%%%% hangeul -- sans serif %%%%%
otf-ukgr-h	UniKS-UTF16-H	!HYGoThic-Medium
otf-ukgr-v	UniKS-UTF16-V	!HYGoThic-Medium
otf-ckgr-h	Identity-H	!HYGoThic-Medium
otf-ckgr-v	Identity-V	!HYGoThic-Medium
EOF

$UPDMAP --nomkmap --enable KanjiMap otf-@kanjiEmbed@.map
$UPDMAP --nomkmap --enable KanjiMap otf-cktx.map
}

while [ -n "$1" ]; do
    case $1 in
    clean) clean;;
    default) default;;
    utf) utf;;
    otf) otf;;
    *) echo "Unknown option $1"; exit 1;;
    esac
    shift
done

## post
cd $PACKAGE || exit
chmod -R og-w .
find . -type d -name CVS        -exec $RM -r '{}' \; 2> /dev/null
find . -type f -name .cvsignore -exec $RM    '{}' \;
if test -f $SRC/inst/texmf-config/web2c/updmap.cfg; then
    $MV $SRC/inst/texmf-config/web2c/updmap.cfg $SRC/inst/texmf/web2c/ || exit
fi
echo ""
