#!/bin/bash
# Build Step 1 - extracting / patching source file and build

cd ../ptexlive-*
. common.sh
cd ../ptl08-compile
. ./option

### ptexlive
PTEXLIVE_VER=`ls  $ESRC/ptexlive-*.tar.gz|sed "s/.*ptexlive-//;s/.tar.gz//"`

cd $ESRC

PTEXENC_VER=`ls  $ESRC/ptexlive-$PTEXLIVE_VER/archive/ptexenc-*.tar.lzma|\
             sed "s/.*ptexenc-//;s/.tar.lzma//"`
echo ">>> Version of ptexenc: $PTEXENC_VER"
EPTEX_VER=`ls  eptex-*.tar.bz2|sed "s/eptex-//;s/.tar.bz2//"`
echo ">>> Version of e-pTeX: $EPTEX_VER"

if [ -f uptex-*.tar.gz ] ; then 
  UPTEX_VER=`ls  uptex-*.tar.gz|sed "s/uptex-/u/;s/.tar.gz//"`
  echo ">>> Version of upTeX: $UPTEX_VER"
  echo "[unpack] uptex-*.tar.gz"
  tarx $ESRC/uptex-0.??.tar.gz $SRC/../
else
  echo "NOTICE: upTeX is not found."
fi
echo "[unpack] eptex-*.tar.gz"
tarx $ESRC/eptex-*.tar.bz2 $SRC/texk/web2c/

#echo  "******** APPLY YOUR PATCH ********"
#read


# patch for e-pTeX
echo "[copy  ] ptexdir -> eptexdir"
cd $SRC/texk/
cp -r web2c/ptexdir web2c/eptexdir
cp -r web2c/eptex-*/* web2c/eptexdir/ 
cd ..
echo "[patch ] ep-tl08.patch"
cat $ESRC/ptl08-compile/ep-ptl08.patch | sed "s/PATCH/$PATCH/" > ep-ptl08.patch
$PATCH -p1 < ep-ptl08.patch || exit 1
$RM -f ep-ptl08.patch

cd texk/web2c/eptexdir
mv eptex-tl08.mk eptex.mk
mv ptex-base.ch eptex-base.ch
mv ptex.defines eptex.defines
$PATCH < eptex-base-tl08-*.diff || exit 1

# patch for FAM256
echo "[patch ] eptexdir/kanji.h etc (for FAM256 patch)"
cat <<EOF >> kanji.h
#define getintone(w) ((w).cint1)
#define setintone(w,a) ((w).cint1=(a))
EOF
cat <<EOF >> eptex.defines
  @define function getintone();
  @define procedure setintone();
EOF
cd ../..

if [ -f $ESRC/uptex-*.tar.gz ] ; then 
  # ptexenc-1.0.3 removed "ENC_UPTEX" etc. 
  if test `echo $PTEXENC_VER|sed s/\\\.//g` -gt 102 ; then
    echo "ptexenc's version >= 1.0.3."
    echo "[patch ] ptexenc-1.0.3-enc_uptex.diff"
    cd ptexenc
    patch -p1 < $ESRC/ptl08-compile/ptexenc-1.0.3-enc_uptex.diff || exit 1
    cd ..
  fi

  # patch for upTeX
  mv dvipsk dvipsk-orig
  mv pdvipsk dvipsk
  mv xdvik xdvik-orig
  mv pxdvik xdvik
  cd web2c/
  echo "[copy  ] ptexdir -> uptexdir"
  cp -r ptexdir/ uptexdir
  cd uptexdir
  mv ptex-base.ch uptex-base.ch
  mv ptftopl.ch uptftopl.ch
  mv ppltotf.ch uppltotf.ch
  mv pdvitype.ch updvitype.ch
  mv pbibtex.ch  upjbibtex.ch
  cd ../../../
  echo "[copy  ] upovp2ovf"
  cp texk/web2c/omegaware/ovp2ovf.web texk/web2c/omegaware/upovp2ovf.web 
  cp texk/web2c/omegaware/ovp2ovf.ch texk/web2c/omegaware/upovp2ovf.ch 
  echo "[patch ] uptex_src-*.patch"
  pushd $SRC/..
  cp uptex-*/patch/ptetex3-20090610_uptex_src-*.patch uptex-base-tl08-u0.28.patch
  $PATCH -p0 < $ESRC/ptl08-compile/tl08-uptex_src-0.28.diff
  cat uptex-base-tl08-u0.28.patch \
    |sed "s/PTENCVER/$PTEXENC_VER/" > uptex-base-tmp.patch
  popd
  $PATCH -p2 -f < $SRC/../uptex-base-tmp.patch &>/dev/null
  rm -f $SRC/uptex-base-tl08-u0.28.patch $SRC/../uptex-base-tmp.patch 
  cd texk/web2c/

  # patch for e-upTeX
  echo "[copy  ] uptexdir -> euptexdir"
  cp -r uptexdir/ euptexdir
  cd euptexdir/
  mv uptex-base.ch euptex-base.ch
  cp ../eptexdir/euptex-tl08.mk euptex.mk
  cp ../eptex-$EPTEX_VER/fam256.ch .
  $PATCH < ../eptex-$EPTEX_VER/euptex-base-tl08-*.diff || exit 1
  cd ../../..

  # patch for e-upTeX
  echo "[patch ] eup-ptl08-*.patch"
  cat $ESRC/ptl08-compile/eup-ptl08-*.patch \
    | sed "s/UPTEXVER/$UPTEX_VER/;s/PTENCVER/$PTEXENC_VER/;s/EPTEXVER/$EPTEX_VER/" \
    | sed "s/PATCH/$PATCH/" > $SRC/../up-ptl08.patch 
  $PATCH -p1 <$SRC/../up-ptl08.patch  || exit 1

  # patch for ptexenc 
  cd texk/ptexenc
  echo "[patch ] uptex_ptexenc-1.0.4.patch"
  $PATCH -p1 < $ESRC/ptl08-compile/uptex_ptexenc-1.0.4.patch || exit 1
  cd ../
  mv dvipsk pdvipsk
  mv dvipsk-orig dvipsk
  mv xdvik pxdvik
  mv xdvik-orig xdvik
  cd ../

  cat <<EOF >> texk/web2c/euptexdir/kanji.h
#define getintone(w) (w).cint1
#define setintone(w,a) ((w).cint1=(a))
EOF
  cat <<EOF >> texk/web2c/euptexdir/euptex.defines
  @define function getintone( );
  @define procedure setintone( );
EOF
  cd texk
fi

echo "[patch ] texmfmem.h           (for e-pTeX)"
cat web2c/texmfmem.h \
  | sed "s/\!defined(Aleph)/\!defined(Aleph)\ \&\&\ \!defined(epTeX)\ \&\&\ \!defined(eupTeX)/" \
  > web2c/texmfmem2.h
mv web2c/texmfmem.h web2c/texmfmem.h.orig
cp -f  web2c/texmfmem2.h web2c/texmfmem.h

# BUILD
cd $ESRC/ptexlive-*
make stage3


if [ -f $ESRC/uptex-*.tar.gz ] ; then 
  echo "[copy  ] convbkmk.rb to inst/bin/"
  ARCH=`ls $SRC/inst/bin`
  cp $SRC/../uptex-*/patch/convbkmk.rb $SRC/inst/bin/$ARCH/
fi

echo "------------------------"
ARCH=`ls $SRC/inst/bin`
$SRC/inst/bin/$ARCH/eptex -version  |head -1
if [ -f $ESRC/uptex-*.tar.gz ] ; then 
  $SRC/inst/bin/$ARCH/euptex -version |head -1
fi

#This script ends here.
exit 0


# DEBUG: Making ptl08-compile-*.tar.lzma
cd $ESRC
rm -f ptl08-compile/*~
tar --lzma -cvf ptl08-compile-`date +%y%m%d`.tar.lzma ptl08-compile/
