/*
 * ESE, a HyperText Transfer Protocol server
 * Copyright (C) 1996-2001 Akira Higuchi <a-higuti@math.sci.hokudai.ac.jp>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef EH_FD_H
#define EH_FD_H

typedef struct eh_fd_s {
  struct pollfd pfd;
  void (*on_event)(struct eh_fd_s *ef);
  void (*on_timer)(struct eh_fd_s *ef, int graceful_shutdown);
  void (*on_delete)(struct eh_fd_s *ef);
  void *user_data;
  void (*show_status)(struct eh_fd_s *ef, char **strp);
  int active_flag : 1;
} eh_fd_t;

typedef enum {
  eh_fd_multiplexing_method_poll = 1,
  eh_fd_multiplexing_method_rtsignal = 2,
} eh_fd_multiplexing_method_t;

#if 0
#define POLLIN      0x0001    /* There is data to read */
#define POLLPRI     0x0002    /* There is urgent data to read */
#define POLLOUT     0x0004    /* Writing now will not block */
#define POLLERR     0x0008    /* Error condition */
#define POLLHUP     0x0010    /* Hung up */
#define POLLNVAL    0x0020    /* Invalid request: fd not open */
struct pollfd {
  int fd;           /* file descriptor */
  short events;     /* requested events */
  short revents;    /* returned events */
};
#endif

void eh_fd_init (int force_to_use_poll);
void eh_fd_getpid (void);
void eh_fd_block_rtsignal (void);
eh_fd_multiplexing_method_t eh_fd_get_multiplexing_method (void);
int eh_fd_delegate (pid_t pid, sigval_t sval);
time_t eh_fd_get_time (void);
const char *eh_fd_get_time_string (void);
const char *eh_fd_get_time_string_logformat (void);
int eh_fd_get_open_count (void);
eh_fd_t *eh_fd_new (int fd,
		    void (*on_event)(eh_fd_t *ef),
		    void (*on_timer)(eh_fd_t *ef, int graceful_shutdown),
		    void (*on_delete)(eh_fd_t *ef),
		    void *user_data);
void eh_fd_set_data (eh_fd_t *ef,
		     void (*on_event)(eh_fd_t *ef),
		     void (*on_timer)(eh_fd_t *ef, int graceful_shutdown),
		     void (*on_delete)(eh_fd_t *ef),
		     void *user_data);
void eh_fd_reset_pid(eh_fd_t *ef);
void eh_fd_request_events (eh_fd_t *ef, short events);
void eh_fd_clear_revents (eh_fd_t *ef, short revents);
void eh_fd_delete_request (eh_fd_t *ef);
void eh_fd_start_timer (int timeout_msec);
int  eh_fd_check_and_dispatch_events (int timeout_msec);
void eh_fd_set_childexit_callback (void (*on_exitchild)(pid_t pid,
							int status,
							void *data),
				   void *data);
void eh_fd_set_global_timer_callback (void (*on_timer)(void *data),
				      void *data);
void eh_fd_schedule_graceful_shutdown (int status);
void eh_fd_free_all (void);

void eh_fd_set_show_status_callback (eh_fd_t *ef,
				     void (*show_status)(eh_fd_t *ef,
							 char **strp));
void eh_fd_show_status (char **strp, int my_fd);

#ifdef DEBUG_TRACE_EVENTS
void eh_fd_debug_trace (eh_fd_t *ef, int val);
#else
#define eh_fd_debug_trace(x, y)
#endif

#endif
