/*
 * ESE, a HyperText Transfer Protocol server
 * Copyright (C) 1996-2001 Akira Higuchi <a-higuti@math.sci.hokudai.ac.jp>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef EH_HEADERS_H
#define EH_HEADERS_H

typedef struct {
  const char *name;
  const char *value;
} eh_header_entry_t;

typedef struct {
  /* request header fields */
  const char *host;
  const char *content_type;
  const char *content_length;
  const char *authorization;
  const char *if_modified_since;
  const char *if_unmodified_since;
  const char *if_range;
  const char *expect;
  const char *connection;
  const char *transfer_encoding;
  const char *cache_control;
  const char *pragma;
  const char *range;
  const char *user_agent;
  const char *referer;
  /* cgi */
  const char *location;
  const char *status;
} eh_predef_fields_t;

typedef struct {
  int ill_formed;
  eh_predef_fields_t predef;
  size_t hentry_len;
  size_t hentry_alloclen;
  eh_header_entry_t *hentry;
} eh_headers_t;

/* headers_str must alive until req_r is discarded */
/* '*eh' must be filled with 0's already. eh_headers_initnc doesn't clear it */
void eh_headers_initnc (eh_headers_t *eh, char *headers_str,
			char *headers_str_end);
void eh_headers_discard (eh_headers_t *eh);
void eh_headers_remove (eh_headers_t *eh, const char *name);
void eh_headers_append (eh_headers_t *eh, const char *name, const char *value);
char *eh_headers_strdup_find (const eh_headers_t *eh, const char *name);
char *eh_headers_strdup_getall (const eh_headers_t *eh);
void eh_headers_forall (const eh_headers_t *eh,
			void (*func)(const char *key, const char *val,
				     void *data),
			void *data);

#endif

