/*
 * ESE, a HyperText Transfer Protocol server
 * Copyright (C) 1996-2001 Akira Higuchi <a-higuti@math.sci.hokudai.ac.jp>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef EH_MEM_H
#define EH_MEM_H

#ifndef EH_DONT_PROHIBIT_MALLOC
#undef malloc
#undef free
#undef realloc
#undef calloc
#undef valloc
#undef memalign
#undef strdup
#undef asprintf
#undef vasprintf
#define malloc malloc_prohibited
#define free malloc_prohibited
#define realloc malloc_prohibited
#define calloc malloc_prohibited
#define valloc malloc_prohibited
#define memalign malloc_prohibited
#define strdup malloc_prohibited
#define asprintf malloc_prohibited
#define vasprintf malloc_prohibited
#endif

#define x_alloca(x) alloca(x)
#define x_alloca_free(x)

#ifdef DEBUG_HEAP

void x_set_mcaller_debug (const char *mcaller, void *p);
void x_set_fcaller_debug (const char *fcaller, void *p);
void *x_malloc_debug (const char *mcaller, size_t s);
void x_free_debug (const char *fcaller, void *p);
void *x_realloc_debug (const char *caller, void *p, size_t s);
char *x_strdup_printf_debug (const char *mcaller, const char *format, ...);
char *x_strndup_debug (const char *mcaller, const char *str, int n);
char *x_strdup_debug (const char *mcaller, const char *str);
void x_str_append_debug (const char *mcaller, char **str,
			 const char *appendstr);
void x_append_printf_debug (const char *mcaller, char **str,
			    const char *format, ...);
void x_mem_check_debug (void);
#define x_set_mcaller(p)          x_set_mcaller_debug(__FUNCTION__, p)
#define x_set_fcaller(p)          x_set_fcaller_debug(__FUNCTION__, p)
#define x_malloc(s)               x_malloc_debug(__FUNCTION__, s)
#define x_free(p)                 x_free_debug(__FUNCTION__, p)
#define x_realloc(p, s)           x_realloc_debug(__FUNCTION__, p, s)
#define x_strdup_printf(args...)  x_strdup_printf_debug(__FUNCTION__, args)
#define x_strndup(str, n)         x_strndup_debug(__FUNCTION__, str, n)
#define x_strdup(str)             x_strdup_debug(__FUNCTION__, str)
#define x_str_append(str, astr)   x_str_append_debug(__FUNCTION__, str, astr)
#define x_append_printf(args...)  x_append_printf_debug(__FUNCTION__, args)
#define x_mem_check()             x_mem_check_debug()

#else /* DEBUG_HEAP */

void *x_malloc_nodebug (size_t s);
void x_free_nodebug (void *p);
void *x_realloc_nodebug (void *p, size_t s);
char *x_strdup_printf_nodebug (const char *format, ...);
char *x_strndup_nodebug (const char *str, int n);
char *x_strdup_nodebug (const char *str);
void x_str_append_nodebug (char **str, const char *appendstr);
void x_append_printf_nodebug (char **str, const char *format, ...);
#define x_set_mcaller(p)
#define x_set_fcaller(p)
#define x_malloc(s)              x_malloc_nodebug(s)
#define x_free(p)                x_free_nodebug(p)
#define x_realloc(p, s)          x_realloc_nodebug(p, s)
#define x_strdup_printf(args...) x_strdup_printf_nodebug(args)
#define x_strndup(str, n)        x_strndup_nodebug(str, n)
#define x_strdup(str)            x_strdup_nodebug(str)
#define x_str_append(str, astr)  x_str_append_nodebug(str, astr)
#define x_append_printf(args...) x_append_printf_nodebug(args)
#define x_mem_check()

#endif /* DEBUG_HEAP */

#endif

