/*
 * ESE, a HyperText Transfer Protocol server
 * Copyright (C) 1996-2001 Akira Higuchi <a-higuti@math.sci.hokudai.ac.jp>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef EH_REQUEST_H
#define EH_REQUEST_H

typedef enum {
  eh_rconn_close = 0,
  eh_rconn_keepalive,
} eh_response_connection_t;

struct eh_request_s;
struct eh_rhandler_s;

typedef struct eh_rhandler_s *
eh_rhandler_new_func_t (struct eh_connection_s *ec,
			const struct eh_request_s *er,
			void *data);

typedef struct eh_request_s {
  int not_finished : 1;
  int bad_request : 1;
  const char *request_str_ref;
  size_t request_len;
  size_t extra_len;
  size_t request_body_length;
  eh_method_t method;
  const char *method_str;
  const char *url;
  const char *query_string;
  eh_headers_t headers;
  eh_config_vhost_t *econf_vhost_ref;
  eh_config_dir_t *econf_dir_ref;
  eh_config_limit_t *econf_limit_ref;
  eh_rhandler_new_func_t *rhfunc;
  void *rhfunc_data;
  eh_response_connection_t rconn;
  int need_connection_field;
  char *request_line;
  char *host;
  char *filename;
  const char *mime_type;
  eh_filecache_entry_t *fcent_ref;
  char *remote_user;
  struct stat statbuf;
  int http_version_minor;
  int response_status;
  size_t response_length;
} eh_request_t;

struct eh_connection_s;

/* request_str must alive until req_r is discarded */
void eh_request_init (eh_request_t *req_r,
		      char *request_str,
		      size_t request_len, size_t extra_len,
		      eh_config_vhost_t *ecv,
		      int use_access_log,
		      eh_accesslog_t *ea);
int eh_request_url_to_filename (eh_request_t *req, struct eh_connection_s *ce);
void eh_request_set_remote_user (eh_request_t *req, const char *remote_user);
void eh_request_discard (eh_request_t *req);

#endif

