/*
 * ESE, a HyperText Transfer Protocol server
 * Copyright (C) 1996-2001 Akira Higuchi <a-higuti@math.sci.hokudai.ac.jp>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef EH_RHANDLER_H
#define EH_RHANDLER_H

typedef enum {
  eh_rhandler_retval_close_connection,
  eh_rhandler_retval_finish,
  eh_rhandler_retval_success,
} eh_rhandler_retval_t;

typedef struct eh_rhandler_s eh_rhandler_t;
struct eh_rhandler_s {
  size_t body_length_left;
  void *extdata;
  void /* eh_rhandler_retval_t */ (*on_read_request_body)
       (eh_rhandler_t *eh, const char *buf, size_t buflen);
  int (*do_timeout)(eh_rhandler_t *eh);
  void (*on_delete)(eh_rhandler_t *eh);
};

struct eh_connection_s;

void eh_rhandler_on_read_request_body (struct eh_connection_s *ec,
				  const char *buf,
				  size_t buflen);
void eh_rhandler_delete (struct eh_connection_s *ec);

void eh_register_rhandler (const char *rhandler_name,
			   eh_rhandler_new_func_t *func,
			   void *rhfunc_data,
			   int nofilesystem);
eh_rhandler_new_func_t *eh_get_rhandler (const char *rhandler_name,
					 void **rhfunc_data_r,
					 int *nofilesystem_r);

#ifdef __cplusplus
#define REGISTER_HANDLER(name, func, data, nofs)        \
struct func##_dummyclass {                               \
  func##_dummyclass ()                                  \
  { eh_register_rhandler (name, func, data, nofs); }    \
};                                                      \
static func##_dummyclass func##_dummyobj;
#else
#define REGISTER_HANDLER(name, func, data, nofs)                              \
static void dummyfunc (void) __attribute__ ((constructor));                   \
static void dummyfunc (void) { eh_register_rhandler (name, func, data, nofs); }
#endif

eh_rhandler_t *
eh_rhandler_vacuum_new (struct eh_connection_s *ec, const eh_request_t *er);

#endif

