/**
 * Autogenerated by Thrift
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 */
package com.evernote.edam.type;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import com.evernote.edam.util.BitSet;
import java.util.Arrays;

import org.apache.thrift.*;
import org.apache.thrift.meta_data.*;
import org.apache.thrift.protocol.*;

/**
 *  This represents the information about a single user account.
 * <dl>
 *  <dt>id</dt>
 *    <dd>The unique numeric identifier for the account, which will not
 *    change for the lifetime of the account.
 *    </dd>
 * 
 *  <dt>username</dt>
 *    <dd>The name that the user provides to log in to their
 *    account. In the future, this may be empty for some accounts if their login
 *    process is indirect (e.g. via social networks, etc.).
 *    May only contain a-z, 0-9, or '-', and may not start or end with the '-'
 *    <br/>
 *    Length:  EDAM_USER_USERNAME_LEN_MIN - EDAM_USER_USERNAME_LEN_MAX
 *    <br/>
 *    Regex:  EDAM_USER_USERNAME_REGEX
 *    </dd>
 * 
 *  <dt>email</dt>
 *    <dd>The email address registered for the user.  Must comply with
 *    RFC 2821 and RFC 2822.<br/>
 *    Length:  EDAM_EMAIL_LEN_MIN - EDAM_EMAIL_LEN_MAX
 *    <br/>
 *    Regex:  EDAM_EMAIL_REGEX
 *    </dd>
 * 
 *  <dt>name</dt>
 *    <dd>The printable name of the user, which may be a combination
 *    of given and family names.  This is used instead of separate "first"
 *    and "last" names due to variations in international name format/order.
 *    May not start or end with a whitespace character.  May contain any
 *    character but carriage return or newline (Unicode classes Zl and Zp).
 *    <br/>
 *    Length:  EDAM_USER_NAME_LEN_MIN - EDAM_USER_NAME_LEN_MAX
 *    <br/>
 *    Regex:  EDAM_USER_NAME_REGEX
 *    </dd>
 * 
 *  <dt>timezone</dt>
 *    <dd>The zone ID for the user's default location.  If present,
 *    this may be used to localize the display of any timestamp for which no
 *    other timezone is available - for example, an note that arrives via
 *    a micro-browser may not contain enough information to display its
 *    local time, so this default timezone may be assigned to the note.
 *    The format must be encoded as a standard zone ID such as
 *    "America/Los_Angeles" or "GMT+08:00"
 *    <br/>
 *    Length:  EDAM_TIMEZONE_LEN_MIN - EDAM_TIMEZONE_LEN_MAX
 *    <br/>
 *    Regex:  EDAM_TIMEZONE_REGEX
 *    </dd>
 * 
 *  <dt>privilege</dt>
 *    <dd>The level of access permitted for the user.
 *    </dd>
 * 
 *  <dt>created</dt>
 *    <dd>The date and time when this user account was created in the
 *    service.
 *    </dd>
 * 
 *  <dt>updated</dt>
 *    <dd>The date and time when this user account was last modified
 *    in the service.
 *    </dd>
 * 
 *  <dt>deleted</dt>
 *    <dd>If the account has been deleted from the system (e.g. as
 *    the result of a legal request by the user), the date and time of the
 *    deletion will be represented here.  If not, this value will not be set.
 *    </dd>
 * 
 *  <dt>active</dt>
 *    <dd>If the user account is available for login and
 *    synchronization, this flag will be set to true.
 *    </dd>
 * 
 *  <dt>shardId</dt>
 *    <dd>The name of the virtual server that manages the state of
 *    this user.  This value is used internally to determine which system should
 *    service requests about this user's data.
 *    </dd>
 * 
 *  <dt>attributes</dt>
 *    <dd>If present, this will contain a list of the attributes
 *    for this user account.
 *    </dd>
 * 
 *  <dt>accounting</dt>
 *    <dd>Bookkeeping information for the user's subscription.
 *    </dd>
 *  </dl>
 */
public class User implements TBase<User._Fields>, java.io.Serializable, Cloneable, Comparable<User> {
  private static final TStruct STRUCT_DESC = new TStruct("User");

  private static final TField ID_FIELD_DESC = new TField("id", TType.I32, (short)1);
  private static final TField USERNAME_FIELD_DESC = new TField("username", TType.STRING, (short)2);
  private static final TField EMAIL_FIELD_DESC = new TField("email", TType.STRING, (short)3);
  private static final TField NAME_FIELD_DESC = new TField("name", TType.STRING, (short)4);
  private static final TField TIMEZONE_FIELD_DESC = new TField("timezone", TType.STRING, (short)6);
  private static final TField PRIVILEGE_FIELD_DESC = new TField("privilege", TType.I32, (short)7);
  private static final TField CREATED_FIELD_DESC = new TField("created", TType.I64, (short)9);
  private static final TField UPDATED_FIELD_DESC = new TField("updated", TType.I64, (short)10);
  private static final TField DELETED_FIELD_DESC = new TField("deleted", TType.I64, (short)11);
  private static final TField ACTIVE_FIELD_DESC = new TField("active", TType.BOOL, (short)13);
  private static final TField SHARD_ID_FIELD_DESC = new TField("shardId", TType.STRING, (short)14);
  private static final TField ATTRIBUTES_FIELD_DESC = new TField("attributes", TType.STRUCT, (short)15);
  private static final TField ACCOUNTING_FIELD_DESC = new TField("accounting", TType.STRUCT, (short)16);

  private int id;
  private String username;
  private String email;
  private String name;
  private String timezone;
  private PrivilegeLevel privilege;
  private long created;
  private long updated;
  private long deleted;
  private boolean active;
  private String shardId;
  private UserAttributes attributes;
  private Accounting accounting;

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements TFieldIdEnum {
    ID((short)1, "id"),
    USERNAME((short)2, "username"),
    EMAIL((short)3, "email"),
    NAME((short)4, "name"),
    TIMEZONE((short)6, "timezone"),
    /**
     * 
     * @see PrivilegeLevel
     */
    PRIVILEGE((short)7, "privilege"),
    CREATED((short)9, "created"),
    UPDATED((short)10, "updated"),
    DELETED((short)11, "deleted"),
    ACTIVE((short)13, "active"),
    SHARD_ID((short)14, "shardId"),
    ATTRIBUTES((short)15, "attributes"),
    ACCOUNTING((short)16, "accounting");

    private static final Map<Integer, _Fields> byId = new HashMap<Integer, _Fields>();
    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byId.put((int)field._thriftId, field);
        byName.put(field.getFieldName(), field);
      }
    }

    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      return byId.get(fieldId);
    }

    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }

    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }

    private final short _thriftId;
    private final String _fieldName;

    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }

    public short getThriftFieldId() {
      return _thriftId;
    }

    public String getFieldName() {
      return _fieldName;
    }
  }

  // isset id assignments
  private static final int __ID_ISSET_ID = 0;
  private static final int __CREATED_ISSET_ID = 1;
  private static final int __UPDATED_ISSET_ID = 2;
  private static final int __DELETED_ISSET_ID = 3;
  private static final int __ACTIVE_ISSET_ID = 4;
  private BitSet __isset_bit_vector = new BitSet(5);

  public static final Map<_Fields, FieldMetaData> metaDataMap = Collections.unmodifiableMap(new EnumMap<_Fields, FieldMetaData>(_Fields.class) {{
    put(_Fields.ID, new FieldMetaData("id", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.I32)));
    put(_Fields.USERNAME, new FieldMetaData("username", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.STRING)));
    put(_Fields.EMAIL, new FieldMetaData("email", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.STRING)));
    put(_Fields.NAME, new FieldMetaData("name", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.STRING)));
    put(_Fields.TIMEZONE, new FieldMetaData("timezone", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.STRING)));
    put(_Fields.PRIVILEGE, new FieldMetaData("privilege", TFieldRequirementType.OPTIONAL, 
        new EnumMetaData(TType.ENUM, PrivilegeLevel.class)));
    put(_Fields.CREATED, new FieldMetaData("created", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.I64)));
    put(_Fields.UPDATED, new FieldMetaData("updated", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.I64)));
    put(_Fields.DELETED, new FieldMetaData("deleted", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.I64)));
    put(_Fields.ACTIVE, new FieldMetaData("active", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.BOOL)));
    put(_Fields.SHARD_ID, new FieldMetaData("shardId", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.STRING)));
    put(_Fields.ATTRIBUTES, new FieldMetaData("attributes", TFieldRequirementType.OPTIONAL, 
        new StructMetaData(TType.STRUCT, UserAttributes.class)));
    put(_Fields.ACCOUNTING, new FieldMetaData("accounting", TFieldRequirementType.OPTIONAL, 
        new StructMetaData(TType.STRUCT, Accounting.class)));
  }});

  static {
    FieldMetaData.addStructMetaDataMap(User.class, metaDataMap);
  }

  public User() {
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public User(User other) {
    __isset_bit_vector.clear();
    __isset_bit_vector.or(other.__isset_bit_vector);
    this.id = other.id;
    if (other.isSetUsername()) {
      this.username = other.username;
    }
    if (other.isSetEmail()) {
      this.email = other.email;
    }
    if (other.isSetName()) {
      this.name = other.name;
    }
    if (other.isSetTimezone()) {
      this.timezone = other.timezone;
    }
    if (other.isSetPrivilege()) {
      this.privilege = other.privilege;
    }
    this.created = other.created;
    this.updated = other.updated;
    this.deleted = other.deleted;
    this.active = other.active;
    if (other.isSetShardId()) {
      this.shardId = other.shardId;
    }
    if (other.isSetAttributes()) {
      this.attributes = new UserAttributes(other.attributes);
    }
    if (other.isSetAccounting()) {
      this.accounting = new Accounting(other.accounting);
    }
  }

  public User deepCopy() {
    return new User(this);
  }

  @Deprecated
  public User clone() {
    return new User(this);
  }

  public int getId() {
    return this.id;
  }

  public void setId(int id) {
    this.id = id;
    setIdIsSet(true);
  }

  public void unsetId() {
    __isset_bit_vector.clear(__ID_ISSET_ID);
  }

  /** Returns true if field id is set (has been asigned a value) and false otherwise */
  public boolean isSetId() {
    return __isset_bit_vector.get(__ID_ISSET_ID);
  }

  public void setIdIsSet(boolean value) {
    __isset_bit_vector.set(__ID_ISSET_ID, value);
  }

  public String getUsername() {
    return this.username;
  }

  public void setUsername(String username) {
    this.username = username;
  }

  public void unsetUsername() {
    this.username = null;
  }

  /** Returns true if field username is set (has been asigned a value) and false otherwise */
  public boolean isSetUsername() {
    return this.username != null;
  }

  public void setUsernameIsSet(boolean value) {
    if (!value) {
      this.username = null;
    }
  }

  public String getEmail() {
    return this.email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  public void unsetEmail() {
    this.email = null;
  }

  /** Returns true if field email is set (has been asigned a value) and false otherwise */
  public boolean isSetEmail() {
    return this.email != null;
  }

  public void setEmailIsSet(boolean value) {
    if (!value) {
      this.email = null;
    }
  }

  public String getName() {
    return this.name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public void unsetName() {
    this.name = null;
  }

  /** Returns true if field name is set (has been asigned a value) and false otherwise */
  public boolean isSetName() {
    return this.name != null;
  }

  public void setNameIsSet(boolean value) {
    if (!value) {
      this.name = null;
    }
  }

  public String getTimezone() {
    return this.timezone;
  }

  public void setTimezone(String timezone) {
    this.timezone = timezone;
  }

  public void unsetTimezone() {
    this.timezone = null;
  }

  /** Returns true if field timezone is set (has been asigned a value) and false otherwise */
  public boolean isSetTimezone() {
    return this.timezone != null;
  }

  public void setTimezoneIsSet(boolean value) {
    if (!value) {
      this.timezone = null;
    }
  }

  /**
   * 
   * @see PrivilegeLevel
   */
  public PrivilegeLevel getPrivilege() {
    return this.privilege;
  }

  /**
   * 
   * @see PrivilegeLevel
   */
  public void setPrivilege(PrivilegeLevel privilege) {
    this.privilege = privilege;
  }

  public void unsetPrivilege() {
    this.privilege = null;
  }

  /** Returns true if field privilege is set (has been asigned a value) and false otherwise */
  public boolean isSetPrivilege() {
    return this.privilege != null;
  }

  public void setPrivilegeIsSet(boolean value) {
    if (!value) {
      this.privilege = null;
    }
  }

  public long getCreated() {
    return this.created;
  }

  public void setCreated(long created) {
    this.created = created;
    setCreatedIsSet(true);
  }

  public void unsetCreated() {
    __isset_bit_vector.clear(__CREATED_ISSET_ID);
  }

  /** Returns true if field created is set (has been asigned a value) and false otherwise */
  public boolean isSetCreated() {
    return __isset_bit_vector.get(__CREATED_ISSET_ID);
  }

  public void setCreatedIsSet(boolean value) {
    __isset_bit_vector.set(__CREATED_ISSET_ID, value);
  }

  public long getUpdated() {
    return this.updated;
  }

  public void setUpdated(long updated) {
    this.updated = updated;
    setUpdatedIsSet(true);
  }

  public void unsetUpdated() {
    __isset_bit_vector.clear(__UPDATED_ISSET_ID);
  }

  /** Returns true if field updated is set (has been asigned a value) and false otherwise */
  public boolean isSetUpdated() {
    return __isset_bit_vector.get(__UPDATED_ISSET_ID);
  }

  public void setUpdatedIsSet(boolean value) {
    __isset_bit_vector.set(__UPDATED_ISSET_ID, value);
  }

  public long getDeleted() {
    return this.deleted;
  }

  public void setDeleted(long deleted) {
    this.deleted = deleted;
    setDeletedIsSet(true);
  }

  public void unsetDeleted() {
    __isset_bit_vector.clear(__DELETED_ISSET_ID);
  }

  /** Returns true if field deleted is set (has been asigned a value) and false otherwise */
  public boolean isSetDeleted() {
    return __isset_bit_vector.get(__DELETED_ISSET_ID);
  }

  public void setDeletedIsSet(boolean value) {
    __isset_bit_vector.set(__DELETED_ISSET_ID, value);
  }

  public boolean isActive() {
    return this.active;
  }

  public void setActive(boolean active) {
    this.active = active;
    setActiveIsSet(true);
  }

  public void unsetActive() {
    __isset_bit_vector.clear(__ACTIVE_ISSET_ID);
  }

  /** Returns true if field active is set (has been asigned a value) and false otherwise */
  public boolean isSetActive() {
    return __isset_bit_vector.get(__ACTIVE_ISSET_ID);
  }

  public void setActiveIsSet(boolean value) {
    __isset_bit_vector.set(__ACTIVE_ISSET_ID, value);
  }

  public String getShardId() {
    return this.shardId;
  }

  public void setShardId(String shardId) {
    this.shardId = shardId;
  }

  public void unsetShardId() {
    this.shardId = null;
  }

  /** Returns true if field shardId is set (has been asigned a value) and false otherwise */
  public boolean isSetShardId() {
    return this.shardId != null;
  }

  public void setShardIdIsSet(boolean value) {
    if (!value) {
      this.shardId = null;
    }
  }

  public UserAttributes getAttributes() {
    return this.attributes;
  }

  public void setAttributes(UserAttributes attributes) {
    this.attributes = attributes;
  }

  public void unsetAttributes() {
    this.attributes = null;
  }

  /** Returns true if field attributes is set (has been asigned a value) and false otherwise */
  public boolean isSetAttributes() {
    return this.attributes != null;
  }

  public void setAttributesIsSet(boolean value) {
    if (!value) {
      this.attributes = null;
    }
  }

  public Accounting getAccounting() {
    return this.accounting;
  }

  public void setAccounting(Accounting accounting) {
    this.accounting = accounting;
  }

  public void unsetAccounting() {
    this.accounting = null;
  }

  /** Returns true if field accounting is set (has been asigned a value) and false otherwise */
  public boolean isSetAccounting() {
    return this.accounting != null;
  }

  public void setAccountingIsSet(boolean value) {
    if (!value) {
      this.accounting = null;
    }
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case ID:
      if (value == null) {
        unsetId();
      } else {
        setId((Integer)value);
      }
      break;

    case USERNAME:
      if (value == null) {
        unsetUsername();
      } else {
        setUsername((String)value);
      }
      break;

    case EMAIL:
      if (value == null) {
        unsetEmail();
      } else {
        setEmail((String)value);
      }
      break;

    case NAME:
      if (value == null) {
        unsetName();
      } else {
        setName((String)value);
      }
      break;

    case TIMEZONE:
      if (value == null) {
        unsetTimezone();
      } else {
        setTimezone((String)value);
      }
      break;

    case PRIVILEGE:
      if (value == null) {
        unsetPrivilege();
      } else {
        setPrivilege((PrivilegeLevel)value);
      }
      break;

    case CREATED:
      if (value == null) {
        unsetCreated();
      } else {
        setCreated((Long)value);
      }
      break;

    case UPDATED:
      if (value == null) {
        unsetUpdated();
      } else {
        setUpdated((Long)value);
      }
      break;

    case DELETED:
      if (value == null) {
        unsetDeleted();
      } else {
        setDeleted((Long)value);
      }
      break;

    case ACTIVE:
      if (value == null) {
        unsetActive();
      } else {
        setActive((Boolean)value);
      }
      break;

    case SHARD_ID:
      if (value == null) {
        unsetShardId();
      } else {
        setShardId((String)value);
      }
      break;

    case ATTRIBUTES:
      if (value == null) {
        unsetAttributes();
      } else {
        setAttributes((UserAttributes)value);
      }
      break;

    case ACCOUNTING:
      if (value == null) {
        unsetAccounting();
      } else {
        setAccounting((Accounting)value);
      }
      break;

    }
  }

  public void setFieldValue(int fieldID, Object value) {
    setFieldValue(_Fields.findByThriftIdOrThrow(fieldID), value);
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case ID:
      return new Integer(getId());

    case USERNAME:
      return getUsername();

    case EMAIL:
      return getEmail();

    case NAME:
      return getName();

    case TIMEZONE:
      return getTimezone();

    case PRIVILEGE:
      return getPrivilege();

    case CREATED:
      return new Long(getCreated());

    case UPDATED:
      return new Long(getUpdated());

    case DELETED:
      return new Long(getDeleted());

    case ACTIVE:
      return new Boolean(isActive());

    case SHARD_ID:
      return getShardId();

    case ATTRIBUTES:
      return getAttributes();

    case ACCOUNTING:
      return getAccounting();

    }
    throw new IllegalStateException();
  }

  public Object getFieldValue(int fieldId) {
    return getFieldValue(_Fields.findByThriftIdOrThrow(fieldId));
  }

  /** Returns true if field corresponding to fieldID is set (has been asigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    switch (field) {
    case ID:
      return isSetId();
    case USERNAME:
      return isSetUsername();
    case EMAIL:
      return isSetEmail();
    case NAME:
      return isSetName();
    case TIMEZONE:
      return isSetTimezone();
    case PRIVILEGE:
      return isSetPrivilege();
    case CREATED:
      return isSetCreated();
    case UPDATED:
      return isSetUpdated();
    case DELETED:
      return isSetDeleted();
    case ACTIVE:
      return isSetActive();
    case SHARD_ID:
      return isSetShardId();
    case ATTRIBUTES:
      return isSetAttributes();
    case ACCOUNTING:
      return isSetAccounting();
    }
    throw new IllegalStateException();
  }

  public boolean isSet(int fieldID) {
    return isSet(_Fields.findByThriftIdOrThrow(fieldID));
  }

  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof User)
      return this.equals((User)that);
    return false;
  }

  public boolean equals(User that) {
    if (that == null)
      return false;

    boolean this_present_id = true && this.isSetId();
    boolean that_present_id = true && that.isSetId();
    if (this_present_id || that_present_id) {
      if (!(this_present_id && that_present_id))
        return false;
      if (this.id != that.id)
        return false;
    }

    boolean this_present_username = true && this.isSetUsername();
    boolean that_present_username = true && that.isSetUsername();
    if (this_present_username || that_present_username) {
      if (!(this_present_username && that_present_username))
        return false;
      if (!this.username.equals(that.username))
        return false;
    }

    boolean this_present_email = true && this.isSetEmail();
    boolean that_present_email = true && that.isSetEmail();
    if (this_present_email || that_present_email) {
      if (!(this_present_email && that_present_email))
        return false;
      if (!this.email.equals(that.email))
        return false;
    }

    boolean this_present_name = true && this.isSetName();
    boolean that_present_name = true && that.isSetName();
    if (this_present_name || that_present_name) {
      if (!(this_present_name && that_present_name))
        return false;
      if (!this.name.equals(that.name))
        return false;
    }

    boolean this_present_timezone = true && this.isSetTimezone();
    boolean that_present_timezone = true && that.isSetTimezone();
    if (this_present_timezone || that_present_timezone) {
      if (!(this_present_timezone && that_present_timezone))
        return false;
      if (!this.timezone.equals(that.timezone))
        return false;
    }

    boolean this_present_privilege = true && this.isSetPrivilege();
    boolean that_present_privilege = true && that.isSetPrivilege();
    if (this_present_privilege || that_present_privilege) {
      if (!(this_present_privilege && that_present_privilege))
        return false;
      if (!this.privilege.equals(that.privilege))
        return false;
    }

    boolean this_present_created = true && this.isSetCreated();
    boolean that_present_created = true && that.isSetCreated();
    if (this_present_created || that_present_created) {
      if (!(this_present_created && that_present_created))
        return false;
      if (this.created != that.created)
        return false;
    }

    boolean this_present_updated = true && this.isSetUpdated();
    boolean that_present_updated = true && that.isSetUpdated();
    if (this_present_updated || that_present_updated) {
      if (!(this_present_updated && that_present_updated))
        return false;
      if (this.updated != that.updated)
        return false;
    }

    boolean this_present_deleted = true && this.isSetDeleted();
    boolean that_present_deleted = true && that.isSetDeleted();
    if (this_present_deleted || that_present_deleted) {
      if (!(this_present_deleted && that_present_deleted))
        return false;
      if (this.deleted != that.deleted)
        return false;
    }

    boolean this_present_active = true && this.isSetActive();
    boolean that_present_active = true && that.isSetActive();
    if (this_present_active || that_present_active) {
      if (!(this_present_active && that_present_active))
        return false;
      if (this.active != that.active)
        return false;
    }

    boolean this_present_shardId = true && this.isSetShardId();
    boolean that_present_shardId = true && that.isSetShardId();
    if (this_present_shardId || that_present_shardId) {
      if (!(this_present_shardId && that_present_shardId))
        return false;
      if (!this.shardId.equals(that.shardId))
        return false;
    }

    boolean this_present_attributes = true && this.isSetAttributes();
    boolean that_present_attributes = true && that.isSetAttributes();
    if (this_present_attributes || that_present_attributes) {
      if (!(this_present_attributes && that_present_attributes))
        return false;
      if (!this.attributes.equals(that.attributes))
        return false;
    }

    boolean this_present_accounting = true && this.isSetAccounting();
    boolean that_present_accounting = true && that.isSetAccounting();
    if (this_present_accounting || that_present_accounting) {
      if (!(this_present_accounting && that_present_accounting))
        return false;
      if (!this.accounting.equals(that.accounting))
        return false;
    }

    return true;
  }

  public int hashCode() {
    return 0;
  }

  public int compareTo(User other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;
    User typedOther = (User)other;

    lastComparison = Boolean.valueOf(isSetId()).compareTo(isSetId());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(id, typedOther.id);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetUsername()).compareTo(isSetUsername());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(username, typedOther.username);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetEmail()).compareTo(isSetEmail());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(email, typedOther.email);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetName()).compareTo(isSetName());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(name, typedOther.name);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetTimezone()).compareTo(isSetTimezone());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(timezone, typedOther.timezone);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetPrivilege()).compareTo(isSetPrivilege());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(privilege, typedOther.privilege);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetCreated()).compareTo(isSetCreated());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(created, typedOther.created);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetUpdated()).compareTo(isSetUpdated());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(updated, typedOther.updated);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetDeleted()).compareTo(isSetDeleted());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(deleted, typedOther.deleted);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetActive()).compareTo(isSetActive());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(active, typedOther.active);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetShardId()).compareTo(isSetShardId());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(shardId, typedOther.shardId);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetAttributes()).compareTo(isSetAttributes());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(attributes, typedOther.attributes);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetAccounting()).compareTo(isSetAccounting());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(accounting, typedOther.accounting);
    if (lastComparison != 0) {
      return lastComparison;
    }
    return 0;
  }

  public void read(TProtocol iprot) throws TException {
    TField field;
    iprot.readStructBegin();
    while (true)
    {
      field = iprot.readFieldBegin();
      if (field.type == TType.STOP) { 
        break;
      }
      _Fields fieldId = _Fields.findByThriftId(field.id);
      if (fieldId == null) {
        TProtocolUtil.skip(iprot, field.type);
      } else {
        switch (fieldId) {
          case ID:
            if (field.type == TType.I32) {
              this.id = iprot.readI32();
              setIdIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case USERNAME:
            if (field.type == TType.STRING) {
              this.username = iprot.readString();
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case EMAIL:
            if (field.type == TType.STRING) {
              this.email = iprot.readString();
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case NAME:
            if (field.type == TType.STRING) {
              this.name = iprot.readString();
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case TIMEZONE:
            if (field.type == TType.STRING) {
              this.timezone = iprot.readString();
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case PRIVILEGE:
            if (field.type == TType.I32) {
              this.privilege = PrivilegeLevel.findByValue(iprot.readI32());
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case CREATED:
            if (field.type == TType.I64) {
              this.created = iprot.readI64();
              setCreatedIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case UPDATED:
            if (field.type == TType.I64) {
              this.updated = iprot.readI64();
              setUpdatedIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case DELETED:
            if (field.type == TType.I64) {
              this.deleted = iprot.readI64();
              setDeletedIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case ACTIVE:
            if (field.type == TType.BOOL) {
              this.active = iprot.readBool();
              setActiveIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case SHARD_ID:
            if (field.type == TType.STRING) {
              this.shardId = iprot.readString();
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case ATTRIBUTES:
            if (field.type == TType.STRUCT) {
              this.attributes = new UserAttributes();
              this.attributes.read(iprot);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case ACCOUNTING:
            if (field.type == TType.STRUCT) {
              this.accounting = new Accounting();
              this.accounting.read(iprot);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
        }
        iprot.readFieldEnd();
      }
    }
    iprot.readStructEnd();
    validate();
  }

  public void write(TProtocol oprot) throws TException {
    validate();

    oprot.writeStructBegin(STRUCT_DESC);
    if (isSetId()) {
      oprot.writeFieldBegin(ID_FIELD_DESC);
      oprot.writeI32(this.id);
      oprot.writeFieldEnd();
    }
    if (this.username != null) {
      if (isSetUsername()) {
        oprot.writeFieldBegin(USERNAME_FIELD_DESC);
        oprot.writeString(this.username);
        oprot.writeFieldEnd();
      }
    }
    if (this.email != null) {
      if (isSetEmail()) {
        oprot.writeFieldBegin(EMAIL_FIELD_DESC);
        oprot.writeString(this.email);
        oprot.writeFieldEnd();
      }
    }
    if (this.name != null) {
      if (isSetName()) {
        oprot.writeFieldBegin(NAME_FIELD_DESC);
        oprot.writeString(this.name);
        oprot.writeFieldEnd();
      }
    }
    if (this.timezone != null) {
      if (isSetTimezone()) {
        oprot.writeFieldBegin(TIMEZONE_FIELD_DESC);
        oprot.writeString(this.timezone);
        oprot.writeFieldEnd();
      }
    }
    if (this.privilege != null) {
      if (isSetPrivilege()) {
        oprot.writeFieldBegin(PRIVILEGE_FIELD_DESC);
        oprot.writeI32(this.privilege.getValue());
        oprot.writeFieldEnd();
      }
    }
    if (isSetCreated()) {
      oprot.writeFieldBegin(CREATED_FIELD_DESC);
      oprot.writeI64(this.created);
      oprot.writeFieldEnd();
    }
    if (isSetUpdated()) {
      oprot.writeFieldBegin(UPDATED_FIELD_DESC);
      oprot.writeI64(this.updated);
      oprot.writeFieldEnd();
    }
    if (isSetDeleted()) {
      oprot.writeFieldBegin(DELETED_FIELD_DESC);
      oprot.writeI64(this.deleted);
      oprot.writeFieldEnd();
    }
    if (isSetActive()) {
      oprot.writeFieldBegin(ACTIVE_FIELD_DESC);
      oprot.writeBool(this.active);
      oprot.writeFieldEnd();
    }
    if (this.shardId != null) {
      if (isSetShardId()) {
        oprot.writeFieldBegin(SHARD_ID_FIELD_DESC);
        oprot.writeString(this.shardId);
        oprot.writeFieldEnd();
      }
    }
    if (this.attributes != null) {
      if (isSetAttributes()) {
        oprot.writeFieldBegin(ATTRIBUTES_FIELD_DESC);
        this.attributes.write(oprot);
        oprot.writeFieldEnd();
      }
    }
    if (this.accounting != null) {
      if (isSetAccounting()) {
        oprot.writeFieldBegin(ACCOUNTING_FIELD_DESC);
        this.accounting.write(oprot);
        oprot.writeFieldEnd();
      }
    }
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  public String toString() {
    StringBuilder sb = new StringBuilder("User(");
    boolean first = true;

    if (isSetId()) {
      sb.append("id:");
      sb.append(this.id);
      first = false;
    }
    if (isSetUsername()) {
      if (!first) sb.append(", ");
      sb.append("username:");
      if (this.username == null) {
        sb.append("null");
      } else {
        sb.append(this.username);
      }
      first = false;
    }
    if (isSetEmail()) {
      if (!first) sb.append(", ");
      sb.append("email:");
      if (this.email == null) {
        sb.append("null");
      } else {
        sb.append(this.email);
      }
      first = false;
    }
    if (isSetName()) {
      if (!first) sb.append(", ");
      sb.append("name:");
      if (this.name == null) {
        sb.append("null");
      } else {
        sb.append(this.name);
      }
      first = false;
    }
    if (isSetTimezone()) {
      if (!first) sb.append(", ");
      sb.append("timezone:");
      if (this.timezone == null) {
        sb.append("null");
      } else {
        sb.append(this.timezone);
      }
      first = false;
    }
    if (isSetPrivilege()) {
      if (!first) sb.append(", ");
      sb.append("privilege:");
      if (this.privilege == null) {
        sb.append("null");
      } else {
        String privilege_name = privilege.name();
        if (privilege_name != null) {
          sb.append(privilege_name);
          sb.append(" (");
        }
        sb.append(this.privilege);
        if (privilege_name != null) {
          sb.append(")");
        }
      }
      first = false;
    }
    if (isSetCreated()) {
      if (!first) sb.append(", ");
      sb.append("created:");
      sb.append(this.created);
      first = false;
    }
    if (isSetUpdated()) {
      if (!first) sb.append(", ");
      sb.append("updated:");
      sb.append(this.updated);
      first = false;
    }
    if (isSetDeleted()) {
      if (!first) sb.append(", ");
      sb.append("deleted:");
      sb.append(this.deleted);
      first = false;
    }
    if (isSetActive()) {
      if (!first) sb.append(", ");
      sb.append("active:");
      sb.append(this.active);
      first = false;
    }
    if (isSetShardId()) {
      if (!first) sb.append(", ");
      sb.append("shardId:");
      if (this.shardId == null) {
        sb.append("null");
      } else {
        sb.append(this.shardId);
      }
      first = false;
    }
    if (isSetAttributes()) {
      if (!first) sb.append(", ");
      sb.append("attributes:");
      if (this.attributes == null) {
        sb.append("null");
      } else {
        sb.append(this.attributes);
      }
      first = false;
    }
    if (isSetAccounting()) {
      if (!first) sb.append(", ");
      sb.append("accounting:");
      if (this.accounting == null) {
        sb.append("null");
      } else {
        sb.append(this.accounting);
      }
      first = false;
    }
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws TException {
    // check for required fields
  }

}

