#include "stdafx.h"
#include "Document.h"
#include "MessageMapMacro.h"
#include "CommandHandler.h"
#include "FileCommandHandler.h"
#include "EditCommandHandler.h"
#include "ViewCommandHandler.h"

/*
	VR}hnh쐬ꍇ́A
	ɂ̃NX̐錾Lqꂽwb_CN[h
	(CommandHandler::Impl::Impl())list_ɂ̃R}hnh
	@ǉ鏈LqĂB
*/

class CommandHandler::Impl
{
public:
	Impl();

	BOOL ProcessWindowMessage(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID = 0);

	void SetDocument(Document_ptr doc);
	void SetWindow(HWND hWnd);

	//qnh̃CX^X
	typedef boost::shared_ptr<CommandHandlerBase> Handler_ptr;
	std::vector<Handler_ptr> list_; 
};

CommandHandler::Impl::Impl()
{
	//qR}hnho^
	list_.push_back(Handler_ptr( new FileCommandHandler ));	//ut@Cvj[
	list_.push_back(Handler_ptr( new EditCommandHandler ));	//uҏWvj[
	list_.push_back(Handler_ptr( new ViewCommandHandler )); //u\vj[
	//VR}hnh쐬炱ɒǉ
}

void CommandHandler::Impl::SetDocument(Document_ptr doc)
{
	//qR}hnhDocumentւ̃|C^Zbg
	for(std::vector<Handler_ptr>::iterator it=list_.begin(); it!=list_.end(); ++it){
		(*it)->SetDocument(doc);
	}
}

void CommandHandler::Impl::SetWindow(HWND hWnd)
{
	//qR}hnhփEBhẼnhZbg
	for(std::vector<Handler_ptr>::iterator it=list_.begin(); it!=list_.end(); ++it){
		(*it)->SetWindow(hWnd);
	}
}

//qR}hnh֔sꂽR}h]
BEGIN_MSG_MAP_IMPL(CommandHandler::Impl)
	for(std::vector<Impl::Handler_ptr>::iterator it=list_.begin(); it!=list_.end(); ++it){
		CHAIN_MSG_MAP_MEMBER_PTR((*it))
	}
END_MSG_MAP_IMPL()



BEGIN_MSG_MAP_IMPL(CommandHandler)
	MESSAGE_HANDLER(WM_COMMAND,OnCommand)
	CHAIN_MSG_MAP_MEMBER_PTR(pimpl_)
END_MSG_MAP_IMPL()

CommandHandler::CommandHandler()
	: pimpl_(new Impl())
{
}

void CommandHandler::SetDocument(Document_ptr doc)
{
	CommandHandlerBase::SetDocument(doc);
	pimpl_->SetDocument(doc);
}

void CommandHandler::SetWindow(HWND hWnd)
{
	CommandHandlerBase::SetWindow(hWnd);
	pimpl_->SetWindow(hWnd);
}

LRESULT CommandHandler::Command(ulong id)
{
	LRESULT ret;
	ProcessWindowMessage(NULL,WM_COMMAND,id,0,ret);
	return ret;
}

LRESULT CommandHandler::OnCommand(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	uMsg;
	wParam;
	lParam;

	//R}hsꂽĂ΂
	bHandled = FALSE;

	//͒~
	doc_->GetInputInfo()->Reset();

	return 0;
}

void ICommander::SetCommandHandler(CommandHandler_ptr handler)
{
	handler_ = handler;
}

CommandHandler_ptr ICommander::GetCommandHandler() const
{
	return handler_;
}
