#include "stdafx.h"
#include "CursorInfo.h"

CursorInfo::CursorInfo()
	: enable_(false), position_(0), anchor_(0), enableanchor_(false)
{
}

CursorInfo::CursorInfo( ulong position )
	: enable_(true), position_(position), anchor_(0), enableanchor_(false) 
{
}

CursorInfo::CursorInfo( ulong anchor, ulong position )
    : enable_(true), position_(position), anchor_(anchor)
{
}

void CursorInfo::Enable( bool enable )
{
	enable_ = enable;
}

bool CursorInfo::IsEnable() const
{
	return enable_;
}

void CursorInfo::SetPosition( ulong position )
{
	position_ = position;
}

ulong CursorInfo::GetPosition( ) const
{
	return position_;
}

void CursorInfo::SetAnchor( ulong anchor )
{
	anchor_ = anchor;
}

ulong CursorInfo::GetAnchor( ) const
{
	return anchor_;
}

void CursorInfo::EnableAnchor( bool enable )
{
	enableanchor_ = enable;
}

bool CursorInfo::IsEnableAnchor( ) const
{
	return enableanchor_;
}

ulong CursorInfo::GetLength() const
{
	ulong start,end;
	if(IsEnableAnchor()){
		GetRange(start,end);
		return end-start+1;
	}else{
		return 0;
	}
}

ulong CursorInfo::GetStart() const
{
	if(IsEnableAnchor()){
		if(anchor_>position_){
			return position_;
		}else{
			return anchor_;
		}
	}else{
		return position_;
	}
}

ulong CursorInfo::GetEnd() const
{
	if(IsEnableAnchor()){
		if(anchor_<position_){
			return position_;
		}else{
			return anchor_;
		}
	}else{
		return position_;
	}
}

void CursorInfo::GetRange( ulong& start, ulong& end ) const
{
	if(IsEnableAnchor()){
		if(anchor_>position_){
			start = position_;
			end = anchor_;
		}else{
			start = anchor_;
			end = position_;
		}
	}else{
		start = position_;
		end = position_;
	}
}
