#pragma once

/*
	CursorInfo

	J[\E͈͑ȈNX

	J[\֘ȀԂƂĂ͈ȉ3ނ
	EJ[\\ (J[\Ȃ킿wȂ)
	EJ[\\   (J[\͗LAʒu)
	E͈͑I       (J[\͗LŁA͈͂Ă)

	J[\\ǂEnable()==falseŔ肷
	J[\\ǂEnableAnchor()==falseŔ肷
	͈͑IǂEnableAnchor()==trueŔ肷

	J[\̈ʒuGetPosition()Ŏ擾
	͈͑I̊Jn_GetAnchor()ŁAI_GetPosition()Ŏ擾

*/
class CursorInfo
{
public:
	CursorInfo();
	CursorInfo( ulong position );
	CursorInfo( ulong anchor, ulong position);

	//J[\LݒE擾
	void Enable( bool enable );
	bool IsEnable() const;

	//J[\ʒu܂͑I͈͂̏I_ݒ
	void SetPosition( ulong position );
	ulong GetPosition( ) const;

	//I͈͂̊Jn_ݒ
	void SetAnchor( ulong anchor );
	ulong GetAnchor( ) const;
	
	//ԂJ[\\͈͑IݒE擾
	void EnableAnchor( bool enable );
	bool IsEnableAnchor() const;

	//I͈͂̒擾
	ulong GetLength() const;

	//I͈͂擾(start<=endۏ؂)
	ulong GetStart() const;
	ulong GetEnd() const;
	void GetRange( ulong& start, ulong& end ) const; //Ɏ擾

private:
	bool enable_;			//J[\̂L
	bool enableanchor_;		//I͈͂L
							//true:anchorpositionŕ\͈
							//false:positionPƑI
	ulong position_;		//͈͑ȈI_
	ulong anchor_;			//͈͑I̋N_
};

typedef boost::shared_ptr<CursorInfo> Cursor_ptr;
