#include "stdafx.h"
#include "DropTarget.h"

FileDropTarget::FileDropTarget()
	: dataobject_(0)
{
}

void FileDropTarget::SetCallBack(callbackobject& callback)
{
	callback_ = callback;
}

//IDropTarget
HRESULT STDMETHODCALLTYPE FileDropTarget::DragEnter( 
	/* [unique][in] */ IDataObject *pDataObj,
	/* [in] */ DWORD grfKeyState,
	/* [in] */ POINTL pt,
	/* [out][in] */ DWORD *pdwEffect)
{
	grfKeyState;
	pt;

	dataobject_ = pDataObj;

	if(pdwEffect && CheckFormat()){
		*pdwEffect = DROPEFFECT_COPY;
	}else{
		dataobject_ = 0;
	}
	return S_OK;
}
    
HRESULT STDMETHODCALLTYPE FileDropTarget::DragOver( 
    /* [in] */ DWORD grfKeyState,
    /* [in] */ POINTL pt,
    /* [out][in] */ DWORD *pdwEffect)
{
	grfKeyState;
	pt;

	if(pdwEffect && dataobject_){
		*pdwEffect = DROPEFFECT_COPY;
	}
	return S_OK;
}

HRESULT STDMETHODCALLTYPE FileDropTarget::DragLeave(void)
{
	dataobject_ = 0;
	return S_OK;
}

HRESULT STDMETHODCALLTYPE FileDropTarget::Drop( 
    /* [unique][in] */ IDataObject *pDataObj,
    /* [in] */ DWORD grfKeyState,
    /* [in] */ POINTL pt,
    /* [out][in] */ DWORD *pdwEffect)
{
	pDataObj;
	grfKeyState;
	pt;

	dataobject_ = pDataObj;
	
	if(pdwEffect && CheckFormat()){
		*pdwEffect = DROPEFFECT_COPY;

		std::vector<std::string> files = GetData();
		if(files.size()){
			callback_(files[0]);
		}
	}

	return S_OK;
}

bool FileDropTarget::CheckFormat()
{
	FORMATETC format;

	format.cfFormat = CF_HDROP;
    format.ptd = NULL;
    format.dwAspect = DVASPECT_CONTENT;
    format.lindex = -1;
    format.tymed = TYMED_HGLOBAL;

	return SUCCEEDED(dataobject_->QueryGetData(&format)); 
}

std::vector<std::string> FileDropTarget::GetData()
{
	std::vector<std::string> files;

	FORMATETC format;
	format.cfFormat = CF_HDROP;
    format.ptd = NULL;
    format.dwAspect = DVASPECT_CONTENT;
    format.lindex = -1;
    format.tymed = TYMED_HGLOBAL;
	STGMEDIUM medium;

	if(SUCCEEDED(dataobject_->GetData(&format,&medium))){
		HDROP drop = static_cast<HDROP>(medium.hGlobal);
		UINT count = DragQueryFile(drop,static_cast<UINT>(-1),NULL,0);
		char filepath[MAX_PATH];
		for(UINT i=0; i<count; i++){
			DragQueryFile(drop,i,filepath,MAX_PATH);
			files.push_back(filepath);
		}
	}

	return files;
}
