#pragma once

#include <atlcom.h>
#include <boost/function.hpp>

class ATL_NO_VTABLE FileDropTarget :
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<FileDropTarget>,
	public IDropTarget
{
public:

	DECLARE_CLASSFACTORY()

	BEGIN_COM_MAP(FileDropTarget)
		COM_INTERFACE_ENTRY(IDropTarget)
	END_COM_MAP()

	typedef boost::function<void (const std::string&)> callbackobject;

	FileDropTarget();
	void SetCallBack(callbackobject& callback);

	//IDropTarget
	HRESULT STDMETHODCALLTYPE DragEnter( 
		/* [unique][in] */ IDataObject *pDataObj,
		/* [in] */ DWORD grfKeyState,
		/* [in] */ POINTL pt,
		/* [out][in] */ DWORD *pdwEffect);
        
    HRESULT STDMETHODCALLTYPE DragOver( 
        /* [in] */ DWORD grfKeyState,
        /* [in] */ POINTL pt,
        /* [out][in] */ DWORD *pdwEffect);
    
    HRESULT STDMETHODCALLTYPE DragLeave( void);
    
    HRESULT STDMETHODCALLTYPE Drop( 
        /* [unique][in] */ IDataObject *pDataObj,
        /* [in] */ DWORD grfKeyState,
        /* [in] */ POINTL pt,
        /* [out][in] */ DWORD *pdwEffect);

private:
	callbackobject callback_;
	IDataObject *dataobject_;

	bool CheckFormat();
	std::vector<std::string> GetData();
};