#include "stdafx.h"
#include "EditAction.h"
#include "Document.h"

//InsertAction
class InsertAction::Impl
{
public:
	Impl(Document *document, MemoryBlock memory, ulong offset);
	bool UndoAction(IBuffer* buffer);
	bool RedoAction(IBuffer* buffer);

private:
	Document *doc_;
	MemoryBlock memory_;
	ulong offset_;
	CursorInfo cursor_; //TODO : ???ʂ ؂̂폜
};

InsertAction::Impl::Impl(Document *document, MemoryBlock memory, ulong offset)
	: doc_(document), memory_(memory), offset_(offset)
{
	cursor_ = *document->GetCursor();
}

bool InsertAction::Impl::UndoAction(IBuffer* buffer)
{
	bool succeed = buffer->Remove(offset_,memory_.size);

	if(succeed){
		*doc_->GetCursor() = cursor_;
	}

	return succeed;
}

bool InsertAction::Impl::RedoAction(IBuffer* buffer)
{
	bool succeed = buffer->Insert(offset_,memory_.size,memory_.data.get());

	if(succeed){
		doc_->GetCursor()->SetPosition(offset_);
		doc_->GetCursor()->SetAnchor(offset_);
	}

	doc_->NotifyRefresh();

	return succeed;
}


InsertAction::InsertAction(Document *document, MemoryBlock memory, ulong offset)
{
	pimpl_ = boost::shared_ptr<Impl>(new Impl(document,memory,offset));
}

bool InsertAction::UndoAction(IBuffer *buffer)
{
	return pimpl_->UndoAction(buffer);
}

bool InsertAction::RedoAction(IBuffer *buffer)
{
	return pimpl_->RedoAction(buffer);
}




class RemoveAction::Impl
{
public:
	Impl(Document *document);
	bool UndoAction(IBuffer* buffer);
	bool RedoAction(IBuffer* buffer);

private:
	Document *doc_;
	MemoryBlock memory_;
	ulong offset_;
	CursorInfo cursor_;
};

RemoveAction::Impl::Impl(Document *document)
	: doc_(document)
{
	offset_ = doc_->GetCursor()->GetStart();
	ulong size = doc_->GetCursor()->GetLength();

	if(size==0 && offset_!=document->Size()){
		size = 1;
	}

	MemoryData data(new uchar[size]);
	memory_ = MemoryBlock(data,size);
	doc_->Read(offset_,size,memory_.data.get());
}

bool RemoveAction::Impl::UndoAction(IBuffer* buffer)
{
	return buffer->Insert(offset_,memory_.size,memory_.data.get());
}

bool RemoveAction::Impl::RedoAction(IBuffer* buffer)
{
	return buffer->Remove(offset_,memory_.size);
}

RemoveAction::RemoveAction(Document *document)
{
	pimpl_ = boost::shared_ptr<Impl>(new Impl(document));
}

bool RemoveAction::UndoAction(IBuffer* buffer)
{
	return pimpl_->UndoAction(buffer);
}

bool RemoveAction::RedoAction(IBuffer* buffer)
{
	return pimpl_->RedoAction(buffer);
}






class OverStrikeAction::Impl
{
public:
	Impl(Document *document, MemoryBlock memory, ulong offset);
	bool UndoAction(IBuffer* buffer);
	bool RedoAction(IBuffer* buffer);

private:
	Document *doc_;
	MemoryBlock memory_;
	ulong offset_;
};

OverStrikeAction::Impl::Impl(Document *document, MemoryBlock memory, ulong offset)
	 : doc_(document), memory_(memory), offset_(offset)
{
}

bool OverStrikeAction::Impl::UndoAction(IBuffer* buffer)
{
	MemoryBlock forward(MemoryData(new uchar[memory_.size]),memory_.size);
	buffer->Get(offset_,forward.size,forward.data.get());

	bool succeed = buffer->OverStrike(offset_,memory_.size,memory_.data.get());

	if(succeed){
		memory_ = forward;
	}

	return true;
}

bool OverStrikeAction::Impl::RedoAction(IBuffer* buffer)
{
	MemoryBlock backward(MemoryData(new uchar[memory_.size]),memory_.size);
	buffer->Get(offset_,backward.size,backward.data.get());

	bool succeed = buffer->OverStrike(offset_,memory_.size,memory_.data.get());

	if(succeed){
		memory_ = backward;
	}

	return true;
}

OverStrikeAction::OverStrikeAction(Document *document, MemoryBlock memory, ulong offset)
{
	pimpl_ = boost::shared_ptr<Impl>(new Impl(document,memory,offset));
}

bool OverStrikeAction::UndoAction(IBuffer* buffer)
{
	return pimpl_->UndoAction(buffer);
}

bool OverStrikeAction::RedoAction(IBuffer* buffer)
{
	return pimpl_->RedoAction(buffer);
}







class CursorAction::Impl
{
public:
	Impl(Document* document, const CursorInfo& newposition);
	bool UndoAction(IBuffer* buffer);
	bool RedoAction(IBuffer* buffer);

private:
	Document* doc_;
	CursorInfo pos_;
};

CursorAction::Impl::Impl(Document* document, const CursorInfo& newposition)
	: doc_(document), pos_(newposition)
{
}

bool CursorAction::Impl::UndoAction(IBuffer* /*buffer*/)
{
	CursorInfo current = *doc_->GetCursor();
	*doc_->GetCursor() = pos_;
	pos_ = current;
	return true;
}

bool CursorAction::Impl::RedoAction(IBuffer* /*buffer*/)
{
	CursorInfo current = *doc_->GetCursor();
	*doc_->GetCursor() = pos_;
	pos_ = current;
	return true;
}

CursorAction::CursorAction(Document* document, const CursorInfo& newposition)
{
	pimpl_ = boost::shared_ptr<Impl>(new Impl(document,newposition));
}

bool CursorAction::UndoAction(IBuffer* buffer)
{
	return pimpl_->UndoAction(buffer);
}

bool CursorAction::RedoAction(IBuffer* buffer)
{
	return pimpl_->RedoAction(buffer);
}
