#include "stdafx.h"
#include "EditCommandHandler.h"
#include "EditAction.h"
#include "Undo.h"
#include "ClipBoard.h"

LRESULT EditCommandHandler::OnEditUndo(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	doc_->Undo();
	doc_->NotifyRefresh();
	return 0;
}

LRESULT EditCommandHandler::OnEditRedo(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	doc_->Redo();
	doc_->NotifyRefresh();
	return 0;
}

LRESULT EditCommandHandler::OnEditCut(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	Copy();
	Remove();
	return 0;
}

LRESULT EditCommandHandler::OnEditCopy(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	Copy();
	return 0;
}

LRESULT EditCommandHandler::OnEditPaste(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	ulong start = doc_->GetCursor()->GetStart();
	ulong size = doc_->GetCursor()->GetLength();
	MemoryBlock memory = ClipBoardManager::GetInstance()->Get();
	CursorInfo newposition(start);

	ActionList list;

	//I͈͂̃f[^͍폜
	if(size){
		list.push_back(Action_ptr(new RemoveAction(doc_.get())));
	}

	//J[\Iʒuɑ}
	list.push_back(Action_ptr(new InsertAction(doc_.get(),memory,start)));
	list.push_back(Action_ptr(new CursorAction(doc_.get(),newposition)));

	doc_->DoAction(list);

	doc_->NotifyReconstruct();	

	return 0;
}

LRESULT EditCommandHandler::OnEditClear(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	Remove();
	return 0;
}

void EditCommandHandler::OnUIUpdateEditUndo( CUIItem& item )
{
	item.SetEnable(doc_->CanUndo());
}

void EditCommandHandler::OnUIUpdateEditRedo( CUIItem& item )
{
	item.SetEnable(doc_->CanRedo());
}

void EditCommandHandler::OnUIUpdateEditCut( CUIItem& item )
{
	item.SetEnable(CheckInDataRange(doc_) && doc_->GetCursor()->GetLength());
}

void EditCommandHandler::OnUIUpdateEditCopy( CUIItem& item )
{
	item.SetEnable(CheckInDataRange(doc_) && doc_->GetCursor()->GetLength());
}

void EditCommandHandler::OnUIUpdateEditPaste( CUIItem& item )
{
	item.SetEnable(CheckInEditRange(doc_) && !ClipBoardManager::GetInstance()->IsEmpty());
}

void EditCommandHandler::OnUIUpdateEditClear( CUIItem& item )
{
	item.SetEnable(CheckInDataRange(doc_) && doc_->GetCursor()->GetLength());
}

void EditCommandHandler::Remove()
{
	//폜̎

	if(!CheckInDataRange(doc_)) return;

	//͈͑Ȉꍇ͈͂̔͂AłȂꍇ̓J[\̍ڂ폜
	ulong length = doc_->GetCursor()->GetLength();
	if(length==0){
		//TODO : tH[}bgɏ]oCg폜悤ɏC
		length = 1;
	}

	//(폜ANVƃJ[\ݒANV)AhD}l[W֓o^
	ulong start = doc_->GetCursor()->GetStart();
	CursorInfo newposition(start);
	
	ActionList list;
	list.push_back(Action_ptr(new RemoveAction(doc_.get())));
	list.push_back(Action_ptr(new CursorAction(doc_.get(),newposition)));
	doc_->DoAction(list);

	doc_->NotifyReconstruct();	
}

void EditCommandHandler::Copy()
{
	//I͈͂̃f[^Nbv{[hփRs[

	Cursor_ptr cursor = doc_->GetCursor();
	ulong start = cursor->GetStart();
	ulong size = cursor->GetLength();

	MemoryBlock memory(MemoryData(new uchar[size]),size);
	if(doc_->Read(start,size,memory.data.get())){
		ClipBoardManager::GetInstance()->Set(memory);
	}
}
