// ExBinView.cpp : implementation of the CExBinView class
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include "ExBinView.h"
#include "Document.h"
#include "EditAction.h"
#include <boost/lexical_cast.hpp>
#include <boost/scoped_array.hpp>
#include <boost/optional.hpp>
#include <boost/bind.hpp>
#include "FileCommand.h"
#include "Utility.h"

//TODO : IvVNX쐬
const COLORREF mainarea_backgroundcolor = RGB(255,255,255);
const COLORREF mainarea_textcolor = RGB(0,0,0);
const COLORREF mainarea_singlecursorcolor = RGB(0,255,255);
const COLORREF mainarea_multicursorcolor = RGB(255,0,255);


CExBinView::CExBinView()
	: timerid_(0)
{
}

BOOL CExBinView::PreTranslateMessage(MSG* pMsg)
{
	pMsg;
	return FALSE;
}

LRESULT CExBinView::OnCreate(LPCREATESTRUCT /*lpCreateStruct*/)
{
	::OleInitialize(0);

	IDropTarget* p;
	FileDropTarget::CreateInstance(&p);
	droptarget_.Attach(p);
	RegisterDragDrop(m_hWnd,droptarget_.p);

	FileDropTarget::callbackobject callback =
		boost::bind(&CExBinView::OnFileDrop, this , _1);
	FileDropTarget *target = dynamic_cast<FileDropTarget*>(p);
	target->SetCallBack(callback);

	ResetTimer();

	return 0;
}

void CExBinView::OnDestroy()
{
	::OleUninitialize();
}

void CExBinView::OnUpdate(IDocumentEventListener::EventType type)
{
	//ʂ̍XV
	if(type==IDocumentEventListener::Reconstruction){
		//hLgč\zꂽ̂ŃXN[o[S̍č\
		CRect clientrect;
		GetClientRect(&clientrect);
		CSize clientsize(clientrect.Width(),clientrect.Height());
		ResetInnerData(clientsize);
	}
	Refresh();
}

void CExBinView::Refresh()
{
	//XN[ԍXVƍĕ`
	ulong rowindex = doc_->GetScroll()->GetRowIndex();
	ulong columnindex = doc_->GetScroll()->GetColumnIndex();

	ulong maxrowindex = GetVMaxScroll();
	ulong maxcolumnindex = GetHMaxScroll();

	//͈͐
	rowindex = (rowindex<maxrowindex)?rowindex:maxrowindex;
	columnindex = (columnindex<maxcolumnindex)?columnindex:maxcolumnindex;
	doc_->GetScroll()->SetRowIndex(rowindex);
	doc_->GetScroll()->SetColumnIndex(columnindex);

	//XV
	SetVScrollPos(rowindex);
	SetHScrollPos(columnindex);

	//^C}[Đݒ
	ResetTimer();

	UpdateStatusBar();

	Invalidate();
}

void CExBinView::ResetInnerData(const CSize& size)
{
	//`vf̍XV
	UpdateDrawInfo(size);

	//XN[̗}
	CheckVOffset();
	CheckHOffset();

	//XN[o[̍XV
	SetupScrollBar();
}

HFONT CExBinView::MakeFont()
{
	CFontHandle font;
	font.CreatePointFont(120,"lr SVbN");
	return font.m_hFont;
}

void CExBinView::ResetTimer()
{
	const int id = 1;

	if(!doc_->GetCursor()->IsEnableAnchor()){
		cursorblink_ = false;
		timerid_ = SetTimer(id, GetCaretBlinkTime(), NULL);
	}else{
		if(timerid_){
			KillTimer(timerid_);
			timerid_ = 0;
		}
	}
}

void CExBinView::DoPaint(CDCHandle dc)
{
	//`ݒ
	int oldmode = dc.SetBkMode(TRANSPARENT);
	CFont font(MakeFont());
	HFONT oldfont = dc.SelectFont(font);

	//wb_̈`
	DrawHeaderArea(dc);

	//AhẌ`
	DrawAddressArea(dc);

	//C̈`
	DrawMainArea(dc);

	//`ݒ
	dc.SelectFont(oldfont);
	dc.SetBkMode(oldmode);
}

void CExBinView::DrawMainArea(CDCHandle& dc)
{
	const ulong rowindex = doc_->GetScroll()->GetRowIndex();
	const ulong columnindex = doc_->GetScroll()->GetColumnIndex();
	const CSize& charactersize = drawinfo_.visual.charactersize;
	const CRect& mainarea_margin = drawinfo_.visual.mainarea_margin;
	const CRect& mainarea = drawinfo_.visual.mainarea;

	const COLORREF& backgroundcolor = mainarea_backgroundcolor;
	const COLORREF& textcolor = mainarea_textcolor;
	const COLORREF& cursor_single_color = mainarea_singlecursorcolor;
	const COLORREF& cursor_multi_color = mainarea_multicursorcolor;

	ulong rowcount = GetRowCount();
	ulong visiblerowcount = GetVisibleRowCount();

	bool cursor_visible = CheckInEditRange(doc_);
	bool cursor_multiselect = doc_->GetCursor()->IsEnableAnchor();

	ulong cursor_start, cursor_end;
	if(cursor_multiselect){
		doc_->GetCursor()->GetRange(cursor_start,cursor_end);
	}else{
		cursor_start = cursor_end = doc_->GetCursor()->GetPosition();
	}
	
	dc.SetTextColor(textcolor);
	DrawRect(dc,mainarea_margin,backgroundcolor);

	for(ulong y=0; y<visiblerowcount; y++){
		if(rowindex+y>=rowcount) break;
		LineFormat_ptr lineformat = doc_->GetFormat()->GetLine(rowindex+y);

		for( std::vector<ItemFormat>::const_iterator it=lineformat->items.begin(); it!=lineformat->items.end(); ++it){
			ulong ix = it->offset;	//ڑŜ̊Jnʒu
			ulong il = it->size;	//ڑŜ̃TCY
			ulong cx = 0;			//ړJ[\̈̊Jnʒu
			ulong cl = 0;			//ړJ[\̈̃TCY
			bool draw_cursor = false;

			//J[\̈̎Z
			if(cursor_visible){
				if(cursor_start==cursor_end && cursor_start==it->index){
					//PoCgI
					cx = it->offset+it->bodyoffset;
					cl = it->bodysize;
					draw_cursor = true;
				}else{
					if(cursor_start==it->index){
						//JnoCg(bodyȍ~)
						cx = it->offset+it->bodyoffset;
						cl = it->size-it->bodyoffset;
						draw_cursor = true;
					}else if(cursor_start<it->index && it->index<cursor_end){
						//ԃoCg(S)
						cx = it->offset;
						cl = it->size;
						draw_cursor = true;
					}else if(it->index==cursor_end){
						//ŏIoCg(bodyȑO)
						cx = it->offset;
						cl = it->bodyoffset+it->bodysize;
						draw_cursor = true;
					}
				}
			}

			//XN[␳(ڑS)
			if(columnindex>=ix+il){
				//XN[ŉʏɂ͕\Ȃ
				continue;
			}else if(columnindex>ix){
				//XN[ňꕔ͂ݏoĂ
				il = il+ix-columnindex;
				ix = columnindex;
			}

			//XN[␳(J[\)
			if(draw_cursor){
				if(columnindex>=cx+cl){
					continue;
				}else if(columnindex>cx){
					cl = cl+cx-columnindex;
					cx = columnindex;
				}
			}

			//`
			std::string text = lineformat->text.substr(ix,il);
			int px = mainarea.left+(ix-columnindex)*charactersize.cx;
			int py = mainarea.top+y*charactersize.cy;
			int pw = cl*charactersize.cx;
			int ph = charactersize.cy;
			
			if(draw_cursor){
				CRect textrect(px,py,px+pw,py+ph);
				if(cursor_multiselect){
					DrawRect(dc,textrect,cursor_multi_color);
				}else{
					DrawRect(dc,textrect,cursor_single_color);
				}
			}
			dc.TextOutA(px,py,text.c_str());
		}
	}
}

void CExBinView::DrawAddressArea(CDCHandle& dc)
{
	const COLORREF backgroundcolor = RGB(0,0,0);
	const COLORREF textcolor = RGB(255,255,255);
	const COLORREF cursorbackcolor = RGB(0,255,255);
	const COLORREF cursortextcolor = RGB(0,0,0);

	const ulong rowindex = doc_->GetScroll()->GetRowIndex();
	const ulong addresscolumn = drawinfo_.visual.addresscolumn;
	const CSize& charactersize = drawinfo_.visual.charactersize;
	const CRect& addressarea_margin = drawinfo_.visual.addressarea_margin;
	const CRect& addressarea = drawinfo_.visual.addressarea;

	const ulong visiblerowcount = GetVisibleRowCount();
	const ulong rowcount = GetRowCount();

	ulong lx,ly;
	GetCursorPosition(lx,ly);
	bool cursor_visible = CheckInEditRange(doc_);

	DrawRect(dc,addressarea_margin,backgroundcolor);

	char str[20];
	dc.SetTextColor(textcolor);
	for(ulong y=0; y<visiblerowcount; y++){
		ulong i = rowindex+y;
		if(i>=rowcount) break;

		ulong address = doc_->GetFormat()->LineIndex2Offset(i);
		MakeAddressText(str,address,addresscolumn);
		int length = strlen(str);
		int px = addressarea.left;
		int py = addressarea.top+y*charactersize.cy;
		int pw = length*charactersize.cx;
		int ph = charactersize.cy;
		CRect cursorrect(px,py,px+pw,py+ph);
		
		if(i==ly && cursor_visible){
			COLORREF oldcolor = dc.SetTextColor(cursortextcolor);
			DrawBackground(dc,cursorrect,0,0,length,cursorbackcolor,false,false);
			dc.TextOutA(px,py,str);
			dc.SetTextColor(oldcolor);
		}else{
			dc.TextOutA(px,py,str);
		}
	}
}

void CExBinView::DrawHeaderArea(CDCHandle& dc)
{
	const COLORREF backgroundcolor = RGB(0,0,0);
	const COLORREF textcolor = RGB(255,255,255);
	const COLORREF cursorbackcolor = RGB(0,255,255);
	const COLORREF cursortextcolor = RGB(0,0,0);

	const ulong rowindex = doc_->GetScroll()->GetRowIndex();
	const ulong columnindex = doc_->GetScroll()->GetColumnIndex();
	const CRect& headerarea_margin = drawinfo_.visual.headerarea_margin;
	const CRect& headerarea = drawinfo_.visual.headerarea;

	LineFormat_ptr lineformat = doc_->GetFormat()->GetHeader(rowindex);

	int x = headerarea.left;
	int y = headerarea.top;
	DrawRect(dc,headerarea_margin,backgroundcolor);
	dc.SetTextColor(textcolor);
	dc.TextOutA(x,y,lineformat->text.c_str()+columnindex);

	//J[\ʒu`
	if(CheckInEditRange(doc_)){
		ulong lx,ly;
		GetCursorPosition(lx,ly);

		for(std::vector<ItemFormat>::const_iterator it=lineformat->items.begin(); it!=lineformat->items.end(); ++it){
			if(it->index == lx){
				ulong cx = it->offset + it->bodyoffset;
				ulong cl = it->bodysize;
				DrawBackground(dc, headerarea, cx, 0, cl, cursorbackcolor, true, false);

				std::string text = lineformat->text.substr(cx,cl);
				DrawString(dc,text,headerarea,cx,y,cl,cursortextcolor,true,false);
			}
		}
	}
}

void CExBinView::DrawRect(CDCHandle& dc, const CRect& rectangle, COLORREF color)
{
	CBrush brush;
	brush.CreateSolidBrush(color);
	dc.FillRect(rectangle,brush);
}

void CExBinView::DrawBackground(CDCHandle& dc, const CRect& area, 
	ulong x, ulong y, ulong w, COLORREF color,
	bool xscroll, bool yscroll)
{
	const ulong rowindex = doc_->GetScroll()->GetRowIndex();
	const ulong columnindex = doc_->GetScroll()->GetColumnIndex();
	const CSize& charactersize = drawinfo_.visual.charactersize;
	
	ulong visiblerowcount = GetVisibleRowCount();
	ulong xoffset = xscroll?columnindex:0;
	ulong yoffset = yscroll?rowindex:0;

	if(xscroll){
		if(xoffset>=x+w){
			return;
		}else if(xoffset>x){
			w = w+x-xoffset;
			x = xoffset;
		}
	}

	if(yscroll){
		if(yoffset>y){
			return;
		}else if(yoffset+visiblerowcount<=y){
			return;
		}
	}

	int px = area.left+(x-xoffset)*charactersize.cx;
	int py = area.top+(y-yoffset)*charactersize.cy;
	int pw = w*charactersize.cx;
	int ph = charactersize.cy;
	CRect rect(px,py,px+pw,py+ph);

	DrawRect(dc,rect,color);
}

void CExBinView::DrawString(CDCHandle& dc, const std::string& str, 
		const CRect& area, ulong x, ulong y, ulong w, COLORREF color,
		bool xscroll, bool yscroll)
{
	const ulong rowindex = doc_->GetScroll()->GetRowIndex();
	const ulong columnindex = doc_->GetScroll()->GetColumnIndex();
	const CSize& charactersize = drawinfo_.visual.charactersize;

	ulong visiblerowcount = GetVisibleRowCount();
	ulong xoffset = xscroll?columnindex:0;
	ulong yoffset = yscroll?rowindex:0;

	ulong diff = 0;

	if(xscroll){
		if(xoffset>=x+w){
			return;
		}else if(xoffset>x){
			diff = xoffset-x;
			w -= diff;
			x = xoffset;
		}
	}

	if(yscroll){
		if(yoffset>y){
			return;
		}else if(yoffset+visiblerowcount<=y){
			return;
		}
	}

	int px = area.left+(x-xoffset)*charactersize.cx;
	int py = area.top+(y-yoffset)*charactersize.cy;
	
	COLORREF oldcolor = dc.SetTextColor(color);
	dc.TextOutA(px,py,str.c_str()+diff);
	dc.SetTextColor(oldcolor);
}

void CExBinView::BlinkCursor()
{
	const CRect& mainarea = drawinfo_.visual.mainarea;

	const COLORREF& backgroundcolor = mainarea_backgroundcolor;
	const COLORREF& textcolor = mainarea_textcolor;
	const COLORREF& cursorcolor = mainarea_singlecursorcolor;

	if(CheckInEditRange(doc_)){
		ulong x,y;
		GetCursorPosition(x,y);
		LineFormat_ptr lineformat = doc_->GetFormat()->GetLine(y);
		ItemFormat format = lineformat->items[x];

		ulong cx = format.offset + format.bodyoffset;
		ulong cl = format.bodysize;
		std::string text = lineformat->text.substr(cx,cl);

		//J[\`
		CDCHandle dc(GetDC());
		COLORREF backcolor = cursorblink_?cursorcolor:backgroundcolor;
		DrawBackground(dc,mainarea,cx,y,cl,backcolor,true,true);
		int oldmode = dc.SetBkMode(TRANSPARENT);
		CFont font(MakeFont());
		HFONT oldfont = dc.SelectFont(font);
		DrawString(dc,text,mainarea,cx,y,cl,textcolor,true,true);
		dc.SelectFont(oldfont);
		dc.SetBkMode(oldmode);
		ReleaseDC(dc.m_hDC);

		//]
		cursorblink_ = !cursorblink_;
	}
}

LRESULT CExBinView::OnEraseBackGround(HDC /*hDC*/)
{
	return 1;
}

void CExBinView::OnTimer(UINT_PTR /*nIDEvent*/)
{
	if(timerid_){
		if(::IsChild(GetForegroundWindow(),m_hWnd)){
			//J[\_
			BlinkCursor();
		}else{
			//_Œ~
		}
	}
}

void CExBinView::OnVScroll(int nSBCode, short /*nPos*/, HWND /*hWnd*/)
{
	int current = GetVScrollPos();
	ulong rowcount = GetVisibleRowCount();

    switch(nSBCode){
    case SB_PAGEUP:	  current -= rowcount;       break;
	case SB_LINEUP:   current -= 1;              break;
    case SB_PAGEDOWN: current += rowcount;       break;
    case SB_LINEDOWN: current += 1;              break;
    case SB_TOP:      current = 0;               break;
    case SB_BOTTOM:   current = GetVMaxScroll(); break;
    case SB_THUMBPOSITION:
    case SB_THUMBTRACK:
		{
			SCROLLINFO scrollinfo;
			scrollinfo.cbSize = sizeof(SCROLLINFO);
			scrollinfo.fMask = SIF_TRACKPOS;
			GetVScrollInfo(&scrollinfo);
			current = scrollinfo.nTrackPos;
		}
        break;
    }

	if(current<0) current = 0;
	if(static_cast<int>(GetVMaxScroll())<=current) current = GetVMaxScroll();

	//̃XN[lXV
	doc_->GetScroll()->SetRowIndex(current);

	//ʍXV
	Refresh();

	SetMsgHandled(FALSE);

}

void CExBinView::OnHScroll(int nSBCode, short /*nPos*/, HWND /*hWnd*/)
{
	int current = GetHScrollPos();
	ulong columncount = GetVisibleColumnCount();

    switch(nSBCode){
    case SB_PAGELEFT:  current -= columncount;    break;
	case SB_LINELEFT:  current -= 1;              break;
    case SB_PAGERIGHT: current += columncount;    break;
	case SB_LINERIGHT: current += 1;              break;
    case SB_TOP:       current = 0;               break;
    case SB_BOTTOM:    current = GetHMaxScroll(); break;
    case SB_THUMBPOSITION:
    case SB_THUMBTRACK:
		{
			SCROLLINFO scrollinfo;
			scrollinfo.cbSize = sizeof(SCROLLINFO);
			scrollinfo.fMask = SIF_TRACKPOS;
			GetHScrollInfo(&scrollinfo);
			current = scrollinfo.nTrackPos;
		}
        break;
    }

	if(current<0) current = 0;
	if(static_cast<int>(GetHMaxScroll())<=current) current = GetHMaxScroll();

	//̃XN[lXV
	doc_->GetScroll()->SetColumnIndex(current);

	//ʍXV
	Refresh();
	
	SetMsgHandled(FALSE);
}

boost::optional<ulong> CExBinView::GetCursorPoint(const CPoint& point)
{
	const ulong rowoffset = doc_->GetScroll()->GetRowIndex();
	const ulong columnoffset = doc_->GetScroll()->GetColumnIndex();
	const CRect& mainarea = drawinfo_.visual.mainarea;
	const CSize& charactersize = drawinfo_.visual.charactersize;

	boost::optional<ulong> cursor_position;

	if(!mainarea.PtInRect(point)) return cursor_position;

	//Pʂł̉ʏʒuZo
	ulong cx = (point.x-mainarea.left)/charactersize.cx;
	ulong cy = (point.y-mainarea.top)/charactersize.cy;

	//XN[l𔽉f
	ulong sx = cx+columnoffset;
	ulong sy = cy+rowoffset;

	//݂̕\ł̈ʒuɃf[^邩𔻒
	if(sx>=doc_->GetFormat()->GetColumnCount(sy)) return cursor_position;

	//\J[\ʒuZo
	LineFormat_ptr format = doc_->GetFormat()->GetLine(sy);
	for(std::vector<ItemFormat>::const_iterator it=format->items.begin(); it!=format->items.end(); ++it){
		if(it->offset<=sx && sx<it->offset+it->size){
			cursor_position = it->index;
			break;
		}
	}
	
	return cursor_position;
}

void CExBinView::OnLButtonDown(UINT nFlags, CPoint point)
{
	nFlags;

	boost::optional<ulong> cursor_position = GetCursorPoint(point);
	Cursor_ptr cursor = doc_->GetCursor();

	//͏ԂZbg
	doc_->GetInputInfo()->Reset();

	//J[\ʒuZbg
	if(cursor_position){
		ulong pos = *cursor_position;
		cursor->Enable(true);
		cursor->SetPosition(pos);
		cursor->EnableAnchor(false);
		point_ = point;
		movelength_ = 0;
		anchor_candidate_ = pos;
	}else{
		cursor->Enable(false);
	}

	SetCapture();

	Refresh();
}

void CExBinView::OnMouseMove(UINT nFlags, CPoint point)
{
	if(nFlags!=MK_LBUTTON) return;
	
	boost::optional<ulong> cursor_position = GetCursorPoint(point);

	//J[\ʒuZbg
	if(cursor_position){
		doc_->GetCursor()->SetPosition(*cursor_position);
		
		//J[\̈ʒuς͈͑Iɐ؂ւ
		bool enable_anchor = false;
		if(*cursor_position==anchor_candidate_){
			//f[^̏ł苗͈͑I
			int move2 = (point.x-point_.x)*(point.x-point_.x)+(point.y-point_.y)*(point.y-point_.y);
			int threshold2 = drawinfo_.visual.charactersize.cx*drawinfo_.visual.charactersize.cx;
			movelength_ += move2;
			if(movelength_>threshold2){
				enable_anchor = true;
			}
		}else{
			enable_anchor = true;
		}
		if(enable_anchor){
			doc_->GetCursor()->SetAnchor(anchor_candidate_);
			doc_->GetCursor()->EnableAnchor(true);
		}

		Refresh();
	}else{
		const CRect& mainarea = drawinfo_.visual.mainarea;

		if(!mainarea.PtInRect(point)){
			Scroll_ptr scroll = doc_->GetScroll();

			int x = scroll->GetColumnIndex();
			int y = scroll->GetRowIndex();
			if(point.x<mainarea.left){
				x--;
			}else if(point.x>mainarea.right){
				x++;
			}
			if(point.y<mainarea.top){
				y--;
			}else if(point.y>mainarea.bottom){
				y++;
			}
			if(x<0) x = 0;
			if(x>=GetHMaxScroll()) x = GetHMaxScroll();
			if(y<0) y = 0;
			if(y>=GetVMaxScroll()) y = GetVMaxScroll();

			scroll->SetRowIndex(y);
			scroll->SetColumnIndex(x);
			
			Refresh();
		}
	}
}

void CExBinView::OnLButtonUp(UINT nFlags, CPoint point)
{
	nFlags;
	point;

	Cursor_ptr cursor = doc_->GetCursor();
	if(cursor->GetLength()>=1){
		AdjustRange(doc_);
		Refresh();
	}

	ReleaseCapture();
}

LRESULT CExBinView::OnMouseWheel(UINT nFlags, short zDelta, CPoint point)
{
	nFlags;
	point;

	uint scrollcount;
	SystemParametersInfo(SPI_GETWHEELSCROLLLINES,0,&scrollcount,0);

	int d = -(zDelta/WHEEL_DELTA)*scrollcount;
	int lineindex = static_cast<int>(doc_->GetScroll()->GetRowIndex());

	lineindex += d;

	if(lineindex<0){
		lineindex = 0;
	}else{
		int maxindex = GetVMaxScroll();
		if(lineindex>maxindex){
			lineindex = maxindex;
		}
	}

	doc_->GetScroll()->SetRowIndex(static_cast<ulong>(lineindex));

	Refresh();

	return 0;
}

void CExBinView::OnKeyDown(TCHAR vkey, UINT repeats, UINT code)
{
	repeats;
	code;

	bool update = OnKeyEvent(vkey);

	if(update){
		Refresh();
	}else{
		SetMsgHandled(FALSE);
	}
}

bool CExBinView::OnKeyEvent(int keycode)
{
	bool update = true;

	bool ctrl = (::GetAsyncKeyState(VK_CONTROL)&0x80000000)?true:false;
	bool shift = (::GetAsyncKeyState(VK_SHIFT)&0x80000000)?true:false;
	bool alt = (::GetAsyncKeyState(VK_MENU)&0x80000000)?true:false;

	CommandHandler_ptr commander = GetCommandHandler();

	if(keycode==VK_UP){
		commander->Command(ID_VIEW_MOVE_UP);
	}else if(keycode==VK_DOWN){
		commander->Command(ID_VIEW_MOVE_DOWN);
	}else if(keycode==VK_LEFT){
		commander->Command(ID_VIEW_MOVE_LEFT);
	}else if(keycode==VK_RIGHT){
		commander->Command(ID_VIEW_MOVE_RIGHT);
	}else if(keycode==VK_PRIOR){
		commander->Command(ID_VIEW_MOVE_PAGEUP);
	}else if(keycode==VK_NEXT){
		commander->Command(ID_VIEW_MOVE_PAGEDOWN);
	}else if(keycode==VK_HOME){
		commander->Command(ID_VIEW_MOVE_HEAD);
	}else if(keycode==VK_END){
		commander->Command(ID_VIEW_MOVE_TAIL);
	}else if(keycode==VK_ESCAPE){
		commander->Command(ID_VIEW_SELECT_RELEASE);
	}else if(keycode==VK_INSERT){
		doc_->SetInsertMode(!doc_->IsInsertMode());
	}else if((('0'<=keycode && keycode<='9') || ('a'<=keycode && keycode<='f') || ('A'<=keycode && keycode<='F')) &&
		     !ctrl && !shift && !alt){
		update = OnNumKeyEvent(keycode);
	}

	return update;
}

bool CExBinView::OnNumKeyEvent(int keycode)
{
	InputManager_ptr input = doc_->GetInputInfo();
	ulong previndex = input->GetIndex();
	ItemFormat format = input->GetFormat();

	if(previndex==0){
		ulong x,y;
		GetCursorPosition(x,y);
		format = doc_->GetFormat()->GetLine(y)->items[x];
		input->SetFormat(format);
	}

	input->Input(keycode);
	ulong currentindex = input->GetIndex();

	if(previndex==currentindex) return false;

	Cursor_ptr cursor = doc_->GetCursor();
	ulong cursor_position = cursor->GetStart();
	ulong size = doc_->Size();

	if(doc_->IsInsertMode() || cursor_position==size){
		//}[h
		if(previndex==0){
			//}
			if(currentindex==0){
				return false;
			}else{
				InsertData(cursor_position, format.bytecount, input->GetData());
			}
		}else{
			//㏑
			OverStrikeData(cursor_position, format.bytecount, input->GetData());
		}
	}else{
		//㏑[h
		OverStrikeData(cursor_position, format.bytecount, input->GetData());
	}

	if(input->IsCoincident()){
		*cursor = CursorInfo(cursor_position+1);
	}

	return true;
}

void CExBinView::OnSize(UINT /*nType*/, CSize size)
{
	//`vf̍XV
	UpdateDrawInfo(size);

	//XN[̗}
	CheckVOffset();
	CheckHOffset();

	//XN[o[̍XV
	SetupScrollBar();
}

void CExBinView::OnFileDrop(const std::string& filepath)
{
	FileCommand::Open(doc_.get(),m_hWnd,filepath);
}


void CExBinView::UpdateDrawInfo(const CSize& clientsize)
{	
	CRect& clientarea = drawinfo_.visual.clientarea;
	CRect& headerarea = drawinfo_.visual.headerarea;
	CRect& headerarea_margin = drawinfo_.visual.headerarea_margin;
	CRect& addressarea = drawinfo_.visual.addressarea;
	CRect& addressarea_margin = drawinfo_.visual.addressarea_margin;
	CRect& mainarea = drawinfo_.visual.mainarea;
	CRect& mainarea_margin = drawinfo_.visual.mainarea_margin;
	CSize& charactersize = drawinfo_.visual.charactersize;
	CSize& linesize = drawinfo_.visual.linesize;
	ulong& addresscolumn = drawinfo_.visual.addresscolumn;

	CClientDC dc(m_hWnd);

	//TCY擾
	dc.GetTextExtent("0",1,&charactersize);

	//CTCY擾
	linesize.cx = 0; //TODO : svȂ̂ō
	linesize.cy = charactersize.cy;

	//ʃp[c̑傫擾
	addresscolumn = get_max_address_column(doc_->Size());

	//ʐ@擾
	clientarea.SetRect(0,0,clientsize.cx,clientsize.cy);
	headerarea_margin.SetRect(0,0,clientarea.right,charactersize.cy);
	headerarea.SetRect((addresscolumn+1)*charactersize.cx+charactersize.cx/2,headerarea_margin.top,
		headerarea_margin.right,headerarea_margin.bottom);
	addressarea_margin.SetRect(0,headerarea.bottom,(addresscolumn+1)*charactersize.cx,clientarea.bottom);
	addressarea.SetRect(addressarea_margin.left+charactersize.cx/2,addressarea_margin.top,
		addressarea_margin.right-charactersize.cx/2,addressarea_margin.bottom);
	mainarea_margin.SetRect(addressarea_margin.right,headerarea.bottom,clientarea.right,clientarea.bottom);
	mainarea.SetRect(mainarea_margin.left+charactersize.cx/2,mainarea_margin.top,
		mainarea_margin.right-charactersize.cx/2,mainarea_margin.bottom);

	//f[^\\擾
	Scroll_ptr scroll = doc_->GetScroll();
	scroll->SetRowCount(mainarea.Height()/linesize.cy);
	scroll->SetColumnCount(mainarea.Width()/charactersize.cx);
}

void CExBinView::CheckVOffset()
{
	ulong rowindex = doc_->GetScroll()->GetRowIndex();

	ulong rowcount = GetRowCount();
	ulong visiblerowcount = GetVisibleRowCount();
	ulong restline = rowcount-rowindex;

	if(rowindex && restline<visiblerowcount){
		ulong back = visiblerowcount-restline;
		if(back>rowindex){
			rowindex = 0;
		}else{
			rowindex -= back;
		}
	}

	doc_->GetScroll()->SetRowIndex(rowindex);
}

void CExBinView::CheckHOffset()
{
	ulong columnindex = doc_->GetScroll()->GetColumnIndex();

	ulong columncount = GetMaxColumnCount();
	ulong visiblecolumncount = GetVisibleColumnCount();
	ulong restcolumn = columncount-columnindex;

	if(columnindex && restcolumn<visiblecolumncount){
		ulong back = visiblecolumncount-restcolumn;
		if(back>columnindex){
			columnindex = 0;
		}else{
			columnindex -= back;
		}
	}

	doc_->GetScroll()->SetColumnIndex(columnindex);
}

void CExBinView::SetupScrollBar()
{
	ulong vscrollmin = 0;
	ulong vscrollmax = GetVMaxScroll();

	ulong hscrollmin = 0;
	ulong hscrollmax = GetHMaxScroll();

	SetVScrollRange(vscrollmin,vscrollmax);
	SetHScrollRange(hscrollmin,hscrollmax);
}

bool CExBinView::IsVScrollBarNeeded() const
{
	return (GetRowCount()>GetVisibleRowCount());
}

bool CExBinView::IsHScrollBarNeeded() const
{
	return (GetMaxColumnCount()>GetVisibleColumnCount());
}

ulong CExBinView::GetRowCount() const
{
	return doc_->GetFormat()->GetRowCount();
}

ulong CExBinView::GetMaxColumnCount() const
{
	return doc_->GetFormat()->GetMaxColumnCount();
}

ulong CExBinView::GetVisibleRowCount() const
{
	return doc_->GetScroll()->GetRowCount();
}

ulong CExBinView::GetVisibleColumnCount() const
{
	return doc_->GetScroll()->GetColumnCount();
}

int CExBinView::GetVMaxScroll() const
{
	int rowcount = GetRowCount();
	int visiblerowcount = GetVisibleRowCount();
	if(!visiblerowcount || rowcount<=visiblerowcount){
		return 0;
	}else{
		return rowcount-visiblerowcount;
	}
}

int CExBinView::GetHMaxScroll() const
{	
	int columncount = GetMaxColumnCount();
	int visiblecolumncount = GetVisibleColumnCount();
	if(!visiblecolumncount || columncount<=visiblecolumncount){
		return 0;
	}else{
		return columncount-visiblecolumncount;
	}
}

void CExBinView::MakeAddressText(char *buffer, ulong address, ulong addresscolumn)
{
	char pattern[10+1];
	if(addresscolumn>10) addresscolumn = 10;
	sprintf(pattern,"%%0%dX",addresscolumn);
	sprintf(buffer,pattern,address);
}

void CExBinView::GetCursorPosition(ulong& x, ulong& y)
{
	ulong cursorpos = doc_->GetCursor()->GetPosition();
	y = doc_->GetFormat()->Offset2LineIndex(cursorpos);
	x = cursorpos - doc_->GetFormat()->LineIndex2Offset(y); 
}

bool CExBinView::InsertData(ulong offset, ulong size, ulong data)
{
	data = ConvertEndian(data,size);
	MemoryData memory(new uchar[size]);
	memcpy(memory.get(),&data,size);
	MemoryBlock block(memory,size);
	CursorInfo newposition(offset);

	ActionList list;
	list.push_back(Action_ptr(new InsertAction(doc_.get(),block,offset)));
	list.push_back(Action_ptr(new CursorAction(doc_.get(),newposition)));
	doc_->DoAction(list);

	return true;
}

bool CExBinView::OverStrikeData(ulong offset, ulong size, ulong data)
{
	data = ConvertEndian(data,size);
	MemoryData memory(new uchar[size]);
	memcpy(memory.get(),&data,size);
	MemoryBlock block(memory,size);
	CursorInfo newposition(offset);

	ActionList list;
	list.push_back(Action_ptr(new OverStrikeAction(doc_.get(),block,offset)));
	list.push_back(Action_ptr(new CursorAction(doc_.get(),newposition)));
	doc_->DoAction(list);

	return true;
}

ulong CExBinView::ConvertEndian(ulong data, ulong size)
{
	//TODO : GfBAݒɍ킹ĕϊ
	size;
	return data;
}
