// ExBinView.h : interface of the CExBinView class
//
/////////////////////////////////////////////////////////////////////////////

#pragma once

#include <atlmisc.h>
#include <atlcrack.h>
#include "DrawInfo.h"
#include "Formatter.h"
#include "Document.h"
#include "CommandHandler.h"
#include "ScrollView.h"
#include "UIUpdater.h"
#include "DropTarget.h"
#include <boost/optional.hpp>

class CExBinView : public CDoubleBufferWindowImpl<CExBinView,CScrollView>,
				   public IDocumentAccessor,
	               public IDocumentEventListener,
				   public ICommander,
				   public StatusBarUpdater
{
public:
	DECLARE_WND_CLASS_EX(NULL,CS_DBLCLKS|CS_HREDRAW|CS_VREDRAW,COLOR_WINDOW)

	CExBinView();

	BOOL PreTranslateMessage(MSG* pMsg);

	typedef CDoubleBufferWindowImpl<CExBinView,CScrollView> baseclass;

	//bZ[W}bv
	BEGIN_MSG_MAP_EX(CExBinView)
		MSG_WM_CREATE(OnCreate)
		MSG_WM_DESTROY(OnDestroy)
		MSG_WM_SIZE(OnSize)
		MSG_WM_VSCROLL(OnVScroll)
		MSG_WM_HSCROLL(OnHScroll)
		MSG_WM_LBUTTONDOWN(OnLButtonDown)
		MSG_WM_MOUSEMOVE(OnMouseMove)
		MSG_WM_LBUTTONUP(OnLButtonUp)
		MSG_WM_MOUSEWHEEL(OnMouseWheel)
		MSG_WM_KEYDOWN(OnKeyDown)
		MSG_WM_TIMER(OnTimer)
		CHAIN_MSG_MAP(baseclass)
	END_MSG_MAP()

// Handler prototypes (uncomment arguments if needed):
//	LRESULT MessageHandler(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/)
//	LRESULT CommandHandler(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
//	LRESULT NotifyHandler(int /*idCtrl*/, LPNMHDR /*pnmh*/, BOOL& /*bHandled*/)

	//I[o[Ch
	void DoPaint(CDCHandle dc);										//`
	virtual void OnUpdate(IDocumentEventListener::EventType type);

	//Cxgnh
	LRESULT OnCreate(LPCREATESTRUCT lpCreateStruct);				//EBhECxg
	void OnDestroy();												//EBhEjCxg
	LRESULT OnEraseBackGround(HDC hDC);								//wiĕ`}
	void OnVScroll(int nSBCode, short nPos, HWND hWnd);				//㉺XN[Cxg
	void OnHScroll(int nSBCode, short nPos, HWND hWnd);				//EXN[Cxg
	void OnLButtonDown(UINT nFlags, CPoint point);					//NbNCxg()
	void OnMouseMove(UINT nFlags, CPoint point);					//}EXړCxg
	void OnLButtonUp(UINT nFlags, CPoint point);					//NbNCxg(߂)
	LRESULT OnMouseWheel(UINT nFlags, short zDelta, CPoint point);	//}EXzC[Cxg
	void OnKeyDown(TCHAR vkey, UINT repeats, UINT code);			//L[̓Cxg
	void OnSize(UINT nType, CSize size);							//EBhETCYύXCxg
	void OnTimer(UINT_PTR nIDEvent);								//J[\p^C}Cxg
	void OnFileDrop(const std::string& filepath);

private:
	DrawInfo drawinfo_;												//`ɕKvȏ
	UINT_PTR timerid_;												//J[\_ŗp^C}ID
	bool cursorblink_;												//J[\_ŏ
	ulong anchor_candidate_;										//J[\_
	CPoint point_;													//hbOʎZo_
	int movelength_;												//hbO
	ATL::CComPtr<IDropTarget> droptarget_;							//D&DppCOMIuWFNg

	void Refresh();													//r[č\z

	void ResetInnerData(const CSize& clientsize);					//Ԃ
	void UpdateDrawInfo(const CSize& clientsize);					//`f[^XV(`OĂяo)
	void CheckVOffset();											//㉺XN[̏ԓK
	void CheckHOffset();											//EXN[̏ԓK
	void SetupScrollBar();											//XN[o[ԏ
	void ResetTimer();												//J[\_ŊJn
	
	boost::optional<ulong> GetCursorPoint(const CPoint& point);		//J[\̍W擾
	
	bool IsVScrollBarNeeded() const;								//㉺XN[o[̗vsv
	bool IsHScrollBarNeeded() const;								//EXN[o[̗vsv
	ulong GetRowCount() const;										//f[^̍s擾
	ulong GetMaxColumnCount() const;								//f[^̍ő񐔎擾
	ulong GetVisibleRowCount() const;								//ʓ̕\\s
	ulong GetVisibleColumnCount() const;							//ʓ̕\\
	int GetVMaxScroll() const;										//㉺XN[̍ől擾
	int GetHMaxScroll() const;										//EXN[̍ől擾

	HFONT MakeFont();
	void DrawAddressArea(CDCHandle& dc);
	void DrawMainArea(CDCHandle& dc);
	void DrawHeaderArea(CDCHandle& dc);
	void DrawRect(CDCHandle& dc, const CRect& rectangle, COLORREF color);
	void DrawBackground(CDCHandle& dc, const CRect& area, 
		ulong x, ulong y, ulong w, COLORREF color,
		bool xscroll, bool yscroll);
	void DrawString(CDCHandle& dc, const std::string& str, 
		const CRect& area, ulong x, ulong y, ulong w, COLORREF color,
		bool xscroll, bool yscroll);
	void BlinkCursor();

	void GetCursorPosition(ulong& x, ulong& y);
	void MakeAddressText(char *buffer, ulong address, ulong addresscolumn);
	bool OnKeyEvent(int keycode);
	bool OnNumKeyEvent(int keycode);

	bool InsertData(ulong offset, ulong size, ulong data);
	bool OverStrikeData(ulong offset, ulong size, ulong data);

	ulong ConvertEndian(ulong data, ulong size);
};
