#include "stdafx.h"
#include "FileCommand.h"
#include "Document.h"
#include <io.h>

namespace FileCommand
{
	Reply::Code Open(Document* document, HWND hWnd, const std::string& filepath)
	{
		if(!document->Open(filepath)){
			ErrorMessage_FileOpen(hWnd);
			return Reply::Error;
		}
		return Reply::OK;
	}

	Reply::Code Close(Document* document, HWND hWnd)
	{
		if(document->IsModified()){
			Reply::Code reply = Ask2Save(hWnd,document->GetFilePath());
			if(reply==Reply::Cancel){
				return Reply::Cancel;
			}else if(reply==Reply::Yes){
				Reply::Code saved = Save(document,hWnd);
				if(saved==Reply::Cancel){
					return Reply::Cancel;
				}
			}
		}
		return Reply::OK;
	}

	Reply::Code Save(Document* document, HWND hWnd)
	{
		std::string filepath = document->GetFilePath();
		if(_access(filepath.c_str(),0)==0){
			if(document->Save(filepath)){
				return Reply::OK;
			}else{
				ErrorMessage_FileSave(hWnd);
				return Reply::Error;
			}
		}else{
			return SaveAs(document,hWnd);
		}
	}

	Reply::Code SaveAs(Document* document, HWND hWnd)
	{
		std::string filepath;
		Reply::Code reply = GetSaveFilePath(hWnd,filepath);
		if(reply==Reply::OK){
			if(document->Save(filepath)){
				return Reply::OK;
			}else{
				ErrorMessage_FileSave(hWnd);
				return Reply::Error;
			}
		}
		return reply;
	}


}

