#include "stdafx.h"
#include "InputManager.h"

InputManager::InputManager()
{
	Reset();
}

void InputManager::Reset()
{
	data_ = 0;
	index_ = 0;
}

void InputManager::SetFormat(const ItemFormat& format)
{
	format_ = format;
}

ItemFormat InputManager::GetFormat() const
{
	return format_;
}

void InputManager::Input(int keycode)
{
	if(IsCoincident())
		Reset();

	int value = 0;
	switch(format_.type){
		case Format::None:
			break;
		case Format::Binary:
			if(ReadBinary(keycode,value)){
				data_ <<= 1;
				data_ += value;
				index_++;
			}
			break;
		case Format::Octal:
			if(ReadOctal(keycode,value)){
				data_ <<= 3;
				data_ += value;
				index_++;
			}
			break;
		case Format::Decimal:
			if(ReadDecimal(keycode,value)){
				data_ *= 10;
				data_ += value;
				index_++;
			}
			break;
		case Format::Hex:
			if(ReadHex(keycode,value)){
				data_ <<= 4;
				data_ += value;
				index_++;
			}
			break;
		default:
			break;
	}
}

bool InputManager::IsCoincident() const
{
	if(format_.type!=Format::None && format_.bodysize==index_){
		return true;
	}else{
		return false;
	}
}

ulong InputManager::GetData() const
{
	return data_;
}

bool InputManager::ReadBinary(int keycode, int& value)
{
	if(keycode=='0'){
		value = 0;
		return true;
	}else if(keycode=='1'){
		value = 1;
		return true;
	}else{
		return false;
	}
}

bool InputManager::ReadOctal(int keycode, int& value)
{
	if('0'<=keycode && keycode<='7'){
		value = keycode-'0';
		return true;
	}else{
		return false;
	}
}

bool InputManager::ReadDecimal(int keycode, int& value)
{
	if('0'<=keycode && keycode<='9'){
		value = keycode-'0';
		return true;
	}else{
		return false;
	}
}

bool InputManager::ReadHex(int keycode, int& value)
{
	if('0'<=keycode && keycode<='9'){
		value = keycode-'0';
		return true;
	}else if('a'<=keycode && keycode<='f'){
		value = keycode-'a'+10;
		return true;
	}else if('A'<=keycode && keycode<='F'){
		value = keycode-'A'+10;
		return true;
	}else{
		return false;
	}
}

ulong InputManager::GetIndex() const
{
	if(IsCoincident()){
		return 0;
	}else{
		return index_;
	}
}
