// MainFrm.cpp : implmentation of the CMainFrame class
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include "aboutdlg.h"
#include "ExBinView.h"
#include "MainFrm.h"
#include "Document.h"
#include "MessageDialog.h"
#include "FileCommand.h"
#include "Utility.h"
#include "ClipBoard.h"
#include <boost/format.hpp>
#include <boost/tokenizer.hpp>
#include <io.h>

extern CAppModule _Module;

void CMainFrame::SetCommandLine(char *commandline)
{
	std::string str = commandline;

	typedef boost::escaped_list_separator<char> separator_type;
	typedef boost::tokenizer<separator_type> tokenizer_type;
	separator_type separator(0);
	tokenizer_type tokens(str,separator);

	tokenizer_type::iterator it = tokens.begin();
	if(it!=tokens.end()){
		std::string filepath = *it;
		if(_access(filepath.c_str(),0)==0){
			initialfilepath_ = filepath;
		}
	}
}

BOOL CMainFrame::PreTranslateMessage(MSG* pMsg)
{
	if(CFrameWindowImpl<CMainFrame>::PreTranslateMessage(pMsg))
		return TRUE;

	return m_view.PreTranslateMessage(pMsg);
}

BOOL CMainFrame::OnIdle()
{
	SendMessage(WM_UPDATE_TOOLBAR,reinterpret_cast<WPARAM>(hWndToolBar_),0);
	return FALSE;
}

LRESULT CMainFrame::OnCreate(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/)
{
	//CX^XԂ̊֌W
	InitMVC();

	//qEBhE
	HWND hWndCmdBar = InitCommandBar();					//j[o[
	HWND hWndToolBar = hWndToolBar_ = InitToolBar();	//c[o[
	CreateSimpleReBar(ATL_SIMPLE_REBAR_NOBORDER_STYLE);	//o[
	AddSimpleReBarBand(hWndCmdBar);
	AddSimpleReBarBand(hWndToolBar, NULL, TRUE);
	InitStatusBar();									//Xe[^Xo[

	//r[
	m_hWndClient = m_view.Create(m_hWnd, rcDefault, NULL, 
		WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_CLIPCHILDREN | WS_VSCROLL,
		WS_EX_CLIENTEDGE);

	// register object for message filtering and idle updates
	CMessageLoop* pLoop = _Module.GetMessageLoop();
	ATLASSERT(pLoop != NULL);
	pLoop->AddMessageFilter(this);
	pLoop->AddIdleHandler(this);

	// w肪ꍇ̓t@Cǂݍ
	if(initialfilepath_.size()){
		FileCommand::Open(doc_.get(),m_hWnd,initialfilepath_);
	}

	return 0;
}

LRESULT CMainFrame::OnDestroy(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& bHandled)
{
	// unregister message filtering and idle updates
	CMessageLoop* pLoop = _Module.GetMessageLoop();
	ATLASSERT(pLoop != NULL);
	pLoop->RemoveMessageFilter(this);
	pLoop->RemoveIdleHandler(this);

	//Nbv{[hf[^j
	ClipBoardManager::Release();

	bHandled = FALSE;
	return 1;
}

LRESULT CMainFrame::OnClose(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/)
{
	bool close = FileCommand::Close(doc_.get(),m_hWnd)==Reply::OK;
	if(close){
		return DefWindowProc(); //throw WM_DESTROY
	}else{
		return 0;
	}
}

LRESULT CMainFrame::OnFileExit(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	PostMessage(WM_CLOSE);
	return 0;
}

LRESULT CMainFrame::OnViewToolBar(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	static BOOL bVisible = TRUE;	// initially visible
	bVisible = !bVisible;
	CReBarCtrl rebar = m_hWndToolBar;
	int nBandIndex = rebar.IdToIndex(ATL_IDW_BAND_FIRST + 1);	// toolbar is 2nd added band
	rebar.ShowBand(nBandIndex, bVisible);
	UISetCheck(ID_VIEW_TOOLBAR, bVisible);
	UpdateLayout();
	return 0;
}

LRESULT CMainFrame::OnViewStatusBar(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	BOOL bVisible = !::IsWindowVisible(m_hWndStatusBar);
	::ShowWindow(m_hWndStatusBar, bVisible ? SW_SHOWNOACTIVATE : SW_HIDE);
	UISetCheck(ID_VIEW_STATUS_BAR, bVisible);
	UpdateLayout();
	return 0;
}

LRESULT CMainFrame::OnAppAbout(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	CAboutDlg dlg;
	dlg.DoModal();
	return 0;
}

void CMainFrame::InitMVC()
{
	//R}hnh
	commandhandler_.reset(new CommandHandler());

	//hLg
	doc_.reset(new Document());
	
	doc_->New();

	//hLgɃr[Zbg
	doc_->AddListener(&m_view);
	doc_->AddListener(this);

	//r[ɃhLgZbg
	m_view.SetDocument(doc_);

	//r[ɃR}hnhZbg
	m_view.SetCommandHandler(commandhandler_);

	//R}hnhɃhLgZbg
	commandhandler_->SetDocument(doc_);

	//R}hnhɃEBhEnhZbg
	commandhandler_->SetWindow(m_hWnd);
}

TBBUTTON CMainFrame::buttondata_[] = {
	{ 0, ID_FILE_NEW, TBSTATE_ENABLED, TBSTYLE_BUTTON },
	{ 1, ID_FILE_OPEN, TBSTATE_ENABLED, TBSTYLE_BUTTON },
	{ 2, ID_FILE_SAVE, TBSTATE_ENABLED, TBSTYLE_BUTTON },
	{ 10, 0, 0, TBSTYLE_SEP },
	{ 3, ID_EDIT_UNDO, TBSTATE_ENABLED, TBSTYLE_BUTTON },
	{ 4, ID_EDIT_REDO, TBSTATE_ENABLED, TBSTYLE_BUTTON },
	{ 10, 0, 0, TBSTYLE_SEP },
	{ 5, ID_EDIT_CUT, TBSTATE_ENABLED, TBSTYLE_BUTTON },
	{ 6, ID_EDIT_COPY, TBSTATE_ENABLED, TBSTYLE_BUTTON },
	{ 7, ID_EDIT_PASTE, TBSTATE_ENABLED, TBSTYLE_BUTTON },
	{ 8, ID_EDIT_CLEAR, TBSTATE_ENABLED, TBSTYLE_BUTTON },
};

HWND CMainFrame::InitCommandBar()
{
	HIMAGELIST hImageList = ImageList_LoadImage(_Module.GetResourceInstance(),
		MAKEINTRESOURCE(IDR_ICON_ENABLE), 16, 1, RGB(255,0,255), IMAGE_BITMAP,
		LR_CREATEDIBSECTION|LR_DEFAULTSIZE);
	HIMAGELIST hImageListDisable = ImageList_LoadImage(_Module.GetResourceInstance(),
		MAKEINTRESOURCE(IDR_ICON_DISABLE), 16, 1, RGB(255,0,255), IMAGE_BITMAP,
		LR_CREATEDIBSECTION|LR_DEFAULTSIZE);

	// create command bar window
	HWND hWndCmdBar = m_CmdBar.Create(m_hWnd, rcDefault, NULL, ATL_SIMPLE_CMDBAR_PANE_STYLE);
	m_CmdBar.SetImageMaskColor(RGB(255,0,255));
	// attach menu
	m_CmdBar.AttachMenu(GetMenu());
	// load command bar images
	m_CmdBar.SetImageSize(16,16);
	m_CmdBar.SetEnabledImageList(hImageList);
	m_CmdBar.SetDisabledImageList(hImageListDisable);
	// set icon-command map
	for(int i=0; i<sizeof(buttondata_)/sizeof(TBBUTTON); i++){
		if(buttondata_[i].idCommand){
			m_CmdBar.m_arrCommand.Add(static_cast<WORD>(buttondata_[i].idCommand));
		}
	}
	
	// remove old menu
	SetMenu(NULL);

	return hWndCmdBar;
}

HWND CMainFrame::InitToolBar()
{
	HIMAGELIST hImageList = ImageList_LoadImage(_Module.GetResourceInstance(),
		MAKEINTRESOURCE(IDR_ICON_ENABLE), 16, 1, RGB(255,0,255), IMAGE_BITMAP,
		LR_CREATEDIBSECTION|LR_DEFAULTSIZE);
	HIMAGELIST hImageListDisable = ImageList_LoadImage(_Module.GetResourceInstance(),
		MAKEINTRESOURCE(IDR_ICON_DISABLE), 16, 1, RGB(255,0,255), IMAGE_BITMAP,
		LR_CREATEDIBSECTION|LR_DEFAULTSIZE);
	
	CToolBarCtrl toolbar;
	toolbar.Create(m_hWnd,NULL,NULL,ATL_SIMPLE_TOOLBAR_PANE_STYLE,0,ATL_IDW_TOOLBAR);
	toolbar.SetImageList(hImageList);
	toolbar.SetDisabledImageList(hImageListDisable);
	toolbar.SetButtonStructSize();
	toolbar.AddButtons(sizeof(buttondata_)/sizeof(TBBUTTON),&buttondata_[0]);
	
	CImageList cmdbarImageList;
	cmdbarImageList.Duplicate(hImageList);
	m_CmdBar.SetImageList(cmdbarImageList);
	//m_CmdBar.AddButtons(sizeof(buttondata)/sizeof(TBBUTTON),&buttondata[0]);
	

	return toolbar.Detach();
}

void CMainFrame::InitStatusBar()
{
	m_view.SetOwner(this);

	m_hWndStatusBar = m_StatusBar.Create(m_hWnd);
	int PaneList[] = { ID_DEFAULT_PANE, IDS_PANE_DATASIZE, IDS_PANE_INSERTMODE };
	m_StatusBar.SetPanes(PaneList,sizeof(PaneList)/sizeof(int),false);

	OnStatusBarUpdate();
}

std::string CommaFormatting(ulong num)
{
	std::string text = (boost::format("%d") % num).str();
	std::string ret;

	std::string::size_type length = text.size();
	for(std::string::size_type i=0; i<length; i++){
		if(i && (length-i)%3==0){
			ret.push_back(',');
		}
		ret.push_back(text[i]);
	}

	return ret;
}

static std::string LoadResourceString(UINT uID)
{
	char buffer[100];
	LoadString(_Module.GetResourceInstance(),uID,buffer,100);
	return buffer;
}

void CMainFrame::OnStatusBarUpdate()
{
	bool insertmode = doc_->IsInsertMode();
	std::string text_insertmode = insertmode?"}":"㏑";
	m_StatusBar.SetPaneText(IDS_PANE_INSERTMODE,text_insertmode.c_str());

	ulong datasize = doc_->Size();
	std::string text_tmp1 = CommaFormatting(datasize);
	std::string text_tmp2 = (boost::format("\t\t%s byte") % text_tmp1).str();
	std::string text_datasize = (datasize>=2)?((boost::format("%ss") % text_tmp2).str()):text_tmp2;
	m_StatusBar.SetPaneText(IDS_PANE_DATASIZE,text_datasize.c_str());

	Cursor_ptr cursor = doc_->GetCursor();
	if(cursor->IsEnable()){
		std::string text_main;
		ulong column = get_max_address_column(doc_->Size());
		if(cursor->IsEnableAnchor()){
			std::string text_format =
				(boost::format("[%%0%2dX-%%0%2dX] 0x%%X(%%d)") % column % column).str();
			text_main = 
				(boost::format(text_format.c_str()) 
				 % cursor->GetStart() % cursor->GetEnd() % cursor->GetLength() % cursor->GetLength()
				 ).str();
		}else{
			std::string text_format = (boost::format("<%%0%2dX>") % column).str();
			text_main = (boost::format(text_format.c_str()) % cursor->GetPosition()).str();
		}
		m_StatusBar.SetPaneText(ID_DEFAULT_PANE,text_main.c_str());
	}else{
		m_StatusBar.SetPaneText(ID_DEFAULT_PANE,"");
	}
}

void CMainFrame::OnUpdate(IDocumentEventListener::EventType /*type*/)
{
	const std::string filepath = doc_->GetFilePath();

	char titlebuffer[100];
	LoadString(_Module.GetResourceInstance(),IDR_MAINFRAME,titlebuffer,100);
	std::string title = titlebuffer;

	std::string modify = doc_->IsModified()?" * ":"   ";

	std::string caption;
	if(filepath.empty()){
		caption = title;
	}else{
		caption = title + " - " + filepath + modify;
	}
	
	SetWindowText(caption.c_str());
	OnStatusBarUpdate();
}