#include "stdafx.h"
#include "SearchDialog.h"
#include <boost/algorithm/string/trim.hpp>
#include <boost/tokenizer.hpp>
#include <boost/optional.hpp>
#include <vector>
#include "Utility.h"

const int SearchDialog::IDD = IDD_DIALOG_SEARCH;

SearchDialog::SearchDialog()
	: method_(0)
{
}

bool SearchDialog::IsDirectionForward() const
{
	return forward_;
}

MemoryBlock SearchDialog::GetData() const
{
	return memory_;
}

BOOL SearchDialog::DoDataExchange(BOOL bSaveAndValidate, UINT nCtlID)
{
	DDX_RADIO(IDC_RADIO_METHOD_HEX,method_);

	if(bSaveAndValidate){
		char buffer[100];
		DDX_TEXT(IDC_EDIT_DATA,buffer);
		std::string str = buffer;

		if(method_==0){
			return InterpretHex(str,memory_)?TRUE:FALSE;
		}else if(method_==1){
			return InterpretString(str,memory_)?TRUE:FALSE;
		}else{
			return FALSE;
		}
	}

	return TRUE;
}

LRESULT SearchDialog::OnInitDialog(HWND hWnd, LPARAM lParam)
{
	hWnd;
	lParam;

	CenterWindow();

	DoDataExchange(FALSE);

	return 0;
}

LRESULT SearchDialog::OnBackwardSearch(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
	wNotifyCode;
	wID;
	hWndCtl;
	bHandled;

	if(DoDataExchange(TRUE)){
		forward_ = false;
		EndDialog(IDOK);
	}
	return 0;
}

LRESULT SearchDialog::OnForwardSearch(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
	wNotifyCode;
	wID;
	hWndCtl;
	bHandled;

	if(DoDataExchange(TRUE)){
		forward_ = true;
		EndDialog(IDOK);
	}
	return 0;
}

LRESULT SearchDialog::OnCancel(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
	wNotifyCode;
	wID;
	hWndCtl;
	bHandled;

	EndDialog(IDCANCEL);
	return 0;
}

bool SearchDialog::InterpretHex(const std::string& str, MemoryBlock& memory)
{
	std::string text = str;
	boost::algorithm::trim(text);
	std::vector<uchar> data; 

	if(text.find(' ')!=std::string::npos){
		//AA BB CCƕĂƉ肵āA1oCg
		typedef boost::char_separator<char> separator_type;
		typedef boost::tokenizer<separator_type> tokenizer_type;
		separator_type separator(" \t");
		tokenizer_type tokens(text,separator);
		for(tokenizer_type::iterator it=tokens.begin(); it!=tokens.end(); ++it){
			boost::optional<ulong> hex = convert_from_hexstring(*it);
			if(hex){
				data.push_back(static_cast<uchar>(*hex));
			}else{
				return false;
			}
		}
	}else{
		//ABBCCƘAĂƉ肵ĉ
		int length = static_cast<int>(text.size());
		if(length%2==1){
			text.insert(0,1,'0');
			length++;
		}
		
		for(int i=0; i<length; i+=2){
			std::string byte = text.substr(i,2);
			boost::optional<ulong> hex = convert_from_hexstring(byte);
			if(hex){
				data.push_back(static_cast<uchar>(*hex));
			}else{
				return false;
			}
		}
	}

	ulong size = static_cast<ulong>(data.size());
	if(size){
		memory.size = size;
		memory.data = MemoryData(new uchar[memory.size]);
		memcpy(memory.data.get(),&data[0],memory.size);
		return true;
	}else{
		return false;
	}
}

bool SearchDialog::InterpretString(const std::string& str, MemoryBlock& memory)
{
	memory.size = str.size();
	memory.data = MemoryData(new uchar[memory.size]);
	memcpy(memory.data.get(),str.c_str(),memory.size);

	return true;
}
